/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs.predicates;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.MiscCodecs;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;

public record DragonStagePredicate(Optional<HolderSet<DragonStage>> dragonStage, Optional<MinMaxBounds.Doubles> growthPercentage, Optional<MinMaxBounds.Doubles> size) {
    public static final Codec<DragonStagePredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.homogeneousList(DragonStage.REGISTRY).optionalFieldOf("dragon_stage").forGetter(DragonStagePredicate::dragonStage), (App)MiscCodecs.percentageBounds().optionalFieldOf("growth_percentage").forGetter(DragonStagePredicate::growthPercentage), (App)MinMaxBounds.Doubles.CODEC.optionalFieldOf("growth").forGetter(DragonStagePredicate::size)).apply((Applicative)instance, DragonStagePredicate::new));

    public boolean matches(Holder<DragonStage> stage, double growth) {
        if (stage == null) {
            return false;
        }
        if (this.dragonStage().isPresent() && !this.dragonStage().get().contains(stage)) {
            return false;
        }
        if (this.growthPercentage().isPresent() && !this.growthPercentage().get().matches(((DragonStage)stage.value()).getProgress(growth))) {
            return false;
        }
        return !this.size().isPresent() || this.size().get().matches(growth);
    }

    public static class Builder {
        private Optional<HolderSet<DragonStage>> dragonStage = Optional.empty();
        private Optional<MinMaxBounds.Doubles> progress = Optional.empty();
        private Optional<MinMaxBounds.Doubles> growth = Optional.empty();

        public static Builder start() {
            return new Builder();
        }

        public Builder stage(Holder<DragonStage> dragonStage) {
            this.dragonStage = Optional.of(HolderSet.direct((Holder[])new Holder[]{dragonStage}));
            return this;
        }

        public Builder progress(MinMaxBounds.Doubles progress) {
            this.progress = Optional.of(progress);
            return this;
        }

        public Builder progressAtLeast(double percentage) {
            this.progress = Optional.of(MinMaxBounds.Doubles.atLeast((double)percentage));
            return this;
        }

        public Builder growth(MinMaxBounds.Doubles growth) {
            this.growth = Optional.of(growth);
            return this;
        }

        public Builder growthBetween(double min, double max) {
            this.growth = Optional.of(MinMaxBounds.Doubles.between((double)min, (double)max));
            return this;
        }

        public Builder growthAtLeast(double min) {
            this.growth = Optional.of(MinMaxBounds.Doubles.atLeast((double)min));
            return this;
        }

        public Builder growthAtMost(double max) {
            this.growth = Optional.of(MinMaxBounds.Doubles.atLeast((double)max));
            return this;
        }

        public DragonStagePredicate build() {
            return new DragonStagePredicate(this.dragonStage, this.progress, this.growth);
        }
    }
}

