/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.registry.DSDataMaps;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class StageResources {
    public static final Codec<Map<ResourceKey<DragonStage>, StageResource>> CODEC = Codec.unboundedMap((Codec)ResourceKey.codec(DragonStage.REGISTRY), StageResource.CODEC);
    private static final GrowthIcon MISSING = new GrowthIcon(DragonSurvival.MISSING_TEXTURE, DragonSurvival.MISSING_TEXTURE);

    public static GrowthIcon getGrowthIcon(Holder<DragonSpecies> species, ResourceKey<DragonStage> stage) {
        Map resources = (Map)species.getData(DSDataMaps.STAGE_RESOURCES);
        if (resources == null) {
            DragonSurvival.LOGGER.error("Stage resources data map is missing for species [{}]. Define a data map in dragonsurvival/data_maps/dragonsurvival/dragon_species/stage_resources.json.", (Object)species.getKey());
            return MISSING;
        }
        StageResource stageResource = (StageResource)resources.get(stage);
        if (stageResource == null) {
            DragonSurvival.LOGGER.error("Stage resources data map is missing a resource for stage [{}] for species [{}].", stage, (Object)species.getKey());
            return MISSING;
        }
        return Objects.requireNonNullElse(stageResource.growthIcon(), MISSING);
    }

    public static ResourceLocation getDefaultSkin(Holder<DragonSpecies> species, ResourceKey<DragonStage> stage, boolean glowLayer) {
        Map resources = (Map)species.getData(DSDataMaps.STAGE_RESOURCES);
        if (resources == null) {
            DragonSurvival.LOGGER.error("Stage resources data map is missing for species [{}]. Define a data map in dragonsurvival/data_maps/dragonsurvival/dragon_species/stage_resources.json.", (Object)species.getKey());
            return DragonSurvival.MISSING_TEXTURE;
        }
        StageResource stageResource = (StageResource)resources.get(stage);
        if (stageResource == null) {
            DragonSurvival.LOGGER.error("Stage resources data map is missing a resource for stage [{}] for species [{}].", stage, (Object)species.getKey());
            return DragonSurvival.MISSING_TEXTURE;
        }
        DefaultSkin skin = stageResource.defaultSkin();
        ResourceLocation texture = glowLayer ? skin.glowSkin() : skin.skin();
        return Objects.requireNonNullElse(texture, DragonSurvival.MISSING_TEXTURE);
    }

    public record GrowthIcon(ResourceLocation hoverIcon, ResourceLocation icon) {
        public static final Codec<GrowthIcon> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("hover_icon").forGetter(GrowthIcon::hoverIcon), (App)ResourceLocation.CODEC.fieldOf("icon").forGetter(GrowthIcon::icon)).apply((Applicative)instance, GrowthIcon::new));
    }

    public record StageResource(GrowthIcon growthIcon, DefaultSkin defaultSkin) {
        public static final Codec<StageResource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GrowthIcon.CODEC.fieldOf("growth_icon").forGetter(StageResource::growthIcon), (App)DefaultSkin.CODEC.fieldOf("default_skin").forGetter(StageResource::defaultSkin)).apply((Applicative)instance, StageResource::new));
    }

    public record DefaultSkin(ResourceLocation skin, ResourceLocation glowSkin) {
        public static final Codec<DefaultSkin> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("skin").forGetter(DefaultSkin::skin), (App)ResourceLocation.CODEC.fieldOf("glow_skin").forGetter(DefaultSkin::glowSkin)).apply((Applicative)instance, DefaultSkin::new));
    }
}

