/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class ResourceLocationWrapper {
    private static final List<Character> VALID_REGEX_START = List.of(Character.valueOf('.'), Character.valueOf('^'), Character.valueOf('['), Character.valueOf('('), Character.valueOf('\\'));
    private static final int NAMESPACE = 0;
    private static final int PATH = 1;

    public static <T> Set<ResourceLocation> getEntries(String location, Registry<T> registry) {
        if (location.startsWith("#")) {
            Optional optional = registry.getTag(TagKey.create((ResourceKey)registry.key(), (ResourceLocation)ResourceLocation.parse((String)location.substring(1))));
            return optional.map(entries -> entries.stream().map(entry -> entry.getKey().location()).collect(Collectors.toSet())).orElse(Set.of());
        }
        ResourceLocation parsed = ResourceLocation.tryParse((String)location);
        if (parsed != null) {
            return Set.of(parsed);
        }
        String[] split = location.split(":");
        if (split.length != 2) {
            return Set.of();
        }
        String namespace = split[0];
        Pattern namespacePattern = ResourceLocation.isValidNamespace((String)namespace) ? null : Pattern.compile(namespace);
        Pattern pathPattern = Pattern.compile(split[1]);
        HashSet<ResourceLocation> locations = new HashSet<ResourceLocation>();
        Predicate<String> namespaceValidation = toCheck -> namespacePattern == null ? toCheck.equals(namespace) : namespacePattern.matcher((CharSequence)toCheck).matches();
        for (ResourceLocation key : registry.keySet()) {
            if (!namespaceValidation.test(key.getNamespace()) || !pathPattern.matcher(key.getPath()).matches()) continue;
            locations.add(key);
        }
        return locations;
    }

    public static <T> Set<ResourceKey<T>> map(String location, Registry<T> registry) {
        return ResourceLocationWrapper.map(ResourceLocationWrapper.getEntries(location, registry), registry);
    }

    public static <T> Set<ResourceKey<T>> map(Set<ResourceLocation> locations, Registry<T> registry) {
        HashSet<ResourceKey<T>> keys = new HashSet<ResourceKey<T>>();
        for (ResourceLocation location : locations) {
            keys.add(ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)location));
        }
        return keys;
    }

    public static Codec<String> validatedCodec() {
        return Codec.STRING.validate(value -> {
            boolean isValid = value.startsWith("#") ? ResourceLocation.tryParse((String)value.substring(1)) != null : ResourceLocationWrapper.validateRegexResourceLocation(value);
            if (!isValid) {
                return DataResult.error(() -> "[" + value + "] is not a valid resource location");
            }
            return DataResult.success((Object)value);
        });
    }

    public static boolean validateRegexResourceLocation(String location) {
        String[] data = location.split(":", 2);
        if (data.length != 2) {
            return false;
        }
        String namespace = data[0];
        if (namespace.startsWith("#")) {
            namespace = namespace.substring(1);
        }
        String path = data[1];
        if (ResourceLocation.tryParse((String)location) != null) {
            return true;
        }
        if (ResourceLocation.isValidNamespace((String)namespace) && ResourceLocationWrapper.isValidRegex(path)) {
            return true;
        }
        if (ResourceLocation.isValidPath((String)path) && ResourceLocationWrapper.isValidRegex(namespace)) {
            return true;
        }
        return ResourceLocationWrapper.isValidRegex(namespace) && ResourceLocationWrapper.isValidRegex(path);
    }

    private static boolean isValidRegex(String string) {
        char firstCharacter = string.charAt(0);
        if (!ResourceLocation.isAllowedInResourceLocation((char)firstCharacter) && !VALID_REGEX_START.contains(Character.valueOf(firstCharacter))) {
            return false;
        }
        try {
            Pattern.compile(string);
            return true;
        }
        catch (PatternSyntaxException ignored) {
            return false;
        }
    }
}

