/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.LevelBasedValue;

public record Modifier(Holder<Attribute> attribute, Either<LevelBasedValue, PreciseLevelBasedValue> amount, AttributeModifier.Operation operation) {
    public static final Codec<Modifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Attribute.CODEC.fieldOf("attribute").forGetter(Modifier::attribute), (App)Codec.either((Codec)LevelBasedValue.CODEC, PreciseLevelBasedValue.CODEC).fieldOf("amount").forGetter(Modifier::amount), (App)AttributeModifier.Operation.CODEC.fieldOf("operation").forGetter(Modifier::operation)).apply((Applicative)instance, Modifier::new));

    public static Modifier constant(Holder<Attribute> attribute, float amount, AttributeModifier.Operation operation) {
        return new Modifier(attribute, (Either<LevelBasedValue, PreciseLevelBasedValue>)Either.left((Object)LevelBasedValue.constant((float)amount)), operation);
    }

    public static Modifier per(Holder<Attribute> attribute, float amount, AttributeModifier.Operation operation) {
        return new Modifier(attribute, (Either<LevelBasedValue, PreciseLevelBasedValue>)Either.left((Object)LevelBasedValue.perLevel((float)amount)), operation);
    }

    public static Modifier precisePer(Holder<Attribute> attribute, float amount, AttributeModifier.Operation operation) {
        return new Modifier(attribute, (Either<LevelBasedValue, PreciseLevelBasedValue>)Either.right((Object)new PreciseLevelBasedValue(0.0f, amount)), operation);
    }

    public static Modifier precisePerWithBase(Holder<Attribute> attribute, float base, float amount, AttributeModifier.Operation operation) {
        return new Modifier(attribute, (Either<LevelBasedValue, PreciseLevelBasedValue>)Either.right((Object)new PreciseLevelBasedValue(base, amount)), operation);
    }

    public static Modifier perWithBase(Holder<Attribute> attribute, float base, float amount, AttributeModifier.Operation operation) {
        return new Modifier(attribute, (Either<LevelBasedValue, PreciseLevelBasedValue>)Either.left((Object)LevelBasedValue.perLevel((float)(base + amount), (float)amount)), operation);
    }

    public double calculate(double level) {
        return (Double)this.amount.map(value -> value.calculate((int)level), value -> value.calculate(level));
    }

    public AttributeModifier getModifier(ResourceLocation id, double level) {
        return new AttributeModifier(id, this.calculate(level), this.operation);
    }

    public MutableComponent getFormattedDescription(int level, boolean fancy) {
        MutableComponent name = fancy ? Component.literal((String)"\u00a76\u25a0 ").append((Component)Component.translatable((String)((Attribute)this.attribute.value()).getDescriptionId()).withColor(0xFFAA00)).append((Component)Component.literal((String)"\u00a76: ")) : Component.literal((String)"- ").append((Component)Component.translatable((String)((Attribute)this.attribute.value()).getDescriptionId())).append((Component)Component.literal((String)": "));
        double amount = this.calculate(level);
        return name.append((Component)((Attribute)this.attribute.value()).toValueComponent(this.operation, amount, (TooltipFlag)TooltipFlag.NORMAL).withStyle(((Attribute)this.attribute.value()).getStyle(amount > 0.0)));
    }

    public record PreciseLevelBasedValue(float base, float amount) {
        public static final Codec<PreciseLevelBasedValue> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("precise_base").forGetter(PreciseLevelBasedValue::base), (App)Codec.FLOAT.fieldOf("precise_amount").forGetter(PreciseLevelBasedValue::amount)).apply((Applicative)instance, PreciseLevelBasedValue::new));

        public double calculate(double level) {
            return (double)this.base + (double)this.amount * level;
        }
    }
}

