/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.CommonData;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.DurationInstance;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.DurationInstanceBase;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncDamageModification;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DamageModifications;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.NumberFormat;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DamageModification
extends DurationInstanceBase<DamageModifications, Instance> {
    @Translation(comments={"\u00a76\u25a0 Immune\u00a7r to %s"})
    private static final String ABILITY_IMMUNITY = Translation.Type.GUI.wrap("damage_modification.immunity");
    @Translation(comments={"\u00a76\u25a0 %s reduced damage taken\u00a7r from %s"})
    private static final String ABILITY_DAMAGE_REDUCTION = Translation.Type.GUI.wrap("damage_modification.damage_reduction");
    @Translation(comments={"\u00a76\u25a0 %s increased damage taken\u00a7r from %s"})
    private static final String ABILITY_DAMAGE_INCREASE = Translation.Type.GUI.wrap("damage_modification.damage_increase");
    public static final Codec<DamageModification> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)DurationInstanceBase.CODEC.fieldOf("base").forGetter(identity -> identity), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.DAMAGE_TYPE).fieldOf("damage_types").forGetter(DamageModification::damageTypes), (App)LevelBasedValue.CODEC.fieldOf("multiplier").forGetter(DamageModification::multiplier)).apply((Applicative)instance, DamageModification::new));
    private final HolderSet<DamageType> damageTypes;
    private final LevelBasedValue multiplier;

    public DamageModification(DurationInstanceBase<?, ?> base, HolderSet<DamageType> damageTypes, LevelBasedValue multiplier) {
        super(base);
        this.damageTypes = damageTypes;
        this.multiplier = multiplier;
    }

    public boolean isFireImmune(int appliedAbilityLevel) {
        HolderSet.Named named;
        if (this.multiplier.calculate(appliedAbilityLevel) != 0.0f) {
            return false;
        }
        HolderSet<DamageType> holderSet = this.damageTypes;
        if (holderSet instanceof HolderSet.Named && (named = (HolderSet.Named)holderSet).key() == DamageTypeTags.IS_FIRE) {
            return true;
        }
        for (Holder damageType : this.damageTypes) {
            if (!damageType.is(DamageTypes.ON_FIRE) && !damageType.is(DamageTypes.IN_FIRE) && !damageType.is(DamageTypes.LAVA)) continue;
            return true;
        }
        return false;
    }

    public MutableComponent getDescription(int abilityLevel) {
        float amount = this.multiplier.calculate(abilityLevel);
        String difference = NumberFormat.getPercentInstance().format(Math.abs(amount - 1.0f));
        MutableComponent damageType = Functions.translateHolderSet(this.damageTypes, Translation.Type.DAMAGE_TYPE);
        MutableComponent description = amount == 0.0f ? Component.translatable((String)ABILITY_IMMUNITY, (Object[])new Object[]{damageType}) : (amount < 1.0f ? Component.translatable((String)ABILITY_DAMAGE_REDUCTION, (Object[])new Object[]{DSColors.dynamicValue(difference), damageType}) : Component.translatable((String)ABILITY_DAMAGE_INCREASE, (Object[])new Object[]{DSColors.dynamicValue(difference), damageType}));
        float duration = this.duration().calculate(abilityLevel);
        if (duration != -1.0f) {
            description.append((Component)Component.translatable((String)LangKey.ABILITY_EFFECT_DURATION, (Object[])new Object[]{DSColors.dynamicValue(Functions.ticksToSeconds((int)duration))}));
        }
        return description;
    }

    @Override
    public Instance createInstance(ServerPlayer dragon, DragonAbilityInstance ability, int currentDuration) {
        return new Instance(this, CommonData.from(this.id(), dragon, ability, this.customIcon(), this.shouldRemoveAutomatically()), currentDuration);
    }

    @Override
    public AttachmentType<DamageModifications> type() {
        return (AttachmentType)DSDataAttachments.DAMAGE_MODIFICATIONS.value();
    }

    public HolderSet<DamageType> damageTypes() {
        return this.damageTypes;
    }

    public LevelBasedValue multiplier() {
        return this.multiplier;
    }

    public static class Instance
    extends DurationInstance<DamageModification> {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> DurationInstance.codecStart(instance, () -> CODEC).apply((Applicative)instance, Instance::new));

        public Instance(DamageModification baseData, CommonData commonData, int currentDuration) {
            super(baseData, commonData, currentDuration);
        }

        public float calculate(Holder<DamageType> damageType, float damageAmount) {
            float modification = 1.0f;
            if (((DamageModification)this.baseData()).damageTypes().contains(damageType)) {
                modification = Math.max(0.0f, ((DamageModification)this.baseData()).multiplier().calculate(this.appliedAbilityLevel()));
            }
            return damageAmount * modification;
        }

        public boolean isFireImmune() {
            return ((DamageModification)this.baseData()).isFireImmune(this.appliedAbilityLevel());
        }

        @Override
        public Component getDescription() {
            return ((DamageModification)this.baseData()).getDescription(this.appliedAbilityLevel());
        }

        @Override
        public void onAddedToStorage(Entity storageHolder) {
            if (storageHolder instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)storageHolder;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncDamageModification(player.getId(), this, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        @Override
        public void onRemovalFromStorage(Entity storageHolder) {
            if (storageHolder instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)storageHolder;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncDamageModification(player.getId(), this, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public Tag save(@NotNull HolderLookup.Provider provider) {
            return (Tag)CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
        }

        @Nullable
        public static Instance load(@NotNull HolderLookup.Provider provider, CompoundTag nbt) {
            return CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).orElse(null);
        }
    }
}

