/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.CommonData;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.DurationInstance;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.DurationInstanceBase;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncBlockVision;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.BlockVisionData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockVision
extends DurationInstanceBase<BlockVisionData, Instance> {
    @Translation(comments={"\u00a76\u25a0 Block Vision:\u00a7r", " - Range: %s", " - Color: %s", " - Applies to: %s"})
    private static final String HARVEST_BONUS = Translation.Type.GUI.wrap("block_vision");
    @Translation(comments={"Multiple"})
    private static final String MULTIPLE_COLORS = Translation.Type.GUI.wrap("block_vision.multiple_colors");
    public static final int NO_RANGE = 0;
    public static final Codec<BlockVision> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)DurationInstanceBase.CODEC.fieldOf("base").forGetter(identity -> identity), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).fieldOf("blocks").forGetter(BlockVision::blocks), (App)LevelBasedValue.CODEC.fieldOf("range").forGetter(BlockVision::range), (App)DisplayType.CODEC.fieldOf("display_type").forGetter(BlockVision::displayType), (App)TextColor.CODEC.listOf().fieldOf("colors").forGetter(BlockVision::colors)).apply((Applicative)instance, BlockVision::new));
    private final HolderSet<Block> blocks;
    private final LevelBasedValue range;
    private final DisplayType displayType;
    private final List<TextColor> colors;

    public BlockVision(DurationInstanceBase<?, ?> base, HolderSet<Block> blocks, LevelBasedValue range, DisplayType displayType, List<TextColor> colors) {
        super(base);
        this.blocks = blocks;
        this.range = range;
        this.displayType = displayType;
        this.colors = colors;
    }

    public MutableComponent getDescription(int abilityLevel) {
        int range = (int)this.range.calculate(abilityLevel);
        MutableComponent color = this.colors.size() == 1 ? DSColors.withColor(this.colors.getFirst().serialize(), this.colors.getFirst().getValue()) : (this.colors.size() > 1 ? DSColors.withColor(Component.translatable((String)MULTIPLE_COLORS), Functions.lerpColor(this.colors.stream().map(TextColor::getValue).toList())) : DSColors.dynamicValue(Component.translatable((String)LangKey.NONE)));
        MutableComponent appliesTo = Functions.translateHolderSet(this.blocks, Holder::getRegisteredName);
        return Component.translatable((String)HARVEST_BONUS, (Object[])new Object[]{DSColors.dynamicValue(range), color, DSColors.dynamicValue(appliesTo)});
    }

    public HolderSet<Block> blocks() {
        return this.blocks;
    }

    public LevelBasedValue range() {
        return this.range;
    }

    public DisplayType displayType() {
        return this.displayType;
    }

    public List<TextColor> colors() {
        return this.colors;
    }

    @Override
    public Instance createInstance(ServerPlayer dragon, DragonAbilityInstance ability, int currentDuration) {
        return new Instance(this, CommonData.from(this.id(), dragon, ability, this.customIcon(), this.shouldRemoveAutomatically()), currentDuration);
    }

    @Override
    public AttachmentType<BlockVisionData> type() {
        return (AttachmentType)DSDataAttachments.BLOCK_VISION.value();
    }

    public static enum DisplayType implements StringRepresentable
    {
        OUTLINE("outline"),
        PARTICLES("particles"),
        NONE("none");

        public static final Codec<DisplayType> CODEC;
        private final String name;

        private DisplayType(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(DisplayType::values);
        }
    }

    public static class Instance
    extends DurationInstance<BlockVision> {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> DurationInstance.codecStart(instance, () -> CODEC).apply((Applicative)instance, Instance::new));

        public Instance(BlockVision baseData, CommonData commonData, int currentDuration) {
            super(baseData, commonData, currentDuration);
        }

        public int getRange(@Nullable Block block) {
            if (block == null || ((BlockVision)this.baseData()).blocks().contains((Holder)block.builtInRegistryHolder())) {
                return (int)Math.max(0.0f, ((BlockVision)this.baseData()).range().calculate(this.appliedAbilityLevel()));
            }
            return 0;
        }

        public List<Integer> getColors(Block block) {
            if (((BlockVision)this.baseData()).blocks().contains((Holder)block.builtInRegistryHolder())) {
                return ((BlockVision)this.baseData()).colors().stream().map(color -> DSColors.withAlpha(color.getValue(), 1.0f)).toList();
            }
            return List.of();
        }

        public DisplayType getDisplayType(Block block) {
            if (((BlockVision)this.baseData()).blocks().contains((Holder)block.builtInRegistryHolder())) {
                return ((BlockVision)this.baseData()).displayType();
            }
            return DisplayType.NONE;
        }

        @Override
        public Component getDescription() {
            return ((BlockVision)this.baseData()).getDescription(this.appliedAbilityLevel());
        }

        @Override
        public void onAddedToStorage(Entity storageHolder) {
            if (storageHolder instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)storageHolder;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncBlockVision(player.getId(), this, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        @Override
        public void onRemovalFromStorage(Entity storageHolder) {
            if (storageHolder instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)storageHolder;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncBlockVision(player.getId(), this, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public Tag save(@NotNull HolderLookup.Provider provider) {
            return (Tag)CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
        }

        @Nullable
        public static Instance load(@NotNull HolderLookup.Provider provider, CompoundTag nbt) {
            return CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).orElse(null);
        }
    }
}

