/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.capability;

import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncData;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEffects;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSProfessionTags;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class EntityStateHandler
implements INBTSerializable<CompoundTag> {
    @Translation(comments={"You have to wait %s seconds until you can steal from this villager"})
    public static final String PILLAGE_ON_COOLDOWN = Translation.Type.GUI.wrap("message.pillage_on_cooldown");
    @Translation(comments={"This villager had no items you could steal"})
    public static final String PILLAGE_UNSUCCESSFUL = Translation.Type.GUI.wrap("message.pillage_unsuccessful");
    @Translation(comments={"You cannot steal from this villager"})
    public static final String CANNOT_PILLAGE = Translation.Type.GUI.wrap("message.cannot_pillage");
    public Vec3 lastPos;
    public int chainCount;
    public int pillageCooldown;
    private static final String LAST_POSITION = "last_position";
    private static final String CHAIN_COUNT = "chain_count";
    private static final String PILLAGE_COOLDOWN_KEY = "pillage_cooldown";

    public static boolean cannotPillageProfession(Villager villager) {
        VillagerProfession profession = villager.getVillagerData().getProfession();
        ResourceLocation key = BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)profession);
        Holder.Reference holder = BuiltInRegistries.VILLAGER_PROFESSION.getHolderOrThrow(ResourceKey.create((ResourceKey)BuiltInRegistries.VILLAGER_PROFESSION.key(), (ResourceLocation)key));
        return BuiltInRegistries.VILLAGER_PROFESSION.getOrCreateTag(DSProfessionTags.PILLAGE_BLACKLIST).contains((Holder)holder);
    }

    public static boolean canPillage(Entity target, Player player) {
        Villager villager;
        if (!player.hasEffect(DSEffects.HUNTER_OMEN)) {
            return false;
        }
        if (target instanceof Villager && EntityStateHandler.cannotPillageProfession(villager = (Villager)target)) {
            return false;
        }
        EntityStateHandler handler = target.getExistingData(DSDataAttachments.ENTITY_HANDLER).orElse(null);
        if (handler == null) {
            return true;
        }
        return handler.pillageCooldown == 0;
    }

    public void setPillageCooldown() {
        this.pillageCooldown = ServerConfig.PILLAGE_COOLDOWN;
    }

    public void sync(Entity holder, @Nullable Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncData(holder.getId(), DSDataAttachments.ENTITY_HANDLER.getId(), this.serializeNBT((HolderLookup.Provider)holder.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (player == null) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)holder, (CustomPacketPayload)new SyncData(holder.getId(), DSDataAttachments.ENTITY_HANDLER.getId(), this.serializeNBT((HolderLookup.Provider)holder.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onTrackingStart(PlayerEvent.StartTracking event) {
        EntityStateHandler handler = event.getTarget().getExistingData(DSDataAttachments.ENTITY_HANDLER).orElse(null);
        if (handler == null || handler.pillageCooldown == 0) {
            return;
        }
        handler.sync(event.getTarget(), event.getEntity());
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putInt(CHAIN_COUNT, this.chainCount);
        tag.putInt(PILLAGE_COOLDOWN_KEY, this.pillageCooldown);
        if (this.lastPos != null) {
            tag.put(LAST_POSITION, (Tag)Functions.newDoubleList(this.lastPos.x, this.lastPos.y, this.lastPos.z));
        }
        return tag;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag tag) {
        this.chainCount = tag.getInt(CHAIN_COUNT);
        this.pillageCooldown = tag.getInt(PILLAGE_COOLDOWN_KEY);
        if (tag.contains(LAST_POSITION)) {
            ListTag list = tag.getList(LAST_POSITION, 6);
            this.lastPos = new Vec3(list.getDouble(0), list.getDouble(1), list.getDouble(2));
        }
    }
}

