/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.blocks;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlockEntities;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlocks;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEffects;
import by.dragonsurvivalteam.dragonsurvival.registry.DSItems;
import by.dragonsurvivalteam.dragonsurvival.registry.DSParticles;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.server.tileentity.SourceOfMagicBlockEntity;
import by.dragonsurvivalteam.dragonsurvival.server.tileentity.SourceOfMagicPlaceholder;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import by.dragonsurvivalteam.dragonsurvival.util.SpawningUtils;
import com.mojang.serialization.MapCodec;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourceOfMagicBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    @Translation(comments={"You need a 3x3 area to place %s"})
    private static final String OCCUPIED = Translation.Type.GUI.wrap("message.occupied");
    @ConfigRange(min=0.0)
    @Translation(key="source_of_magic_max_duration", type=Translation.Type.CONFIGURATION, comments={"Max. duration (in ticks) (20 ticks = 1 second) the source of magic effect can stack up to"})
    @ConfigOption(side=ConfigSide.SERVER, category={"magic"}, key="source_of_magic_max_duration")
    public static int MAX_DURATION = Functions.minutesToTicks(30.0);
    public static final BooleanProperty PRIMARY_BLOCK = BooleanProperty.create((String)"primary");
    public static final BooleanProperty FILLED = BooleanProperty.create((String)"filled");
    private static final int REQUIRED_SOURCE_OF_MAGIC_TICKS = Functions.secondsToTicks(10.0);
    private static final VoxelShape SLAB = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
    private static final VoxelShape FULL_NORTH = Shapes.box((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape FULL_SOUTH = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5);
    private static final VoxelShape FULL_EAST = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0);
    private static final VoxelShape FULL_WEST = Shapes.box((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape TOP_NORTH = Shapes.or((VoxelShape)FULL_NORTH, (VoxelShape[])new VoxelShape[]{Shapes.box((double)1.0, (double)0.0, (double)0.5, (double)1.5, (double)0.5, (double)1.0), Shapes.box((double)-0.5, (double)0.0, (double)0.5, (double)0.0, (double)0.5, (double)1.0)});
    private static final VoxelShape TOP_SOUTH = Shapes.or((VoxelShape)FULL_SOUTH, (VoxelShape[])new VoxelShape[]{Shapes.box((double)1.0, (double)0.0, (double)0.0, (double)1.5, (double)0.5, (double)0.5), Shapes.box((double)-0.5, (double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)0.5)});
    private static final VoxelShape TOP_EAST = Shapes.or((VoxelShape)FULL_EAST, (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)0.5, (double)1.5), Shapes.box((double)0.0, (double)0.0, (double)-0.5, (double)0.5, (double)0.5, (double)0.0)});
    private static final VoxelShape TOP_WEST = Shapes.or((VoxelShape)FULL_WEST, (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)0.5, (double)1.5), Shapes.box((double)0.5, (double)0.0, (double)-0.5, (double)1.0, (double)0.5, (double)0.0)});
    private static final VoxelShape BACK_NORTH = Shapes.or((VoxelShape)SLAB, (VoxelShape)FULL_NORTH);
    private static final VoxelShape BACK_SOUTH = Shapes.or((VoxelShape)SLAB, (VoxelShape)FULL_SOUTH);
    private static final VoxelShape BACK_EAST = Shapes.or((VoxelShape)SLAB, (VoxelShape)FULL_EAST);
    private static final VoxelShape BACK_WEST = Shapes.or((VoxelShape)SLAB, (VoxelShape)FULL_WEST);
    private static final EnumProperty<Type> TYPE = EnumProperty.create((String)"type", Type.class);
    private final Function<DamageSources, DamageSource> damageSourceProvider;

    public SourceOfMagicBlock(BlockBehaviour.Properties properties, Function<DamageSources, DamageSource> damageSourceProvider) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)PRIMARY_BLOCK, (Comparable)Boolean.valueOf(true))).setValue(TYPE, (Comparable)((Object)Type.GROUND))).setValue((Property)FILLED, (Comparable)Boolean.valueOf(false)));
        this.damageSourceProvider = damageSourceProvider;
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return MapCodec.unit((Object)((Object)this));
    }

    private static void breakBlock(Level level, BlockPos position) {
        level.destroyBlock(position, !(level.getBlockEntity(position) instanceof SourceOfMagicPlaceholder));
        level.removeBlockEntity(position);
    }

    public void animateTick(BlockState state, @NotNull Level level, @NotNull BlockPos position, @NotNull RandomSource random) {
        if (state.getBlock() != DSBlocks.CAVE_SOURCE_OF_MAGIC.get()) {
            return;
        }
        double x = position.getX();
        double y = position.getY();
        double z = position.getZ();
        if (level.getFluidState(position).is(FluidTags.WATER)) {
            level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, x + 0.5, y, z + 0.5, 0.0, 0.04, 0.0);
            level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 0.0, 0.04, 0.0);
        } else if (((Boolean)state.getValue((Property)FILLED)).booleanValue()) {
            level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.LAVA, x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 0.0, 0.04, 0.0);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos clickedPosition = context.getClickedPos();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        Direction direction = player != null ? player.getDirection() : Direction.getRandom((RandomSource)level.getRandom());
        AtomicBoolean isValid = new AtomicBoolean(true);
        BlockPos.betweenClosedStream((int)(clickedPosition.getX() - 1), (int)clickedPosition.getY(), (int)(clickedPosition.getZ() - 1), (int)(clickedPosition.getX() + 1), (int)clickedPosition.getY(), (int)(clickedPosition.getZ() + 1)).forEach(position -> {
            if (isValid.get() && !SpawningUtils.isAirOrFluid(position, level, context)) {
                if (player != null && !level.isClientSide()) {
                    player.displayClientMessage((Component)Component.translatable((String)OCCUPIED, (Object[])new Object[]{this.asItem().getDefaultInstance().getDisplayName()}), true);
                }
                isValid.set(false);
            }
        });
        if (!isValid.get()) {
            return null;
        }
        if (!SpawningUtils.isAirOrFluid(clickedPosition.relative(direction).above(), level, context)) {
            return null;
        }
        if (!SpawningUtils.isAirOrFluid(clickedPosition.relative(direction).above().relative(direction.getClockWise()), level, context)) {
            return null;
        }
        if (!SpawningUtils.isAirOrFluid(clickedPosition.relative(direction).above().relative(direction.getCounterClockWise()), level, context)) {
            return null;
        }
        BlockState state = super.getStateForPlacement(context);
        if (state != null) {
            state = (BlockState)state.setValue((Property)FACING, (Comparable)direction.getOpposite());
        }
        return state;
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos position, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.setPlacedBy(level, position, state, placer, stack);
        if (placer != null) {
            Direction direction = placer.getDirection();
            SourceOfMagicBlock.setPlaceholder(level, state, position, position.relative(direction.getOpposite()));
            SourceOfMagicBlock.setPlaceholder(level, (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.BACK)), position, position.relative(direction));
            SourceOfMagicBlock.setPlaceholder(level, state, position, position.relative(direction.getClockWise()));
            SourceOfMagicBlock.setPlaceholder(level, state, position, position.relative(direction.getCounterClockWise()));
            SourceOfMagicBlock.setPlaceholder(level, (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.BACK)), position, position.relative(direction).relative(direction.getClockWise()));
            SourceOfMagicBlock.setPlaceholder(level, (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.BACK)), position, position.relative(direction).relative(direction.getCounterClockWise()));
            SourceOfMagicBlock.setPlaceholder(level, state, position, position.relative(direction.getOpposite()).relative(direction.getCounterClockWise()));
            SourceOfMagicBlock.setPlaceholder(level, state, position, position.relative(direction.getOpposite()).relative(direction.getClockWise()));
            SourceOfMagicBlock.setPlaceholder(level, (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.TOP)), position, position.above().relative(direction));
            SourceOfMagicBlock.setPlaceholder(level, (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.BACK_MIDDLE)), position, position.above().relative(direction).relative(direction.getCounterClockWise()));
            SourceOfMagicBlock.setPlaceholder(level, (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.BACK_MIDDLE)), position, position.above().relative(direction).relative(direction.getClockWise()));
        }
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED, FACING, PRIMARY_BLOCK, TYPE, FILLED});
    }

    private static void setPlaceholder(Level level, BlockState state, BlockPos rootPosition, BlockPos newPosition) {
        if (!(state.getBlock() instanceof SourceOfMagicBlock)) {
            level.setBlockAndUpdate(newPosition, state);
            return;
        }
        level.setBlockAndUpdate(newPosition, (BlockState)state.setValue((Property)PRIMARY_BLOCK, (Comparable)Boolean.valueOf(false)));
        BlockEntity blockEntity = level.getBlockEntity(newPosition);
        if (blockEntity instanceof SourceOfMagicPlaceholder) {
            SourceOfMagicPlaceholder placeholder = (SourceOfMagicPlaceholder)blockEntity;
            placeholder.rootPos = rootPosition;
        }
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction facing, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos position, @NotNull BlockPos neighborPosition) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(position, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, neighborState, level, position, neighborPosition);
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos position, BlockState newState, boolean isMoving) {
        if (newState.getBlock() instanceof SourceOfMagicBlock) {
            return;
        }
        if (((Boolean)state.getValue((Property)PRIMARY_BLOCK)).booleanValue()) {
            BlockEntity blockEntity = level.getBlockEntity(position);
            if (blockEntity instanceof Container) {
                Container container = (Container)blockEntity;
                Containers.dropContents((Level)level, (BlockPos)position, (Container)container);
                level.updateNeighbourForOutputSignal(position, (Block)this);
            }
            super.onRemove(state, level, position, newState, isMoving);
            Direction direction = ((Direction)state.getValue((Property)FACING)).getOpposite();
            SourceOfMagicBlock.breakBlock(level, position);
            SourceOfMagicBlock.breakBlock(level, position.relative(direction.getOpposite()));
            SourceOfMagicBlock.breakBlock(level, position.relative(direction));
            SourceOfMagicBlock.breakBlock(level, position.relative(direction.getClockWise()));
            SourceOfMagicBlock.breakBlock(level, position.relative(direction.getCounterClockWise()));
            SourceOfMagicBlock.breakBlock(level, position.relative(direction).relative(direction.getClockWise()));
            SourceOfMagicBlock.breakBlock(level, position.relative(direction).relative(direction.getCounterClockWise()));
            SourceOfMagicBlock.breakBlock(level, position.relative(direction.getOpposite()).relative(direction.getCounterClockWise()));
            SourceOfMagicBlock.breakBlock(level, position.relative(direction.getOpposite()).relative(direction.getClockWise()));
            SourceOfMagicBlock.breakBlock(level, position.above().relative(direction));
            SourceOfMagicBlock.breakBlock(level, position.above().relative(direction).relative(direction.getCounterClockWise()));
            SourceOfMagicBlock.breakBlock(level, position.above().relative(direction).relative(direction.getClockWise()));
        } else {
            BlockEntity direction = level.getBlockEntity(position);
            if (direction instanceof SourceOfMagicPlaceholder) {
                SourceOfMagicPlaceholder placeholder = (SourceOfMagicPlaceholder)direction;
                BlockEntity blockEntity = level.getBlockEntity(placeholder.rootPos);
                if (blockEntity instanceof SourceOfMagicBlockEntity) {
                    SourceOfMagicBlockEntity root = (SourceOfMagicBlockEntity)blockEntity;
                    this.onRemove(root.getBlockState(), level, placeholder.rootPos, Blocks.BUBBLE_COLUMN.defaultBlockState(), isMoving);
                }
            }
        }
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos position, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        BlockPos rootPosition;
        BlockEntity blockEntity = level.getBlockEntity(position);
        if (blockEntity instanceof SourceOfMagicPlaceholder) {
            SourceOfMagicPlaceholder placeholder = (SourceOfMagicPlaceholder)blockEntity;
            rootPosition = placeholder.rootPos;
        } else {
            rootPosition = position;
        }
        if (!player.isCrouching() && (blockEntity = this.getSource(level, rootPosition)) instanceof MenuProvider) {
            BlockEntity provider = blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.openMenu((MenuProvider)provider, buffer -> buffer.writeBlockPos(rootPosition));
            }
            return InteractionResult.sidedSuccess((boolean)player.level().isClientSide());
        }
        return InteractionResult.PASS;
    }

    public boolean triggerEvent(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos position, int id, int param) {
        super.triggerEvent(state, level, position, id, param);
        BlockEntity blockentity = level.getBlockEntity(position);
        return blockentity != null && blockentity.triggerEvent(id, param);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return (Boolean)state.getValue((Property)PRIMARY_BLOCK) != false ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public MenuProvider getMenuProvider(@NotNull BlockState state, Level level, @NotNull BlockPos position) {
        BlockEntity blockentity = level.getBlockEntity(position);
        return blockentity instanceof MenuProvider ? (MenuProvider)blockentity : null;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos position, @NotNull CollisionContext context) {
        return this.getShape(state);
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos position, @NotNull CollisionContext context) {
        return this.getShape(state);
    }

    public void randomTick(@NotNull BlockState state, ServerLevel world, BlockPos position, @NotNull RandomSource random) {
        BlockPos above = position.above();
        if (world.getFluidState(position).is(FluidTags.WATER)) {
            world.playSound(null, position, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (world.random.nextFloat() - world.random.nextFloat()) * 0.8f);
            world.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)above.getX() + 0.5, (double)above.getY() + 0.25, (double)above.getZ() + 0.5, 8, 0.5, 0.25, 0.5, 0.0);
        }
    }

    public void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos position, @NotNull Entity entity) {
        SourceOfMagicBlockEntity source;
        super.entityInside(state, level, position, entity);
        BlockPos sourcePosition = position;
        BlockEntity blockEntity = level.getBlockEntity(position);
        if (blockEntity instanceof SourceOfMagicPlaceholder) {
            SourceOfMagicPlaceholder placeholder = (SourceOfMagicPlaceholder)blockEntity;
            sourcePosition = placeholder.rootPos;
        }
        if ((source = this.getSource(level, sourcePosition)) == null) {
            return;
        }
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            ItemStack stack = item.getItem();
            ItemStack tileStack = source.getItem(0);
            if (source.getDuration(stack.getItem()) > 0) {
                if (source.isEmpty()) {
                    source.setItem(0, stack);
                    item.kill();
                } else if (ItemStack.isSameItem((ItemStack)tileStack, (ItemStack)stack) && tileStack.getCount() < tileStack.getMaxStackSize()) {
                    int left = tileStack.getMaxStackSize() - tileStack.getCount();
                    int toAdd = Math.min(stack.getCount(), left);
                    item.getItem().shrink(toAdd);
                    tileStack.setCount(tileStack.getCount() + toAdd);
                }
            }
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        DragonStateHandler handler = DragonStateProvider.getData(player);
        if (source.isApplicableFor(handler) && this.isMagic(state) && !source.isEmpty()) {
            if (handler.magicSource > REQUIRED_SOURCE_OF_MAGIC_TICKS) {
                handler.magicSource = 0;
                MobEffectInstance instance = player.getEffect(DSEffects.SOURCE_OF_MAGIC);
                int duration = source.getCurrentDuration();
                if (instance == null) {
                    player.addEffect(new MobEffectInstance(DSEffects.SOURCE_OF_MAGIC, duration, 0, true, false));
                } else if (instance.getDuration() < MAX_DURATION) {
                    player.addEffect(new MobEffectInstance(DSEffects.SOURCE_OF_MAGIC, Math.min(MAX_DURATION, instance.getDuration() + duration), 0, true, false));
                } else {
                    return;
                }
                player.playNotifySound(SoundEvents.BEACON_POWER_SELECT, SoundSource.NEUTRAL, 1.0f, 1.0f);
                source.removeItem(0, 1);
            } else {
                RandomSource random = player.getRandom();
                double x = -1.0 + random.nextDouble() * 2.0;
                double z = -1.0 + random.nextDouble() * 2.0;
                ParticleOptions particle = null;
                if (state.getBlock() == DSBlocks.CAVE_SOURCE_OF_MAGIC.get()) {
                    particle = (ParticleOptions)DSParticles.CAVE_BEACON_PARTICLE.value();
                } else if (state.getBlock() == DSBlocks.FOREST_SOURCE_OF_MAGIC.get()) {
                    particle = (ParticleOptions)DSParticles.FOREST_BEACON_PARTICLE.value();
                } else if (state.getBlock() == DSBlocks.SEA_SOURCE_OF_MAGIC.get()) {
                    particle = (ParticleOptions)DSParticles.SEA_BEACON_PARTICLE.value();
                }
                if (particle != null) {
                    player.level().addParticle(particle, player.getX() + x, player.getY() + 0.5, player.getZ() + z, 0.0, 0.0, 0.0);
                }
            }
        } else if (!source.isApplicableFor(handler) && ServerConfig.damageWrongSourceOfMagic.booleanValue()) {
            entity.hurt(this.damageSourceProvider.apply(entity.damageSources()), this.isMagic(state) ? 1.0f : 0.5f);
        }
    }

    public SourceOfMagicBlockEntity getSource(Level level, BlockPos position) {
        SourceOfMagicBlockEntity source;
        BlockEntity entity = level.getBlockEntity(position);
        return entity instanceof SourceOfMagicBlockEntity ? (source = (SourceOfMagicBlockEntity)entity) : null;
    }

    public boolean placeLiquid(@NotNull LevelAccessor level, @NotNull BlockPos position, @NotNull BlockState state, @NotNull FluidState fluidState) {
        if (!((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && fluidState.getType() == Fluids.WATER) {
            if (!level.isClientSide()) {
                level.setBlock(position, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.TRUE), 3);
                level.scheduleTick(position, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)level));
            }
            return true;
        }
        return false;
    }

    @NotNull
    public ItemStack pickupBlock(@Nullable Player player, @NotNull LevelAccessor level, @NotNull BlockPos position, @NotNull BlockState state) {
        BlockEntity blockEntity;
        BlockEntity entity = level.getBlockEntity(position);
        BlockPos rootPosition = null;
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.setBlock(position, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return Items.WATER_BUCKET.getDefaultInstance();
        }
        if (entity instanceof SourceOfMagicPlaceholder) {
            SourceOfMagicPlaceholder placeholder = (SourceOfMagicPlaceholder)entity;
            rootPosition = placeholder.rootPos;
        } else if (entity instanceof SourceOfMagicBlockEntity) {
            SourceOfMagicBlockEntity source = (SourceOfMagicBlockEntity)entity;
            return this.updateAndTakeLiquid(level, position, state, source);
        }
        if (rootPosition != null && (blockEntity = level.getBlockEntity(rootPosition)) instanceof SourceOfMagicBlockEntity) {
            SourceOfMagicBlockEntity source = (SourceOfMagicBlockEntity)blockEntity;
            return this.updateAndTakeLiquid(level, rootPosition, level.getBlockState(rootPosition), source);
        }
        return ItemStack.EMPTY;
    }

    private ItemStack updateAndTakeLiquid(LevelAccessor level, BlockPos position, BlockState state, SourceOfMagicBlockEntity source) {
        if (!((Boolean)state.getValue((Property)FILLED)).booleanValue()) {
            return ItemStack.EMPTY;
        }
        level.setBlock(position, (BlockState)state.setValue((Property)FILLED, (Comparable)Boolean.valueOf(false)), 3);
        Item item = source.getItem(0).getItem();
        Block block = state.getBlock();
        boolean decrementStack = false;
        if (item == DSItems.ELDER_DRAGON_DUST.value()) {
            decrementStack = true;
        } else if (item == DSItems.ELDER_DRAGON_BONE.value()) {
            decrementStack = level.getRandom().nextInt(1) == 0;
        } else if (item == DSItems.DRAGON_HEART_SHARD.value()) {
            decrementStack = level.getRandom().nextInt(3) == 0;
        } else if (item == DSItems.WEAK_DRAGON_HEART.value()) {
            decrementStack = level.getRandom().nextInt(5) == 0;
        } else if (item == DSItems.ELDER_DRAGON_HEART.value()) {
            boolean bl = decrementStack = level.getRandom().nextInt(10) == 0;
        }
        if (decrementStack) {
            source.removeItem(0, 1);
        }
        if (block == DSBlocks.CAVE_SOURCE_OF_MAGIC.get()) {
            return Items.LAVA_BUCKET.getDefaultInstance();
        }
        if (block == DSBlocks.SEA_SOURCE_OF_MAGIC.get() || block == DSBlocks.FOREST_SOURCE_OF_MAGIC.get()) {
            return Items.WATER_BUCKET.getDefaultInstance();
        }
        return ItemStack.EMPTY;
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos position, BlockState state) {
        if (!((Boolean)state.getValue((Property)PRIMARY_BLOCK)).booleanValue()) {
            return ((BlockEntityType)DSBlockEntities.SOURCE_OF_MAGIC_PLACEHOLDER.get()).create(position, state);
        }
        return ((BlockEntityType)DSBlockEntities.SOURCE_OF_MAGIC_TILE_ENTITY.get()).create(position, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return level.isClientSide ? null : BaseEntityBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)DSBlockEntities.SOURCE_OF_MAGIC_TILE_ENTITY.get()), SourceOfMagicBlockEntity::serverTick);
    }

    public boolean isMagic(BlockState state) {
        return (Boolean)state.getValue((Property)PRIMARY_BLOCK) != false && (Boolean)state.getValue((Property)FILLED) != false;
    }

    private VoxelShape getShape(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        Type type = (Type)((Object)state.getValue(TYPE));
        if (type == Type.TOP) {
            return switch (facing) {
                case Direction.NORTH -> TOP_NORTH;
                case Direction.SOUTH -> TOP_SOUTH;
                case Direction.EAST -> TOP_EAST;
                case Direction.WEST -> TOP_WEST;
                default -> Shapes.block();
            };
        }
        if (type == Type.BACK) {
            return switch (facing) {
                case Direction.NORTH -> BACK_NORTH;
                case Direction.SOUTH -> BACK_SOUTH;
                case Direction.EAST -> BACK_EAST;
                case Direction.WEST -> BACK_WEST;
                default -> Shapes.block();
            };
        }
        if (type == Type.BACK_MIDDLE) {
            return Shapes.empty();
        }
        return SLAB;
    }

    private static enum Type implements StringRepresentable
    {
        GROUND,
        BACK,
        BACK_MIDDLE,
        TOP;


        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

