/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.blocks;

import by.dragonsurvivalteam.dragonsurvival.common.blocks.DragonPressurePlates;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSBlockTags;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmallDragonDoor
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.DOOR_HINGE;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    @Nullable
    private final TagKey<DragonSpecies> types;
    private final boolean allowHumans;
    private final boolean requiresPower;

    public SmallDragonDoor(BlockBehaviour.Properties properties) {
        this(properties, null, true, false);
    }

    public SmallDragonDoor(BlockBehaviour.Properties properties, TagKey<DragonSpecies> types) {
        this(properties, types, false, false);
    }

    public SmallDragonDoor(BlockBehaviour.Properties properties, boolean requiresPower) {
        this(properties, null, true, requiresPower);
    }

    public SmallDragonDoor(BlockBehaviour.Properties properties, @Nullable TagKey<DragonSpecies> types, boolean allowHumans, boolean requiresPower) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue(HINGE, (Comparable)DoorHingeSide.LEFT)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        this.types = types;
        this.allowHumans = allowHumans;
        this.requiresPower = requiresPower;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos clickedPosition = context.getClickedPos();
        if (clickedPosition.getY() < 255) {
            Level level = context.getLevel();
            boolean hasPower = level.hasNeighborSignal(clickedPosition) || level.hasNeighborSignal(clickedPosition.above());
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue(HINGE, (Comparable)this.getHinge(context))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasPower))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(hasPower))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
        }
        return null;
    }

    private DoorHingeSide getHinge(BlockPlaceContext context) {
        Level iblockreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        Direction north = context.getHorizontalDirection();
        Direction directionCounterClockWiseHorizontal = north.getCounterClockWise();
        BlockPos blockpos2 = blockpos.relative(directionCounterClockWiseHorizontal);
        BlockState blockstate = iblockreader.getBlockState(blockpos2);
        Direction direction2 = north.getClockWise();
        BlockPos blockpos4 = blockpos.relative(direction2);
        BlockState blockstate2 = iblockreader.getBlockState(blockpos4);
        int i = (blockstate.isCollisionShapeFullBlock((BlockGetter)iblockreader, blockpos2) ? -1 : 0) + (blockstate2.isCollisionShapeFullBlock((BlockGetter)iblockreader, blockpos4) ? 1 : 0);
        boolean flag = blockstate.is((Block)this);
        boolean flag1 = blockstate2.is((Block)this);
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = north.getStepX();
                int k = north.getStepZ();
                Vec3 vec3d = context.getClickLocation();
                double d0 = vec3d.x - (double)blockpos.getX();
                double d1 = vec3d.z - (double)blockpos.getZ();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN, HINGE, POWERED, WATERLOGGED});
    }

    public boolean isPathfindable(@NotNull BlockState state, PathComputationType type) {
        return switch (type) {
            case PathComputationType.LAND, PathComputationType.AIR -> (Boolean)state.getValue((Property)OPEN);
            default -> false;
        };
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos position, @NotNull BlockPos facingPosition) {
        if (facing == Direction.DOWN && !state.canSurvive((LevelReader)level, position)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(position, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, position, facingPosition);
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos position, @NotNull Block neighborBlock, @NotNull BlockPos neighborPosition, boolean isMoving) {
        boolean hasPower;
        boolean isValidType;
        if (neighborBlock == this) {
            return;
        }
        boolean bl = isValidType = this.types == null;
        if (!isValidType && neighborBlock instanceof DragonPressurePlates) {
            DragonPressurePlates plate = (DragonPressurePlates)neighborBlock;
            boolean bl2 = isValidType = this.types == plate.getTypes();
        }
        if (!isValidType) {
            return;
        }
        boolean bl3 = hasPower = level.hasNeighborSignal(position) || level.hasNeighborSignal(position.relative(Direction.UP));
        if (hasPower != (Boolean)state.getValue((Property)POWERED)) {
            if (hasPower != (Boolean)state.getValue((Property)OPEN)) {
                this.playSound(null, level, position, state, hasPower);
            }
            level.setBlock(position, (BlockState)((BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasPower))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(hasPower)), 2);
        }
    }

    private void playSound(@Nullable Entity entity, Level level, BlockPos blockPosition, BlockState blockState, boolean isOpening) {
        level.playSound(entity, blockPosition, this.getSound(blockState, isOpening), SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
    }

    private SoundEvent getSound(BlockState state, boolean isOpening) {
        if (state.is(DSBlockTags.WOODEN_DRAGON_DOORS)) {
            return isOpening ? SoundEvents.WOODEN_DOOR_OPEN : SoundEvents.WOODEN_DOOR_CLOSE;
        }
        return isOpening ? SoundEvents.IRON_DOOR_OPEN : SoundEvents.IRON_DOOR_CLOSE;
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos position, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        boolean canOpen;
        DragonStateHandler data = DragonStateProvider.getData(player);
        if (!data.isDragon()) {
            canOpen = this.allowHumans;
        } else {
            boolean bl = canOpen = this.types == null || data.species().is(this.types);
        }
        if (!this.requiresPower && canOpen) {
            BlockState newState = (BlockState)state.cycle((Property)OPEN);
            level.setBlock(position, newState, 10);
            this.playSound((Entity)player, level, position, newState, (Boolean)newState.getValue((Property)OPEN));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirror) {
        return mirror == Mirror.NONE ? state : (BlockState)state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING))).cycle(HINGE);
    }

    public long getSeed(@NotNull BlockState state, BlockPos position) {
        return Mth.getSeed((int)position.getX(), (int)position.below(0).getY(), (int)position.getZ());
    }

    public boolean canSurvive(@NotNull BlockState state, LevelReader level, BlockPos position) {
        BlockPos below = position.below();
        BlockState stateBelow = level.getBlockState(below);
        return stateBelow.isFaceSturdy((BlockGetter)level, below, Direction.UP);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos position, @NotNull CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean isClosed = (Boolean)state.getValue((Property)OPEN) == false;
        boolean isRightHinge = state.getValue(HINGE) == DoorHingeSide.RIGHT;
        return switch (facing) {
            case Direction.SOUTH -> {
                if (isClosed) {
                    yield SOUTH_AABB;
                }
                if (isRightHinge) {
                    yield EAST_AABB;
                }
                yield WEST_AABB;
            }
            case Direction.WEST -> {
                if (isClosed) {
                    yield WEST_AABB;
                }
                if (isRightHinge) {
                    yield SOUTH_AABB;
                }
                yield NORTH_AABB;
            }
            case Direction.NORTH -> {
                if (isClosed) {
                    yield NORTH_AABB;
                }
                if (isRightHinge) {
                    yield WEST_AABB;
                }
                yield EAST_AABB;
            }
            default -> isClosed ? EAST_AABB : (isRightHinge ? NORTH_AABB : SOUTH_AABB);
        };
    }
}

