/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.blocks;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.DragonBeaconData;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlockEntities;
import by.dragonsurvivalteam.dragonsurvival.registry.DSDataMaps;
import by.dragonsurvivalteam.dragonsurvival.registry.DSSounds;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSItemTags;
import by.dragonsurvivalteam.dragonsurvival.server.tileentity.DragonBeaconBlockEntity;
import by.dragonsurvivalteam.dragonsurvival.util.ExperienceUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragonBeacon
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    @Translation(comments={"Not enough experience to gain the beacon effects (%s / %s)"})
    private static final String NOT_ENOUGH_EXPERIENCE = Translation.Type.GUI.wrap("message.not_enough_experience");

    public DragonBeacon(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos position, @NotNull BlockPos neighborPosition) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(position, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, position, neighborPosition);
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos position, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(position);
        if (!(blockEntity instanceof DragonBeaconBlockEntity)) {
            return InteractionResult.FAIL;
        }
        DragonBeaconBlockEntity beacon = (DragonBeaconBlockEntity)blockEntity;
        int playerExperience = ExperienceUtils.getTotalExperience(player);
        if (player.hasInfiniteMaterials() || playerExperience >= beacon.getExperienceCost()) {
            if (!player.level().isClientSide() && beacon.applyEffects(player, true)) {
                if (!player.hasInfiniteMaterials()) {
                    player.giveExperiencePoints(-beacon.getExperienceCost());
                }
                level.playSound(null, position, (SoundEvent)DSSounds.APPLY_EFFECT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        player.displayClientMessage((Component)Component.translatable((String)NOT_ENOUGH_EXPERIENCE, (Object[])new Object[]{playerExperience, beacon.getExperienceCost()}), true);
        return InteractionResult.FAIL;
    }

    @NotNull
    public ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos position, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!stack.is(DSItemTags.ACTIVATES_DRAGON_BEACON)) {
            return ItemInteractionResult.FAIL;
        }
        DragonStateHandler handler = DragonStateProvider.getData(player);
        if (!handler.isDragon()) {
            return ItemInteractionResult.FAIL;
        }
        if (player.level().isClientSide()) {
            return ItemInteractionResult.sidedSuccess((boolean)true);
        }
        DragonBeaconData beaconData = (DragonBeaconData)handler.species().getData(DSDataMaps.DRAGON_BEACON_DATA);
        if (beaconData == null) {
            return ItemInteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.getBlockEntity(position);
        if (!(blockEntity instanceof DragonBeaconBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        DragonBeaconBlockEntity beacon = (DragonBeaconBlockEntity)blockEntity;
        beacon.setData(beaconData);
        stack.consume(1, (LivingEntity)player);
        level.setBlockAndUpdate(position, (BlockState)state.cycle((Property)BlockStateProperties.LIT));
        level.playSound(null, position, (SoundEvent)DSSounds.ACTIVATE_BEACON.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public boolean triggerEvent(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos position, int id, int param) {
        super.triggerEvent(state, level, position, id, param);
        BlockEntity blockentity = level.getBlockEntity(position);
        return blockentity != null && blockentity.triggerEvent(id, param);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public MenuProvider getMenuProvider(@NotNull BlockState state, Level level, @NotNull BlockPos position) {
        MenuProvider menuProvider;
        BlockEntity blockentity = level.getBlockEntity(position);
        return blockentity instanceof MenuProvider ? (menuProvider = (MenuProvider)blockentity) : null;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.LIT, BlockStateProperties.WATERLOGGED});
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos position, @NotNull BlockState state) {
        return ((BlockEntityType)DSBlockEntities.DRAGON_BEACON.get()).create(position, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return level.isClientSide ? null : BaseEntityBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)DSBlockEntities.DRAGON_BEACON.get()), DragonBeaconBlockEntity::serverTick);
    }
}

