/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.commands.arguments;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.MiscCodecs;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.HolderLookup;
import org.jetbrains.annotations.Nullable;

public class DragonGrowthArgument
implements ArgumentType<Double> {
    public static final String ID = "dragon_growth";
    private final HolderLookup.RegistryLookup<DragonStage> lookup;

    public DragonGrowthArgument(CommandBuildContext context) {
        this.lookup = context.lookupOrThrow(DragonStage.REGISTRY);
    }

    @Nullable
    public Double parse(StringReader reader) throws CommandSyntaxException {
        MiscCodecs.Bounds bounds;
        int start = reader.getCursor();
        double growth = reader.readDouble();
        if (growth < (bounds = DragonStage.getBounds()).min()) {
            reader.setCursor(start);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.doubleTooLow().createWithContext((ImmutableStringReader)reader, (Object)growth, (Object)bounds.min());
        }
        if (growth > bounds.max()) {
            reader.setCursor(start);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.doubleTooHigh().createWithContext((ImmutableStringReader)reader, (Object)growth, (Object)bounds.max());
        }
        return growth;
    }

    public static Double get(CommandContext<?> context) {
        return (Double)context.getArgument(ID, Double.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        ArrayList suggestions = new ArrayList();
        this.lookup.listElements().forEach(element -> suggestions.add(String.valueOf(((DragonStage)element.value()).growthRange().min())));
        return SharedSuggestionProvider.suggest(suggestions, (SuggestionsBuilder)builder);
    }
}

