/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.commands;

import by.dragonsurvivalteam.dragonsurvival.commands.arguments.DragonBodyArgument;
import by.dragonsurvivalteam.dragonsurvival.commands.arguments.DragonSpeciesArgument;
import by.dragonsurvivalteam.dragonsurvival.commands.arguments.DragonStageArgument;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.network.syncing.SyncComplete;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.server.handlers.PlayerLoginHandler;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class DragonCommand {
    @Translation(comments={"There are no available (unlocked) species present"})
    private static final String NO_UNLOCKED_SPECIES = Translation.Type.GUI.wrap("message.no_unlocked_species");

    public static void register(RegisterCommandsEvent event) {
        LiteralCommandNode dragon = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dragon").requires(source -> source.hasPermission(2))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            Holder<DragonSpecies> species = DragonSpecies.getRandom(player);
            if (species == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)NO_UNLOCKED_SPECIES));
                return 0;
            }
            return DragonCommand.runCommand(species, null, null, player);
        })).build();
        ArgumentCommandNode dragonSpecies = ((RequiredArgumentBuilder)Commands.argument((String)"dragon_species", (ArgumentType)new DragonSpeciesArgument(event.getBuildContext())).executes(context -> {
            Holder<DragonSpecies> species = DragonSpeciesArgument.get(context);
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            return DragonCommand.runCommand(species, null, null, serverPlayer);
        })).build();
        ArgumentCommandNode dragonBody = ((RequiredArgumentBuilder)Commands.argument((String)"dragon_body", (ArgumentType)new DragonBodyArgument(event.getBuildContext())).executes(context -> {
            Holder<DragonSpecies> species = DragonSpeciesArgument.get(context);
            Holder<DragonBody> body = DragonBodyArgument.get(context);
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            return DragonCommand.runCommand(species, body, null, serverPlayer);
        })).build();
        ArgumentCommandNode dragonStage = ((RequiredArgumentBuilder)Commands.argument((String)"dragon_stage", (ArgumentType)new DragonStageArgument(event.getBuildContext())).executes(context -> {
            Holder<DragonSpecies> species = DragonSpeciesArgument.get(context);
            Holder<DragonBody> body = DragonBodyArgument.get(context);
            Holder<DragonStage> level = DragonStageArgument.get(context);
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            return DragonCommand.runCommand(species, body, level, serverPlayer);
        })).build();
        ArgumentCommandNode target = ((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).executes(context -> {
            Holder<DragonSpecies> species = DragonSpeciesArgument.get(context);
            Holder<DragonBody> body = DragonBodyArgument.get(context);
            Holder<DragonStage> level = DragonStageArgument.get(context);
            EntitySelector selector = (EntitySelector)context.getArgument("target", EntitySelector.class);
            List serverPlayers = selector.findPlayers((CommandSourceStack)context.getSource());
            serverPlayers.forEach(player -> DragonCommand.runCommand(species, body, level, player));
            return 1;
        })).build();
        event.getDispatcher().getRoot().addChild((CommandNode)dragon);
        dragon.addChild((CommandNode)dragonSpecies);
        dragonSpecies.addChild((CommandNode)dragonBody);
        dragonBody.addChild((CommandNode)dragonStage);
        dragonStage.addChild((CommandNode)target);
    }

    private static int runCommand(Holder<DragonSpecies> species, @Nullable Holder<DragonBody> dragonBody, @Nullable Holder<DragonStage> dragonStage, ServerPlayer player) {
        DragonStateHandler handler = DragonStateProvider.getData((Player)player);
        boolean wasDragon = handler.isDragon();
        if (wasDragon && species.value() == DragonSpeciesArgument.EMPTY) {
            handler.revertToHumanForm((Player)player, false);
            PlayerLoginHandler.syncHandler(player);
            return 1;
        }
        if (species.value() == DragonSpeciesArgument.EMPTY) {
            return 0;
        }
        handler.setSpecies((Player)player, species);
        if (dragonBody == null) {
            dragonBody = DragonBody.getRandomUnlocked(player);
        }
        handler.setBody((Player)player, dragonBody);
        if (dragonStage == null) {
            handler.setGrowth((Player)player, ((DragonSpecies)species.value()).getStartingGrowth((HolderLookup.Provider)player.registryAccess()));
        } else {
            handler.setStage((Player)player, dragonStage);
        }
        handler.setPassengerId(-1);
        handler.isGrowing = true;
        SyncComplete.handleDragonSync(player, false);
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SyncComplete(player.getId(), handler.serializeNBT((HolderLookup.Provider)player.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return 1;
    }
}

