/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.commands;

import by.dragonsurvivalteam.dragonsurvival.commands.arguments.DragonAbilityArgument;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncMagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbility;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.function.BiConsumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class DragonAbilityCommand {
    @Translation(comments={"%s of %s players processed (non-dragons are skipped)"})
    private static final String PROCESSED = Translation.Type.COMMAND.wrap("ability.processed");

    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dragon-ability").requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.literal((String)"remove").then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(source -> DragonAbilityCommand.handleCommand((CommandContext<CommandSourceStack>)source, EntityArgument.getPlayers((CommandContext)source, (String)"targets"), (player, data) -> data.clear((ServerPlayer)player)))).then(Commands.argument((String)"dragon_ability", (ArgumentType)new DragonAbilityArgument(event.getBuildContext())).executes(source -> DragonAbilityCommand.handleCommand((CommandContext<CommandSourceStack>)source, EntityArgument.getPlayers((CommandContext)source, (String)"targets"), (player, data) -> data.removeAbility((Player)player, (ResourceKey<DragonAbility>)DragonAbilityArgument.get(source).getKey()))))))).then(Commands.literal((String)"add").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"dragon_ability", (ArgumentType)new DragonAbilityArgument(event.getBuildContext())).executes(source -> DragonAbilityCommand.handleCommand((CommandContext<CommandSourceStack>)source, EntityArgument.getPlayers((CommandContext)source, (String)"targets"), (player, data) -> data.addAbility((ServerPlayer)player, DragonAbilityArgument.get(source)))))))).then(Commands.literal((String)"refresh").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(source -> DragonAbilityCommand.handleCommand((CommandContext<CommandSourceStack>)source, EntityArgument.getPlayers((CommandContext)source, (String)"targets"), (player, data) -> data.refresh((ServerPlayer)player, DragonStateProvider.getData((Player)player).species()))))));
    }

    private static int handleCommand(CommandContext<CommandSourceStack> source, Collection<? extends Player> targets, BiConsumer<ServerPlayer, MagicData> logic) {
        int processed = 0;
        for (Player player : targets) {
            ServerPlayer player2;
            DragonStateHandler handler;
            if (!(player instanceof ServerPlayer) || !(handler = DragonStateProvider.getData((Player)(player2 = (ServerPlayer)player))).isDragon()) continue;
            MagicData data = MagicData.getData((Player)player2);
            logic.accept(player2, data);
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SyncMagicData(data.serializeNBT((HolderLookup.Provider)player.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ++processed;
        }
        int finalProcessed = processed;
        ((CommandSourceStack)source.getSource()).sendSuccess(() -> Component.translatable((String)PROCESSED, (Object[])new Object[]{finalProcessed, targets.size()}), true);
        return 1;
    }
}

