/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.util;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.GlStateBackup;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class RenderingUtils {
    @Translation(key="min_near_plane", type=Translation.Type.CONFIGURATION, comments={"Lower values prevent x-ray through blocks when using a small entity scale", "A value that is too low may cause issues when rendering chunks when certain (unknown) mods are present"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="min_near_plane")
    public static float MIN_NEAR_PLANE = 0.02f;
    private static ShaderInstance growthCircleShader;

    public static void drawGradientRect(Matrix4f mat, int zLevel, int left, int top, int right, int bottom, int[] color) {
        float[] alpha = new float[4];
        float[] red = new float[4];
        float[] green = new float[4];
        float[] blue = new float[4];
        for (int i = 0; i < 4; ++i) {
            alpha[i] = (float)(color[i] >> 24 & 0xFF) / 255.0f;
            red[i] = (float)(color[i] >> 16 & 0xFF) / 255.0f;
            green[i] = (float)(color[i] >> 8 & 0xFF) / 255.0f;
            blue[i] = (float)(color[i] & 0xFF) / 255.0f;
        }
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        bufferbuilder.addVertex(mat, (float)right, (float)top, (float)zLevel).setColor(red[0], green[0], blue[0], alpha[0]);
        bufferbuilder.addVertex(mat, (float)left, (float)top, (float)zLevel).setColor(red[1], green[1], blue[1], alpha[1]);
        bufferbuilder.addVertex(mat, (float)left, (float)bottom, (float)zLevel).setColor(red[2], green[2], blue[2], alpha[2]);
        bufferbuilder.addVertex(mat, (float)right, (float)bottom, (float)zLevel).setColor(red[3], green[3], blue[3], alpha[3]);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void renderPureColorSquare(PoseStack mStack, int x, int y, int width, int height) {
        Matrix4f mat = mStack.last().pose();
        boolean zLevel = false;
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        for (int i = 0; i <= width; ++i) {
            float val = (float)i / (float)width * 360.0f / 360.0f;
            Color top = new Color(Color.HSBtoRGB(val, 1.0f, 1.0f));
            bufferbuilder.addVertex(mat, (float)(x + i), (float)y, (float)zLevel).setColor((float)top.getRed() / 255.0f, (float)top.getGreen() / 255.0f, (float)top.getBlue() / 255.0f, (float)top.getAlpha() / 255.0f);
            bufferbuilder.addVertex(mat, (float)(x + i), (float)(y + height), (float)zLevel).setColor((float)top.getRed() / 255.0f, (float)top.getGreen() / 255.0f, (float)top.getBlue() / 255.0f, (float)top.getAlpha() / 255.0f);
        }
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void renderColorSquare(@NotNull GuiGraphics guiGraphics, int x, int y, int width, int height) {
        Color bot;
        Color top;
        float val;
        int i;
        Matrix4f mat = guiGraphics.pose().last().pose();
        boolean zLevel = false;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        for (i = 0; i < width; ++i) {
            val = (float)i / (float)width * 360.0f / 360.0f;
            top = new Color(Color.HSBtoRGB(val, 1.0f, 0.0f));
            bot = new Color(Color.HSBtoRGB(val, 1.0f, 1.0f));
            bufferbuilder.addVertex(mat, (float)(x + i), (float)y, (float)zLevel).setColor((float)top.getRed() / 255.0f, (float)top.getGreen() / 255.0f, (float)top.getBlue() / 255.0f, (float)top.getAlpha() / 255.0f);
            bufferbuilder.addVertex(mat, (float)(x + i), (float)y + (float)height / 2.0f, (float)zLevel).setColor((float)bot.getRed() / 255.0f, (float)bot.getGreen() / 255.0f, (float)bot.getBlue() / 255.0f, (float)bot.getAlpha() / 255.0f);
        }
        for (i = 0; i < width; ++i) {
            val = (float)i / (float)width * 360.0f / 360.0f;
            top = new Color(Color.HSBtoRGB(val, 1.0f, 1.0f));
            bot = new Color(Color.HSBtoRGB(val, 0.0f, 1.0f));
            bufferbuilder.addVertex(mat, (float)(x + i), (float)y + (float)height / 2.0f, (float)zLevel).setColor((float)top.getRed() / 255.0f, (float)top.getGreen() / 255.0f, (float)top.getBlue() / 255.0f, (float)top.getAlpha() / 255.0f);
            bufferbuilder.addVertex(mat, (float)(x + i), (float)(y + height), (float)zLevel).setColor((float)bot.getRed() / 255.0f, (float)bot.getGreen() / 255.0f, (float)bot.getBlue() / 255.0f, (float)bot.getAlpha() / 255.0f);
        }
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void fill(@NotNull GuiGraphics guiGraphics, double pMinX, double pMinY, double pMaxX, double pMaxY, int pColor) {
        Matrix4f pMatrix = guiGraphics.pose().last().pose();
        if (pMinX < pMaxX) {
            double i = pMinX;
            pMinX = pMaxX;
            pMaxX = i;
        }
        if (pMinY < pMaxY) {
            double j = pMinY;
            pMinY = pMaxY;
            pMaxY = j;
        }
        float f3 = (float)(pColor >> 24 & 0xFF) / 255.0f;
        float f = (float)(pColor >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(pColor >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(pColor & 0xFF) / 255.0f;
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        bufferbuilder.addVertex(pMatrix, (float)pMinX, (float)pMaxY, 0.0f).setColor(f, f1, f2, f3);
        bufferbuilder.addVertex(pMatrix, (float)pMaxX, (float)pMaxY, 0.0f).setColor(f, f1, f2, f3);
        bufferbuilder.addVertex(pMatrix, (float)pMaxX, (float)pMinY, 0.0f).setColor(f, f1, f2, f3);
        bufferbuilder.addVertex(pMatrix, (float)pMinX, (float)pMinY, 0.0f).setColor(f, f1, f2, f3);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void uploadTexture(NativeImage image, ResourceLocation key) {
        try (NativeImage nativeImage = image;){
            DynamicTexture texture;
            DynamicTexture missing = MissingTextureAtlasSprite.getTexture();
            AbstractTexture abstractTexture = Minecraft.getInstance().getTextureManager().getTexture(key, (AbstractTexture)missing);
            if (abstractTexture instanceof DynamicTexture && (texture = (DynamicTexture)abstractTexture) != missing) {
                texture.setPixels(image);
                texture.upload();
            } else {
                DynamicTexture layer = new DynamicTexture(image);
                Minecraft.getInstance().getTextureManager().register(key, (AbstractTexture)layer);
                image.close();
            }
        }
        catch (Exception exception) {
            DragonSurvival.LOGGER.error("Failed to upload a texture: ", (Throwable)exception);
        }
    }

    public static void copyTextureFromRenderTarget(RenderTarget target, ResourceLocation key) {
        NativeImage image = new NativeImage(target.width, target.height, true);
        RenderSystem.bindTexture((int)target.getColorTextureId());
        image.downloadTexture(0, false);
        RenderingUtils.uploadTexture(image, key);
    }

    @Nullable
    public static NativeImage getImageFromResource(ResourceLocation location) {
        NativeImage image = null;
        try {
            image = NativeImage.read((InputStream)((Resource)Minecraft.getInstance().getResourceManager().getResource(location).get()).open());
        }
        catch (Exception exception) {
            DragonSurvival.LOGGER.warn("Texture resource {} not found!", (Object)location.getPath(), (Object)exception);
        }
        return image;
    }

    public static boolean hasTexture(ResourceLocation resource) {
        DynamicTexture missing = MissingTextureAtlasSprite.getTexture();
        if (resource != null) {
            Minecraft.getInstance().getTextureManager().getTexture(resource);
            AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(resource, (AbstractTexture)missing);
            return texture != missing;
        }
        return false;
    }

    public static void setShaderColor(int color) {
        float alpha = (float)FastColor.ARGB32.alpha((int)color) / 255.0f;
        float red = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float green = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float blue = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void drawGrowthCircle(GuiGraphics guiGraphics, float x, float y, float radius, int sides, float lineWidthPercent, float percent, float targetPercent, Color innerColor, Color outlineColor, Color addColor, Color subtractColor) {
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        float z = 100.0f;
        GlStateBackup state = new GlStateBackup();
        RenderSystem.backupGlState((GlStateBackup)state);
        RenderSystem.backupProjectionMatrix();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float trueX = x + radius;
        float trueY = y + radius;
        bufferbuilder.addVertex(matrix4f, trueX - radius, trueY - radius, z).setUv(0.0f, 1.0f);
        bufferbuilder.addVertex(matrix4f, trueX + radius, trueY - radius, z).setUv(1.0f, 1.0f);
        bufferbuilder.addVertex(matrix4f, trueX + radius, trueY + radius, z).setUv(1.0f, 0.0f);
        bufferbuilder.addVertex(matrix4f, trueX - radius, trueY + radius, z).setUv(0.0f, 0.0f);
        growthCircleShader.setSampler("Sampler0", (Object)Minecraft.getInstance().getTextureManager().getTexture(DragonSurvival.res("textures/shader/swirl_noise.png")));
        growthCircleShader.setSampler("Sampler1", (Object)Minecraft.getInstance().getTextureManager().getTexture(DragonSurvival.res("textures/shader/growth_bar_gradient.png")));
        growthCircleShader.getUniform("Sides").set(sides);
        growthCircleShader.getUniform("LineWidth").set(lineWidthPercent);
        float[] colorComponents = new float[4];
        innerColor.getColorComponents(colorComponents);
        growthCircleShader.getUniform("InnerColor").set(colorComponents[0], colorComponents[1], colorComponents[2], 1.0f);
        outlineColor.getColorComponents(colorComponents);
        growthCircleShader.getUniform("OutlineColor").set(colorComponents[0], colorComponents[1], colorComponents[2], 1.0f);
        addColor.getColorComponents(colorComponents);
        growthCircleShader.getUniform("AddColor").set(colorComponents[0], colorComponents[1], colorComponents[2], 1.0f);
        subtractColor.getColorComponents(colorComponents);
        growthCircleShader.getUniform("SubtractColor").set(colorComponents[0], colorComponents[1], colorComponents[2], 1.0f);
        growthCircleShader.getUniform("Percent").set(percent);
        growthCircleShader.getUniform("TargetPercent").set(targetPercent);
        growthCircleShader.getUniform("ProjMat").set(RenderSystem.getProjectionMatrix());
        growthCircleShader.getUniform("ModelViewMat").set(RenderSystem.getModelViewMatrix());
        growthCircleShader.getUniform("Time").set((float)Blaze3D.getTime() % 1000.0f);
        growthCircleShader.apply();
        BufferUploader.draw((MeshData)bufferbuilder.buildOrThrow());
        growthCircleShader.clear();
        RenderSystem.restoreProjectionMatrix();
        RenderSystem.restoreGlState((GlStateBackup)state);
    }

    public static float getNearPlane(float original) {
        if (Minecraft.getInstance().player == null) {
            return original;
        }
        float scale = Minecraft.getInstance().player.getScale();
        if (scale < 1.0f) {
            return Math.max(MIN_NEAR_PLANE, original * scale);
        }
        return original;
    }

    public static boolean isFirstPerson(Player player) {
        return player == Minecraft.getInstance().player && Minecraft.getInstance().options.getCameraType().isFirstPerson();
    }

    @SubscribeEvent
    public static void registerShaders(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance(event.getResourceProvider(), DragonSurvival.res("growth_circle"), DefaultVertexFormat.POSITION_TEX), instance -> {
            growthCircleShader = instance;
        });
    }
}

