/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects;

import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonStageCustomization;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.LayerSettings;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.util.ResourceHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.extensions.IHolderExtension;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;

public class SkinPreset
implements INBTSerializable<CompoundTag> {
    private static final String MODEL = "model";
    private static final String SPECIES = "species";
    private final Lazy<HashMap<ResourceKey<DragonStage>, Lazy<DragonStageCustomization>>> skins = Lazy.of(this::initialize);
    private ResourceKey<DragonSpecies> species;
    private ResourceLocation model = DragonBody.DEFAULT_MODEL;

    public boolean isEmpty() {
        return ((HashMap)this.skins.get()).values().stream().allMatch(dragonStageCustomizationLazy -> ((DragonStageCustomization)dragonStageCustomizationLazy.get()).layerSettings.values().stream().allMatch(layerSettingsLazy -> Objects.equals(((LayerSettings)layerSettingsLazy.get()).partKey, "none")));
    }

    public void setAllStagesToUseDefaultSkin(boolean defaultSkin) {
        for (ResourceKey<DragonStage> dragonStage : ResourceHelper.keys(null, DragonStage.REGISTRY)) {
            Lazy customizationForStage = (Lazy)((HashMap)this.skins.get()).get(dragonStage);
            if (customizationForStage == null) continue;
            DragonStageCustomization stageCustomization = (DragonStageCustomization)customizationForStage.get();
            stageCustomization.defaultSkin = defaultSkin;
            ((HashMap)this.skins.get()).put(dragonStage, Lazy.of(() -> stageCustomization));
        }
    }

    public boolean isAnyStageUsingDefaultSkin() {
        for (ResourceKey<DragonStage> dragonStage : ResourceHelper.keys(null, DragonStage.REGISTRY)) {
            Lazy customizationForStage = (Lazy)((HashMap)this.skins.get()).get(dragonStage);
            if (customizationForStage == null || !((DragonStageCustomization)customizationForStage.get()).defaultSkin) continue;
            return true;
        }
        return false;
    }

    public boolean isStageUsingDefaultSkin(ResourceKey<DragonStage> dragonStage) {
        return ((DragonStageCustomization)((Lazy)((HashMap)this.skins.get()).get(dragonStage)).get()).defaultSkin;
    }

    public Lazy<DragonStageCustomization> get(ResourceKey<DragonStage> dragonStage) {
        return (Lazy)((HashMap)this.skins.get()).get(dragonStage);
    }

    public void put(ResourceKey<DragonStage> dragonStage, Lazy<DragonStageCustomization> customization) {
        ((HashMap)this.skins.get()).put(dragonStage, customization);
    }

    public void initDefaults(Holder<DragonSpecies> species, ResourceLocation model) {
        if (FMLLoader.getDist().isDedicatedServer()) {
            return;
        }
        if (species == null) {
            return;
        }
        this.species = species.getKey();
        if (model != null) {
            this.model = model;
        }
        if (this.model == null) {
            for (Holder dragonStage : ((DragonSpecies)species.value()).getStages(null)) {
                ((HashMap)this.skins.get()).put(dragonStage.getKey(), Lazy.of(DragonStageCustomization::new));
            }
        } else {
            for (Holder dragonStage : ((DragonSpecies)species.value()).getStages(null)) {
                ((HashMap)this.skins.get()).put(dragonStage.getKey(), Lazy.of(() -> new DragonStageCustomization((ResourceKey<DragonStage>)dragonStage.getKey(), (ResourceKey<DragonSpecies>)species.getKey(), this.model)));
            }
        }
    }

    public HashMap<ResourceKey<DragonStage>, Lazy<DragonStageCustomization>> initialize() {
        List stageKeys;
        if (FMLLoader.getDist().isDedicatedServer()) {
            return new HashMap<ResourceKey<DragonStage>, Lazy<DragonStageCustomization>>();
        }
        HashMap<ResourceKey<DragonStage>, Lazy<DragonStageCustomization>> customizations = new HashMap<ResourceKey<DragonStage>, Lazy<DragonStageCustomization>>();
        if (this.species != null) {
            Optional<Holder.Reference<DragonSpecies>> speciesHolder = ResourceHelper.get(null, this.species);
            stageKeys = speciesHolder.map(dragonSpeciesReference -> ((DragonSpecies)dragonSpeciesReference.value()).getStages(null).stream().map(IHolderExtension::getKey).toList()).orElseGet(List::of);
        } else {
            stageKeys = ResourceHelper.keys(null, DragonStage.REGISTRY);
        }
        for (ResourceKey<DragonStage> dragonStage : stageKeys) {
            customizations.computeIfAbsent(dragonStage, location -> Lazy.of(() -> new DragonStageCustomization(dragonStage, this.species, this.model)));
        }
        return customizations;
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        List stageKeys;
        CompoundTag tag = new CompoundTag();
        tag.putString(MODEL, this.model.toString());
        if (this.species != null) {
            tag.putString(SPECIES, this.species.location().toString());
        }
        if (this.species != null) {
            Optional<Holder.Reference<DragonSpecies>> speciesHolder = ResourceHelper.get(provider, this.species);
            stageKeys = speciesHolder.map(dragonSpeciesReference -> ((DragonSpecies)dragonSpeciesReference.value()).getStages(provider).stream().map(IHolderExtension::getKey).toList()).orElseGet(List::of);
        } else {
            stageKeys = ResourceHelper.keys(provider, DragonStage.REGISTRY);
        }
        for (ResourceKey<DragonStage> dragonStage : stageKeys) {
            if (!((HashMap)this.skins.get()).containsKey(dragonStage)) continue;
            tag.put(dragonStage.location().toString(), (Tag)((DragonStageCustomization)((HashMap)this.skins.get()).getOrDefault(dragonStage, Lazy.of(DragonStageCustomization::new)).get()).serializeNBT(provider));
        }
        return tag;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag base, ResourceKey<DragonSpecies> species) {
        List stageKeys;
        this.species = species;
        ResourceLocation.read((String)base.getString(MODEL)).ifSuccess(model -> {
            this.model = model;
        });
        if (species != null) {
            Optional<Holder.Reference<DragonSpecies>> speciesHolder = ResourceHelper.get(provider, species);
            stageKeys = speciesHolder.map(dragonSpeciesReference -> ((DragonSpecies)dragonSpeciesReference.value()).getStages(provider).stream().map(IHolderExtension::getKey).toList()).orElseGet(List::of);
        } else {
            stageKeys = ResourceHelper.keys(provider, DragonStage.REGISTRY);
        }
        for (ResourceKey<DragonStage> dragonStage : stageKeys) {
            if (!base.contains(dragonStage.location().toString())) continue;
            ((HashMap)this.skins.get()).put(dragonStage, Lazy.of(() -> {
                DragonStageCustomization group = new DragonStageCustomization();
                CompoundTag dragonStageData = base.getCompound(dragonStage.location().toString());
                group.deserializeNBT(provider, dragonStageData);
                return group;
            }));
        }
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag base) {
        List stageKeys;
        this.species = ResourceKey.create(DragonSpecies.REGISTRY, (ResourceLocation)ResourceLocation.parse((String)base.getString(SPECIES)));
        ResourceLocation.read((String)base.getString(MODEL)).ifSuccess(model -> {
            this.model = model;
        });
        if (this.species != null) {
            Optional<Holder.Reference<DragonSpecies>> speciesHolder = ResourceHelper.get(provider, this.species);
            stageKeys = speciesHolder.map(dragonSpeciesReference -> ((DragonSpecies)dragonSpeciesReference.value()).getStages(provider).stream().map(IHolderExtension::getKey).toList()).orElseGet(List::of);
        } else {
            stageKeys = ResourceHelper.keys(provider, DragonStage.REGISTRY);
        }
        for (ResourceKey<DragonStage> dragonStage : stageKeys) {
            if (!base.contains(dragonStage.location().toString())) continue;
            ((HashMap)this.skins.get()).put(dragonStage, Lazy.of(() -> {
                DragonStageCustomization group = new DragonStageCustomization();
                CompoundTag dragonStageData = base.getCompound(dragonStage.location().toString());
                group.deserializeNBT(provider, dragonStageData);
                return group;
            }));
        }
    }

    public ResourceLocation getModel() {
        return this.model;
    }

    public ResourceKey<DragonSpecies> getSpecies() {
        return this.species;
    }
}

