/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render.entity.projectiles;

import by.dragonsurvivalteam.dragonsurvival.common.entity.projectiles.Bolas;
import by.dragonsurvivalteam.dragonsurvival.registry.DSItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BolasEntityRenderer
extends EntityRenderer<Bolas> {
    private static final ResourceLocation BOLAS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/item/dragon_hunting_mesh.png");

    public BolasEntityRenderer(EntityRendererProvider.Context p_174198_) {
        super(p_174198_);
    }

    public void render(Bolas bolas, float yaw, float partialTicks, @NotNull PoseStack stack, @NotNull MultiBufferSource bufferSource, int eventLight) {
        if (bolas.tickCount >= 2 || !(this.entityRenderDispatcher.camera.getEntity().distanceToSqr((Entity)bolas) < 12.25)) {
            stack.pushPose();
            stack.scale(1.2f, 1.2f, 1.2f);
            stack.mulPose(this.entityRenderDispatcher.cameraOrientation());
            stack.mulPose(Axis.YP.rotationDegrees(180.0f));
            Minecraft.getInstance().getItemRenderer().renderStatic(new ItemStack(DSItems.HUNTING_NET), ItemDisplayContext.GROUND, eventLight, OverlayTexture.NO_OVERLAY, stack, bufferSource, bolas.level(), 0);
            stack.popPose();
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull Bolas bolas) {
        return BOLAS_TEXTURE;
    }
}

