/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.particles.dragon;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import org.jetbrains.annotations.NotNull;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class DragonParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final float spread;
    private final boolean swirls;
    private int swirlTick;

    protected DragonParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, double duration, boolean swirls, SpriteSet sprite) {
        super(pLevel, pX, pY, pZ);
        this.setSize(1.0f, 1.0f);
        this.xd = pXSpeed;
        this.yd = pYSpeed;
        this.zd = pZSpeed;
        this.lifetime = (int)duration;
        this.swirlTick = this.random.nextInt(120);
        this.spread = this.random.nextFloat();
        this.hasPhysics = false;
        this.swirls = swirls;
        this.setSpriteFromAge(sprite);
        this.sprites = sprite;
    }

    protected float getU1() {
        return super.getU1() - (super.getU1() - super.getU0()) / 8.0f;
    }

    protected float getV1() {
        return super.getV1() - (super.getV1() - super.getV0()) / 8.0f;
    }

    public void tick() {
        super.tick();
        if (this.swirls) {
            Vector3f motionVec = new Vector3f((float)this.xd, (float)this.yd, (float)this.zd);
            motionVec.normalize();
            float yaw = (float)Math.atan2(motionVec.x(), motionVec.z());
            float pitch = (float)Math.atan2(motionVec.y(), 1.0);
            float swirlRadius = 1.0f * ((float)this.age / (float)this.lifetime) * this.spread;
            Quaternionf quatSpin = new Quaternionf(new AxisAngle4f((float)this.swirlTick * 0.2f, motionVec.x(), motionVec.y(), motionVec.z()));
            Quaternionf quatOrient = new Quaternionf().rotateXYZ(pitch, yaw, 0.0f);
            Vector3f vec = new Vector3f(swirlRadius, 0.0f, 0.0f);
            vec = quatSpin.transform(vec);
            vec = quatOrient.transform(vec);
            this.x += (double)vec.x();
            this.y += (double)vec.y();
            this.z += (double)vec.z();
        }
        if (this.age >= this.lifetime) {
            this.remove();
        }
        ++this.age;
        ++this.swirlTick;
        this.setSpriteFromAge(this.sprites);
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void render(@NotNull VertexConsumer buffer, @NotNull Camera renderInfo, float partialTicks) {
        float var = ((float)this.age + partialTicks) / (float)this.lifetime;
        this.alpha = (float)(1.0 - Math.exp(10.0f * (var - 1.0f)) - Math.pow(2000.0, -var));
        if ((double)this.alpha < 0.1) {
            this.alpha = 0.1f;
        }
        super.render(buffer, renderInfo, partialTicks);
    }
}

