/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.NotNull;

public class BeaconParticle
extends TextureSheetParticle {
    private final double fallSpeed;

    public BeaconParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z, xd, yd, zd);
        this.gravity = 0.9f;
        this.fallSpeed = 0.02;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.yd += this.fallSpeed;
            this.move(0.0, this.yd, 0.0);
            if (this.y == this.yo) {
                this.xd *= 1.1;
                this.zd *= 1.1;
            }
            this.yd *= (double)0.7f;
            if (this.onGround) {
                this.xd *= (double)0.96f;
                this.zd *= (double)0.96f;
            }
        }
    }

    public static BeaconParticle createParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, SpriteSet spriteSet) {
        BeaconParticle beaconParticle = new BeaconParticle(level, x, y, z, xd, yd, zd);
        beaconParticle.pickSprite(spriteSet);
        return beaconParticle;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class PeaceFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public PeaceFactory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return BeaconParticle.createParticle(level, x, y, z, xd, yd, zd, this.spriteSet);
        }
    }

    public static class MagicFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public MagicFactory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return BeaconParticle.createParticle(level, x, y, z, xd, yd, zd, this.spriteSet);
        }
    }

    public static class FireFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public FireFactory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return BeaconParticle.createParticle(level, x, y, z, xd, yd, zd, this.spriteSet);
        }
    }
}

