/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.handlers;

import by.dragonsurvivalteam.dragonsurvival.client.handlers.ClientFlightHandler;
import by.dragonsurvivalteam.dragonsurvival.client.handlers.DragonDestructionHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.input.Keybind;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncSummonedEntitiesBehaviour;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.DSLanguageProvider;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(value={Dist.CLIENT})
public class KeyHandler {
    @Translation(comments={"%s is now set to %s"})
    public static final String CYCLED_ENUM = Translation.Type.GUI.wrap("display.cycle_enum");

    public static Component cycledEnum(Enum<?> enumValue) {
        Component type = DSLanguageProvider.enumClass(enumValue);
        Component value = DSLanguageProvider.enumValue(enumValue);
        return Component.translatable((String)CYCLED_ENUM, (Object[])new Object[]{type, value});
    }

    @SubscribeEvent
    public static void handleKey(InputEvent.Key event) {
        KeyHandler.handleKeybinds(InputConstants.getKey((int)event.getKey(), (int)event.getScanCode()), event.getAction());
    }

    @SubscribeEvent
    public static void handleMouse(InputEvent.MouseButton.Pre event) {
        KeyHandler.handleKeybinds(InputConstants.Type.MOUSE.getOrCreate(event.getButton()), event.getAction());
    }

    private static void handleKeybinds(InputConstants.Key input, int action) {
        ClientFlightHandler.toggleWings(KeyHandler.checkAndGet(input, action, Keybind.TOGGLE_FLIGHT, true));
        ClientFlightHandler.triggerSpin(KeyHandler.checkAndGet(input, action, Keybind.SPIN_ABILITY, true));
        DragonDestructionHandler.toggleDestructionMode(KeyHandler.checkAndGet(input, action, Keybind.TOGGLE_LARGE_DRAGON_DESTRUCTION, true));
        KeyHandler.toggleSummonBehaviour(KeyHandler.checkAndGet(input, action, Keybind.TOGGLE_SUMMON_BEHAVIOUR, false));
        DragonDestructionHandler.toggleMultiMining(KeyHandler.checkAndGet(input, action, Keybind.TOGGLE_MULTI_MINING, false));
    }

    public static void toggleSummonBehaviour(@Nullable Pair<Player, DragonStateHandler> data) {
        if (data == null) {
            return;
        }
        ((Player)data.getFirst()).getExistingData(DSDataAttachments.SUMMONED_ENTITIES).ifPresent(summonData -> {
            if (Screen.hasShiftDown()) {
                summonData.movementBehaviour = Functions.cycleEnum(summonData.movementBehaviour);
                ((Player)data.getFirst()).displayClientMessage(KeyHandler.cycledEnum(summonData.movementBehaviour), true);
            } else {
                summonData.attackBehaviour = Functions.cycleEnum(summonData.attackBehaviour);
                ((Player)data.getFirst()).displayClientMessage(KeyHandler.cycledEnum(summonData.attackBehaviour), true);
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncSummonedEntitiesBehaviour(summonData.attackBehaviour, summonData.movementBehaviour), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
    }

    @Nullable
    public static Pair<Player, DragonStateHandler> checkAndGet(InputConstants.Key input, int action, Keybind keybind, boolean dragonOnly) {
        if (Minecraft.getInstance().screen != null || action != 1 || !keybind.matches(input)) {
            return null;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return null;
        }
        DragonStateHandler data = DragonStateProvider.getData((Player)player);
        if (dragonOnly && !data.isDragon()) {
            return null;
        }
        return Pair.of((Object)player, (Object)data);
    }
}

