/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.handlers;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.sounds.FastGlideSound;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SpinDurationAndCooldown;
import by.dragonsurvivalteam.dragonsurvival.network.flight.ToggleFlight;
import by.dragonsurvivalteam.dragonsurvival.registry.DSAttributes;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.FlightData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.server.handlers.ServerFlightHandler;
import by.dragonsurvivalteam.dragonsurvival.util.ActionWithTimedCooldown;
import by.dragonsurvivalteam.dragonsurvival.util.EnchantmentUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import by.dragonsurvivalteam.dragonsurvival.util.TickedCooldown;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.CalculateDetachedCameraDistanceEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@EventBusSubscriber(value={Dist.CLIENT})
public class ClientFlightHandler {
    @Translation(comments={"You can't fly. Read more in the skill description."})
    private static final String FLIGHT_EFFECT_DISABLED = Translation.Type.GUI.wrap("message.flight_effect_disabled");
    @Translation(comments={"Your species does not have the ability to fly"})
    private static final String NO_FLIGHT_EFFECT = Translation.Type.GUI.wrap("message.no_flight_effect");
    @Translation(comments={"Your wings are blocked or broken"})
    private static final String WINGS_BLOCKED = Translation.Type.GUI.wrap("message.wings_blocked");
    @Translation(key="jump_to_fly", type=Translation.Type.CONFIGURATION, comments={"If enabled flight will be activated when jumping in the air"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"flight"}, key="jump_to_fly")
    public static Boolean jumpToFly = false;
    @Translation(key="look_at_sky_for_flight", type=Translation.Type.CONFIGURATION, comments={"If enabled together with [jump_to_fly] you will be required to look at the sky to start flying"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"flight"}, key="lookAtSkyForFlight")
    public static Boolean lookAtSkyForFlight = false;
    @Translation(key="flight_zoom_effect", type=Translation.Type.CONFIGURATION, comments={"Enable / Disable a zoom effect while gliding as a dragon"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"flight"}, key="flight_zoom_effect")
    public static Boolean flightZoomEffect = true;
    @Translation(key="flight_camera_movement", type=Translation.Type.CONFIGURATION, comments={"Enable / Disable camera movement while gliding as a dragon"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"flight"}, key="flight_camera_movement")
    public static Boolean flightCameraMovement = true;
    @ConfigRange(min=0.0, max=32.0)
    @Translation(key="base_dragon_camera_offset", type=Translation.Type.CONFIGURATION, comments={"Base offset for the dragon's third person camera (is multiplied and scaled by the other factors)"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="base_dragon_camera_offset")
    public static Float baseDragonCameraOffset = Float.valueOf(16.0f);
    @ConfigRange(min=0.0, max=32.0)
    @Translation(key="flat_dragon_camera_offset", type=Translation.Type.CONFIGURATION, comments={"Flat offset for the dragon's third person camera (is added after all other factors are combined)"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="flat_dragon_camera_offset")
    public static Float flatDragonCameraOffset = Float.valueOf(2.0f);
    @ConfigRange(min=0.0, max=1.0)
    @Translation(key="dragon_camera_minimum_scale", type=Translation.Type.CONFIGURATION, comments={"The scale at which the dragon's third person camera will stop zooming in"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="dragon_camera_minimum_scale")
    public static Float dragonCameraMinimumScale = Float.valueOf(0.5f);
    @ConfigRange(min=0.0, max=2.0)
    @Translation(key="dragon_camera_scale_factor", type=Translation.Type.CONFIGURATION, comments={"How much scale impacts the third person camera distance"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="dragon_camera_scale_factor")
    public static Float dragonCameraScaleFactor = Float.valueOf(0.15f);
    @Translation(key="disable_size_camera_modifications", type=Translation.Type.CONFIGURATION, comments={"Disable all size-based camera modifications from DS"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="disable_camera_modifications")
    public static Boolean disableSizeCameraModifications = false;
    private static final ActionWithTimedCooldown HUNGER_MESSAGE_WITH_COOLDOWN = new ActionWithTimedCooldown(30000L, () -> {
        Player localPlayer = DragonSurvival.PROXY.getLocalPlayer();
        if (localPlayer == null) {
            return;
        }
        localPlayer.sendSystemMessage((Component)Component.translatable((String)LangKey.MESSAGE_NO_HUNGER));
    });
    public static int lastSync;
    public static boolean wasGliding;
    public static boolean wasFlying;
    static double ax;
    static double ay;
    static double az;
    static float lastIncrease;
    static float lastZoom;
    private static final Vec3 ELYTRA_FLY_DRAG;
    private static final TickedCooldown jumpFlyCooldown;
    private static boolean lastJumpInputState;

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void flightCamera(CalculateDetachedCameraDistanceEvent event) {
        if (DragonSurvival.PROXY.dragonRenderingWasCancelled(DragonSurvival.PROXY.getLocalPlayer())) {
            return;
        }
        DragonStateProvider.getOptional((Entity)DragonSurvival.PROXY.getLocalPlayer()).ifPresent(handler -> {
            if (handler.isDragon()) {
                float visualScale = (float)handler.getVisualScale(DragonSurvival.PROXY.getLocalPlayer(), Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false));
                if (disableSizeCameraModifications.booleanValue()) {
                    event.setDistance(event.getDistance() / event.getEntityScalingFactor() * visualScale);
                } else {
                    event.setDistance((event.getDistance() + baseDragonCameraOffset.floatValue()) / event.getEntityScalingFactor() * Math.max(visualScale, dragonCameraMinimumScale.floatValue()) * dragonCameraScaleFactor.floatValue() + flatDragonCameraOffset.floatValue());
                }
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void flightCamera(ViewportEvent.ComputeCameraAngles setup) {
        if (DragonSurvival.PROXY.dragonRenderingWasCancelled(DragonSurvival.PROXY.getLocalPlayer())) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer currentPlayer = minecraft.player;
        Camera info = setup.getCamera();
        if (currentPlayer != null && currentPlayer.isAddedToLevel() && DragonStateProvider.isDragon((Entity)currentPlayer)) {
            GameRenderer gameRenderer = minecraft.gameRenderer;
            if (ServerFlightHandler.isGliding((Player)currentPlayer)) {
                Vec3 lookVec;
                if (setup.getCamera().isDetached() && flightCameraMovement.booleanValue()) {
                    lookVec = currentPlayer.getLookAngle();
                    float increase = (float)Mth.clamp((double)(lookVec.y * 10.0), (double)0.0, (double)(lookVec.y * 5.0));
                    float gradualIncrease = Mth.lerp((float)0.25f, (float)lastIncrease, (float)increase);
                    info.move(0.0f, gradualIncrease, 0.0f);
                    lastIncrease = gradualIncrease;
                }
                if (minecraft.player != null && flightZoomEffect.booleanValue() && !minecraft.options.getCameraType().isFirstPerson()) {
                    float newZoom;
                    lookVec = currentPlayer.getLookAngle();
                    float f = Math.min(Math.max(0.5f, 1.0f - (float)(lookVec.y * 5.0 / 2.5 * 0.5)), 3.0f);
                    gameRenderer.zoom = newZoom = Mth.lerp((float)0.25f, (float)lastZoom, (float)f);
                    lastZoom = newZoom;
                }
            } else {
                if (lastIncrease > 0.0f && flightCameraMovement.booleanValue()) {
                    lastIncrease = Mth.lerp((float)0.25f, (float)lastIncrease, (float)0.0f);
                    info.move(0.0f, lastIncrease, 0.0f);
                }
                if (lastZoom != 1.0f && flightZoomEffect.booleanValue()) {
                    gameRenderer.zoom = lastZoom = Mth.lerp((float)0.25f, (float)lastZoom, (float)1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void flightParticles(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        FlightData spin = FlightData.getData(player);
        if (!DragonStateProvider.isDragon((Entity)player) || spin.duration <= 0) {
            return;
        }
        if (ServerFlightHandler.canSwimSpin(player) && ServerFlightHandler.isSpin(player)) {
            ClientFlightHandler.spawnSpinParticle(player, (ParticleOptions)(player.isInWater() ? ParticleTypes.BUBBLE_COLUMN_UP : ParticleTypes.LAVA));
        }
        if (EnchantmentUtils.getLevel((LivingEntity)player, (ResourceKey<Enchantment>)Enchantments.FIRE_ASPECT) > 0) {
            ClientFlightHandler.spawnSpinParticle(player, (ParticleOptions)ParticleTypes.LAVA);
        } else if (EnchantmentUtils.getLevel((LivingEntity)player, (ResourceKey<Enchantment>)Enchantments.KNOCKBACK) > 0) {
            ClientFlightHandler.spawnSpinParticle(player, (ParticleOptions)ParticleTypes.EXPLOSION);
        } else if (EnchantmentUtils.getLevel((LivingEntity)player, (ResourceKey<Enchantment>)Enchantments.SWEEPING_EDGE) > 0) {
            ClientFlightHandler.spawnSpinParticle(player, (ParticleOptions)ParticleTypes.SWEEP_ATTACK);
        } else if (EnchantmentUtils.getLevel((LivingEntity)player, (ResourceKey<Enchantment>)Enchantments.SHARPNESS) > 0) {
            ClientFlightHandler.spawnSpinParticle(player, (ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f));
        } else if (EnchantmentUtils.getLevel((LivingEntity)player, (ResourceKey<Enchantment>)Enchantments.SMITE) > 0) {
            ClientFlightHandler.spawnSpinParticle(player, (ParticleOptions)ParticleTypes.ENCHANT);
        } else if (EnchantmentUtils.getLevel((LivingEntity)player, (ResourceKey<Enchantment>)Enchantments.BANE_OF_ARTHROPODS) > 0) {
            ClientFlightHandler.spawnSpinParticle(player, (ParticleOptions)ParticleTypes.DRIPPING_OBSIDIAN_TEAR);
        }
    }

    @SubscribeEvent
    public static void flightControl(ClientTickEvent.Pre event) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (!(player == null || player.isPassenger() || Minecraft.getInstance().isPaused() || player.hasEffect(MobEffects.LEVITATION))) {
            DragonStateProvider.getOptional((Entity)player).ifPresent(handler -> {
                if (handler.isDragon()) {
                    Double flightSpeedMultiplier = player.getAttributeValue(DSAttributes.FLIGHT_SPEED);
                    Vec3 viewVector = player.getLookAngle();
                    double yaw = Math.toRadians(player.getYHeadRot() + 90.0f);
                    if (ServerFlightHandler.canSwimSpin((Player)player) && ServerFlightHandler.isSpin((Player)player)) {
                        Vec3 deltaMovement = player.getDeltaMovement();
                        double maxFlightSpeed = ServerFlightHandler.maxFlightSpeed;
                        ax = Mth.clamp((double)ax, (double)(-0.4 * maxFlightSpeed), (double)(0.4 * maxFlightSpeed));
                        az = Mth.clamp((double)az, (double)(-0.4 * maxFlightSpeed), (double)(0.4 * maxFlightSpeed));
                        ay = viewVector.y / 8.0;
                        deltaMovement = viewVector.y < 0.0 ? deltaMovement.add(ax, 0.0, az) : deltaMovement.add(ax += Math.cos(yaw) / 500.0 * 50.0 * 2.0, ay, az += Math.sin(yaw) / 500.0 * 50.0 * 2.0);
                        player.setDeltaMovement(deltaMovement);
                        ay = player.getDeltaMovement().y;
                    }
                    if (FlightData.getData((Player)player).isWingsSpread()) {
                        Input movement = player.input;
                        if (!ToggleFlight.hasEnoughFoodToStartFlight((Player)player) || player.isCreative()) {
                            ay = Mth.clamp((double)Math.abs(ay * 4.0), (double)(-0.4 * ServerFlightHandler.maxFlightSpeed), (double)(0.4 * ServerFlightHandler.maxFlightSpeed));
                        }
                        if (ServerFlightHandler.isFlying((Player)player)) {
                            if (!wasFlying) {
                                wasFlying = true;
                            }
                            Vec3 deltaMovement = player.getDeltaMovement();
                            double horizontalView = viewVector.horizontalDistance();
                            double horizontalMovement = deltaMovement.horizontalDistance();
                            double lookMagnitude = viewVector.length();
                            float pitch = (float)Math.toRadians(player.getXRot());
                            float verticalDelta = Mth.cos((float)pitch);
                            verticalDelta = (float)((double)verticalDelta * (double)verticalDelta * Math.min(1.0, lookMagnitude / 0.4));
                            double gravity = player.getAttributeValue(Attributes.GRAVITY);
                            if (ServerFlightHandler.isGliding((Player)player) && !wasGliding) {
                                Minecraft.getInstance().getSoundManager().play((SoundInstance)new FastGlideSound(player));
                                wasGliding = true;
                            }
                            if (ServerFlightHandler.isGliding((Player)player) || ax != 0.0 || az != 0.0) {
                                deltaMovement = player.getDeltaMovement().add(0.0, gravity * (-1.0 + (double)verticalDelta * 0.75), 0.0);
                                if (deltaMovement.y < 0.0 && horizontalView > 0.0) {
                                    double downwardMomentum = deltaMovement.y * -0.1 * (double)verticalDelta * flightSpeedMultiplier;
                                    deltaMovement = deltaMovement.add(viewVector.x * downwardMomentum / horizontalView, downwardMomentum, viewVector.z * downwardMomentum / horizontalView);
                                }
                                if (pitch < 0.0f && horizontalView > 0.0) {
                                    double delta = horizontalMovement * (double)(-Mth.sin((float)pitch)) * 0.04 * flightSpeedMultiplier;
                                    deltaMovement = deltaMovement.add(-viewVector.x * delta / horizontalView, delta * 3.2, -viewVector.z * delta / horizontalView);
                                }
                                if (horizontalView > 0.0) {
                                    deltaMovement = deltaMovement.add((viewVector.x * flightSpeedMultiplier / horizontalView * horizontalMovement - deltaMovement.x) * 0.1, 0.0, (viewVector.z * flightSpeedMultiplier / horizontalView * horizontalMovement - deltaMovement.z) * 0.1);
                                }
                                if (viewVector.y < 0.0) {
                                    ax += Math.cos(yaw) * flightSpeedMultiplier * 2.0 / 500.0;
                                    az += Math.sin(yaw) * flightSpeedMultiplier * 2.0 / 500.0;
                                } else {
                                    ay = viewVector.y / 4.0;
                                    ax *= 0.98;
                                    az *= 0.98;
                                }
                                double speedLimit = ServerFlightHandler.maxFlightSpeed * flightSpeedMultiplier;
                                ax = Mth.clamp((double)ax, (double)(-0.4 * speedLimit), (double)(0.4 * speedLimit));
                                az = Mth.clamp((double)az, (double)(-0.4 * speedLimit), (double)(0.4 * speedLimit));
                                if (ServerFlightHandler.isSpin((Player)player)) {
                                    ax += Math.cos(yaw) * flightSpeedMultiplier * 100.0 * 2.0 / 500.0;
                                    az += Math.sin(yaw) * flightSpeedMultiplier * 100.0 * 2.0 / 500.0;
                                    ay = viewVector.y / 4.0;
                                }
                                if (ServerFlightHandler.isGliding((Player)player)) {
                                    deltaMovement = viewVector.y < 0.0 ? deltaMovement.add(ax, 0.0, az) : (Math.abs(horizontalMovement) > 0.4 || ServerFlightHandler.noSpeedRequirementForVerticalAcceleration != false ? deltaMovement.add(ax, ay, az) : deltaMovement.add(ax, ay * horizontalMovement, az));
                                    deltaMovement = deltaMovement.multiply(ELYTRA_FLY_DRAG);
                                    player.setDeltaMovement(deltaMovement);
                                    ay = player.getDeltaMovement().y;
                                }
                            }
                            if (!ServerFlightHandler.isGliding((Player)player)) {
                                boolean moving;
                                wasGliding = false;
                                double maxForward = 0.5 * flightSpeedMultiplier * 2.0;
                                Vec3 moveVector = ClientFlightHandler.getInputVector(new Vec3((double)movement.leftImpulse, 0.0, (double)movement.forwardImpulse), 1.0f, player.getYRot());
                                moveVector.multiply(1.3 * flightSpeedMultiplier * 2.0, 0.0, 1.3 * flightSpeedMultiplier * 2.0);
                                boolean bl = moving = movement.up || movement.down || movement.left || movement.right;
                                if (ServerFlightHandler.isSpin((Player)player)) {
                                    ax += Math.cos(yaw) * flightSpeedMultiplier * 200.0 * 2.0 / 500.0;
                                    az += Math.sin(yaw) * flightSpeedMultiplier * 200.0 * 2.0 / 500.0;
                                    ay = viewVector.y / 8.0;
                                }
                                if (!(!ServerFlightHandler.stableHover || movement.jumping || movement.shiftKeyDown || ServerFlightHandler.isSpin((Player)player) || ServerFlightHandler.isGliding((Player)player))) {
                                    ay = Math.max(ay, gravity * 1.1);
                                }
                                if (moving && !movement.jumping && !movement.shiftKeyDown) {
                                    maxForward = 0.8 * flightSpeedMultiplier * 2.0;
                                    moveVector.multiply(1.4 * flightSpeedMultiplier * 2.0, 0.0, 1.4 * flightSpeedMultiplier * 2.0);
                                    deltaMovement = new Vec3(Mth.lerp((double)0.14, (double)deltaMovement.x, (double)moveVector.x), 0.0, Mth.lerp((double)0.14, (double)deltaMovement.z, (double)moveVector.z));
                                    deltaMovement = new Vec3(Mth.clamp((double)deltaMovement.x, (double)(-maxForward), (double)maxForward), 0.0, Mth.clamp((double)deltaMovement.z, (double)(-maxForward), (double)maxForward));
                                    deltaMovement = deltaMovement.add(ax, ay, az);
                                    ax *= (double)0.9f;
                                    ay *= (double)0.9f;
                                    az *= (double)0.9f;
                                    deltaMovement = !ServerFlightHandler.stableHover ? new Vec3(deltaMovement.x, -(gravity * 2.0) + deltaMovement.y, deltaMovement.z) : new Vec3(deltaMovement.x, -gravity + deltaMovement.y, deltaMovement.z);
                                    player.setDeltaMovement(deltaMovement);
                                } else {
                                    deltaMovement = deltaMovement.multiply((double)0.99f, (double)0.98f, (double)0.99f);
                                    deltaMovement = new Vec3(Mth.lerp((double)0.14, (double)deltaMovement.x, (double)moveVector.x), 0.0, Mth.lerp((double)0.14, (double)deltaMovement.z, (double)moveVector.z));
                                    deltaMovement = new Vec3(Mth.clamp((double)deltaMovement.x, (double)(-maxForward), (double)maxForward), 0.0, Mth.clamp((double)deltaMovement.z, (double)(-maxForward), (double)maxForward));
                                    deltaMovement = deltaMovement.add(ax, ay, az);
                                    if (ServerFlightHandler.isSpin((Player)player)) {
                                        deltaMovement.multiply(10.0, 10.0, 10.0);
                                    }
                                    ax *= (double)0.9f;
                                    ay *= (double)0.9f;
                                    az *= (double)0.9f;
                                    if (movement.jumping) {
                                        deltaMovement = new Vec3(deltaMovement.x, 0.4 + deltaMovement.y, deltaMovement.z);
                                        player.setDeltaMovement(deltaMovement);
                                    } else if (movement.shiftKeyDown) {
                                        deltaMovement = new Vec3(deltaMovement.x, -0.5 + deltaMovement.y, deltaMovement.z);
                                        player.setDeltaMovement(deltaMovement);
                                    } else if (wasFlying) {
                                        double yMotion = ToggleFlight.hasEnoughFoodToStartFlight((Player)player) ? -gravity + ay : -(gravity * 4.0) + ay;
                                        deltaMovement = new Vec3(deltaMovement.x, yMotion, deltaMovement.z);
                                        player.setDeltaMovement(deltaMovement);
                                    }
                                }
                            }
                        } else {
                            wasGliding = false;
                            wasFlying = false;
                            ax = 0.0;
                            az = 0.0;
                            ay = 0.0;
                        }
                    } else {
                        ax = 0.0;
                        az = 0.0;
                        ay = 0.0;
                    }
                }
            });
        }
    }

    public static void toggleWings(@Nullable Pair<Player, DragonStateHandler> data) {
        if (data == null) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new ToggleFlight(ToggleFlight.Activation.MANUAL, ToggleFlight.Result.NONE), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void tryJumpToFly(Player player) {
        if (!jumpToFly.booleanValue()) {
            return;
        }
        if (player.isCreative() || player.isSpectator()) {
            return;
        }
        if (lookAtSkyForFlight.booleanValue() && player.getLookAngle().y() <= 0.8) {
            return;
        }
        if (player.isInLava() || player.isInWater()) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new ToggleFlight(ToggleFlight.Activation.JUMP, ToggleFlight.Result.NONE), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void handleToggleResult(ToggleFlight.Activation activation, ToggleFlight.Result result) {
        Player player = (Player)Objects.requireNonNull(Minecraft.getInstance().player);
        if (activation == ToggleFlight.Activation.MANUAL) {
            switch (result) {
                case NO_WINGS: {
                    player.sendSystemMessage((Component)Component.translatable((String)NO_FLIGHT_EFFECT));
                    break;
                }
                case DISABLED: {
                    player.sendSystemMessage((Component)Component.translatable((String)FLIGHT_EFFECT_DISABLED));
                    break;
                }
                case WINGS_BLOCKED: {
                    player.sendSystemMessage((Component)Component.translatable((String)WINGS_BLOCKED));
                    break;
                }
                case NO_HUNGER: {
                    player.sendSystemMessage((Component)Component.translatable((String)LangKey.MESSAGE_NO_HUNGER));
                }
            }
        } else if (result == ToggleFlight.Result.NO_HUNGER) {
            HUNGER_MESSAGE_WITH_COOLDOWN.tryRun();
        }
    }

    public static void triggerSpin(@Nullable Pair<Player, DragonStateHandler> data) {
        if (data == null) {
            return;
        }
        Player player = (Player)data.getFirst();
        if (ServerFlightHandler.isSpin(player)) {
            return;
        }
        FlightData spin = FlightData.getData(player);
        if (!spin.hasSpin || spin.cooldown > 0) {
            return;
        }
        if (ServerFlightHandler.isFlying(player) || ServerFlightHandler.canSwimSpin(player)) {
            spin.duration = ServerFlightHandler.SPIN_DURATION;
            spin.cooldown = Functions.secondsToTicks(ServerFlightHandler.flightSpinCooldown.intValue());
            PacketDistributor.sendToServer((CustomPacketPayload)new SpinDurationAndCooldown(player.getId(), spin.duration, spin.cooldown), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        DragonStateHandler handler = DragonStateProvider.getData((Player)player);
        if (!handler.isDragon()) {
            return;
        }
        jumpFlyCooldown.tick();
        boolean isJumping = Minecraft.getInstance().options.keyJump.isDown();
        if (isJumping && !lastJumpInputState && !jumpFlyCooldown.trySet()) {
            ClientFlightHandler.tryJumpToFly((Player)player);
        }
        lastJumpInputState = isJumping;
    }

    private static void spawnSpinParticle(Player player, ParticleOptions particleData) {
        for (int i = 0; i < 20; ++i) {
            double d0 = ((double)player.getRandom().nextFloat() - 0.5) * 2.0;
            double d1 = ((double)player.getRandom().nextFloat() - 0.5) * 2.0;
            double d2 = ((double)player.getRandom().nextFloat() - 0.5) * 2.0;
            double posX = player.position().x + player.getDeltaMovement().x + d0;
            double posY = player.position().y - 1.5 + player.getDeltaMovement().y + d1;
            double posZ = player.position().z + player.getDeltaMovement().z + d2;
            player.level().addParticle(particleData, posX, posY, posZ, player.getDeltaMovement().x * -1.0, player.getDeltaMovement().y * -1.0, player.getDeltaMovement().z * -1.0);
        }
    }

    public static Vec3 getInputVector(Vec3 movement, float frictionSpeed, float yRot) {
        double movementStrength = movement.lengthSqr();
        if (movementStrength < 1.0E-7) {
            return Vec3.ZERO;
        }
        Vec3 vector3d = (movementStrength > 1.0 ? movement.normalize() : movement).scale((double)frictionSpeed);
        float f = Mth.sin((float)(yRot * ((float)Math.PI / 180)));
        float f1 = Mth.cos((float)(yRot * ((float)Math.PI / 180)));
        return new Vec3(vector3d.x * (double)f1 - vector3d.z * (double)f, vector3d.y, vector3d.z * (double)f1 + vector3d.x * (double)f);
    }

    static {
        lastZoom = 1.0f;
        ELYTRA_FLY_DRAG = new Vec3(0.99, 0.98, 0.99);
        jumpFlyCooldown = new TickedCooldown(7L);
    }
}

