/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components;

import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.ConfirmableScreen;
import by.dragonsurvivalteam.dragonsurvival.client.util.TextRenderUtil;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;

public class DragonEditorConfirmComponent
extends AbstractContainerEventHandler
implements Renderable {
    @Translation(comments={"\nWith your current config settings \u00a74all progress will be lost\u00a7r\u00a7f when changing species.\n\nWould you still like to continue?"})
    private static final String CONFIRM_LOSE_ALL = Translation.Type.GUI.wrap("dragon_editor.confirm.all");
    @Translation(comments={"\nWith your current config settings \u00a74your growth progress will be lost\u00a7r\u00a7f when changing species or body types.\n\nWould you still like to continue?"})
    private static final String CONFIRM_LOSE_GROWTH = Translation.Type.GUI.wrap("dragon_editor.confirm.growth");
    @Translation(comments={"\nWith your current config settings \u00a74your ability progress will be lost\u00a7r\u00a7f when changing species.\n\nWould you still like to continue?"})
    private static final String CONFIRM_LOSE_ABILITIES = Translation.Type.GUI.wrap("dragon_editor.confirm.abilities");
    private static final ResourceLocation WARNING_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/warning_main.png");
    private static final ResourceLocation WARNING_ACCEPT = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/warning_accept.png");
    private static final ResourceLocation WARNING_CANCEL = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/warning_cancel.png");
    private final AbstractWidget confirmButton;
    private final AbstractWidget cancelButton;
    public boolean visible;
    public boolean isBodyTypeChange;
    private final int x;
    private final int y;
    private final int xSize;
    private final int ySize;

    public DragonEditorConfirmComponent(final ConfirmableScreen screen, int x, int y, int xSize, int ySize) {
        this.x = x;
        this.y = y;
        this.xSize = xSize;
        this.ySize = ySize;
        this.isBodyTypeChange = false;
        this.confirmButton = new ExtendedButton(this, x + 3, y + 132, 60, 19, CommonComponents.GUI_YES, action -> {}){

            public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
                guiGraphics.drawCenteredString(Minecraft.getInstance().font, this.getMessage(), this.getX() + this.getWidth() / 2, this.getY() + (this.getHeight() - 8) / 2, this.getFGColor());
                if (this.isHovered()) {
                    guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.translatable((String)LangKey.GUI_CONFIRM), mouseX, mouseY);
                }
            }

            public void onPress() {
                screen.confirm();
            }
        };
        this.cancelButton = new ExtendedButton(this, x + 66, y + 132, 60, 19, CommonComponents.GUI_NO, action -> {}){

            public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
                guiGraphics.drawCenteredString(Minecraft.getInstance().font, this.getMessage(), this.getX() + this.getWidth() / 2, this.getY() + (this.getHeight() - 8) / 2, this.getFGColor());
                if (this.isHovered) {
                    guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.translatable((String)LangKey.GUI_CANCEL), mouseX, mouseY);
                }
            }

            public void onPress() {
                screen.cancel();
            }
        };
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        return ImmutableList.of((Object)this.confirmButton, (Object)this.cancelButton);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public void render(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTicks) {
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 100.0f);
        graphics.fillGradient(0, 0, Minecraft.getInstance().getWindow().getWidth(), Minecraft.getInstance().getWindow().getHeight(), -1072689136, -804253680);
        String key = "";
        if (!(ServerConfig.saveAllAbilities.booleanValue() || ServerConfig.saveGrowthStage.booleanValue() || this.isBodyTypeChange)) {
            key = CONFIRM_LOSE_ALL;
        } else if ((ServerConfig.saveAllAbilities.booleanValue() || this.isBodyTypeChange) && !ServerConfig.saveGrowthStage.booleanValue()) {
            key = CONFIRM_LOSE_GROWTH;
        } else if (!ServerConfig.saveAllAbilities.booleanValue()) {
            key = CONFIRM_LOSE_ABILITIES;
        }
        String text = Component.translatable((String)key).getString();
        if (this.confirmButton.isHovered()) {
            graphics.blit(WARNING_ACCEPT, this.x, this.y, 0, 0, this.xSize, this.ySize);
        } else if (this.cancelButton.isHovered()) {
            graphics.blit(WARNING_CANCEL, this.x, this.y, 0, 0, this.xSize, this.ySize);
        } else {
            graphics.blit(WARNING_MAIN, this.x, this.y, 0, 0, this.xSize, this.ySize);
        }
        TextRenderUtil.drawCenteredScaledTextSplit(graphics, this.x + this.xSize / 2, this.y + 42, 1.0f, text, DyeColor.WHITE.getTextColor(), this.xSize - 10, 150);
        this.confirmButton.render(graphics, pMouseX, pMouseY, pPartialTicks);
        this.cancelButton.render(graphics, pMouseX, pMouseY, pPartialTicks);
        graphics.pose().popPose();
    }
}

