/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components;

import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.ScrollableComponent;
import by.dragonsurvivalteam.dragonsurvival.registry.data_maps.DietEntryCache;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DietMenuComponent
implements ScrollableComponent,
Renderable {
    @Translation(comments={"There is no custom dragon diet"})
    private static final String NO_CUSTOM_DIET = Translation.Type.GUI.wrap("diet_menu.no_custom_diet");
    private static final int VISIBLE_MAX_ROWS = 3;
    private static final int ITEMS_PER_ROW = 7;
    private static final int ITEM_SIZE = 18;
    private final Holder<DragonSpecies> dragonSpecies;
    @Nullable
    private ItemStack hovered;
    private final int x;
    private final int y;
    private final int maxX;
    private final int maxY;
    private int scrollAmount;

    public DietMenuComponent(Holder<DragonSpecies> dragonSpecies, int x, int y) {
        this.dragonSpecies = dragonSpecies;
        this.x = x;
        this.y = y;
        this.maxX = x + 126;
        this.maxY = y + 54;
    }

    @Nullable
    public ItemStack getHovered() {
        return this.hovered;
    }

    @Override
    public void scroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isHovered(mouseX, mouseY)) {
            this.scrollAmount = Math.clamp((long)(this.scrollAmount + (int)(-scrollY)), 0, this.maxScroll());
        }
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        List<Item> items = DietEntryCache.getDietItems(this.dragonSpecies);
        if (items.isEmpty()) {
            MutableComponent component = Component.translatable((String)NO_CUSTOM_DIET);
            List formatted = Minecraft.getInstance().font.split((FormattedText)component, this.maxX - this.x);
            int startX = this.x + 63;
            Objects.requireNonNull(Minecraft.getInstance().font);
            int startY = this.y + 27 - 9 / 2;
            for (int row = 0; row < formatted.size(); ++row) {
                FormattedCharSequence text = (FormattedCharSequence)formatted.get(row);
                int xPosition = startX - Minecraft.getInstance().font.width(text) / 2;
                Objects.requireNonNull(Minecraft.getInstance().font);
                int yPosition = startY + row * (9 + 2);
                graphics.drawString(Minecraft.getInstance().font, text, xPosition, yPosition, 0xFFFFFF, false);
            }
            return;
        }
        int processedRows = 0;
        int processedItems = 0;
        this.hovered = null;
        for (int i = this.scrollAmount * 7; i < items.size(); ++i) {
            int itemX = this.x + processedItems % 7 * 18;
            int itemY = this.y + processedRows * 18;
            ItemStack stack = items.get(i).getDefaultInstance();
            graphics.renderFakeItem(stack, itemX, itemY);
            if (mouseX >= itemX && mouseX < itemX + 18 && mouseY >= itemY && mouseY < itemY + 18) {
                graphics.renderTooltip(Minecraft.getInstance().font, stack, mouseX, mouseY);
                this.hovered = stack;
            }
            if (++processedItems == 7) {
                processedItems = 0;
                ++processedRows;
            }
            if (processedRows == 3) break;
        }
        if (this.maxScroll() > 0) {
            String text = "[" + this.scrollAmount + "/" + this.maxScroll() + "]";
            int xPosition = this.x + 63 - Minecraft.getInstance().font.width(text) / 2;
            graphics.drawString(Minecraft.getInstance().font, text, xPosition, this.maxY + 3, 0xFFFFFF, false);
        }
    }

    private boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)this.maxX && mouseY >= (double)this.y && mouseY <= (double)this.maxY;
    }

    private int maxScroll() {
        List<Item> items = DietEntryCache.getDietItems(this.dragonSpecies);
        if (items.isEmpty()) {
            return 0;
        }
        return Math.max(0, (int)Math.ceil((double)items.size() / 7.0) - 3);
    }
}

