/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic;

import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.HoverDisableable;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;

public class HoverButton
extends ExtendedButton
implements HoverDisableable {
    private final ResourceLocation main;
    private final ResourceLocation hover;
    private final Supplier<List<Either<FormattedText, TooltipComponent>>> customTooltip;
    private boolean disableHover;
    private final int originalWidth;
    private final int originalHeight;
    private final int textureWidth;
    private final int textureHeight;
    private final int uOffset;
    private final int vOffset;
    private Vec2 scale = new Vec2(1.0f, 1.0f);
    private Vec2 offset = new Vec2(0.0f, 0.0f);

    public HoverButton(int x, int y, int size, ResourceLocation main, ResourceLocation hover) {
        this(x, y, size, size, size, size, 0, 0, main, hover, button -> {}, null);
    }

    public HoverButton(int x, int y, int size, ResourceLocation main, ResourceLocation hover, Supplier<List<Either<FormattedText, TooltipComponent>>> customTooltip) {
        this(x, y, size, size, size, size, 0, 0, main, hover, button -> {}, customTooltip);
    }

    public HoverButton(int x, int y, int width, int height, int textureWidth, int textureHeight, ResourceLocation main, ResourceLocation hover, Button.OnPress onPress) {
        this(x, y, width, height, textureWidth, textureHeight, 0, 0, main, hover, onPress, null);
    }

    public HoverButton(int x, int y, int width, int height, int textureWidth, int textureHeight, int uOffset, int vOffset, ResourceLocation main, ResourceLocation hover, Button.OnPress onPress, Supplier<List<Either<FormattedText, TooltipComponent>>> customTooltip) {
        super(x, y, width, height, (Component)Component.empty(), onPress);
        this.main = main;
        this.hover = hover;
        this.customTooltip = customTooltip;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.uOffset = uOffset;
        this.vOffset = vOffset;
        this.originalWidth = width;
        this.originalHeight = height;
    }

    @Override
    public void disableHover() {
        this.disableHover = true;
    }

    @Override
    public void enableHover() {
        this.disableHover = false;
    }

    public void setScale(float scaleX, float scaleY) {
        this.scale = new Vec2(scaleX, scaleY);
    }

    public void setOffset(float offsetX, float offsetY) {
        this.offset = new Vec2(offsetX, offsetY);
    }

    public boolean isHovered() {
        return !this.disableHover && super.isHovered();
    }

    public boolean isFocused() {
        return !this.disableHover && super.isFocused();
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        float scaleX = this.scale.x == 1.0f ? (float)this.width / (float)this.originalWidth : this.scale.x;
        float scaleY = this.scale.y == 1.0f ? (float)this.height / (float)this.originalHeight : this.scale.y;
        graphics.pose().scale(scaleX, scaleY, 1.0f);
        graphics.pose().translate((float)(-this.getX()), (float)(-this.getY()), 0.0f);
        float scaleXDiff = (this.scale.x - 1.0f) * (float)this.originalWidth / 2.0f;
        float scaleYDiff = (this.scale.y - 1.0f) * (float)this.originalHeight / 2.0f;
        graphics.pose().translate(this.offset.x - scaleXDiff, this.offset.y - scaleYDiff, 0.0f);
        ResourceLocation texture = this.isHovered() ? this.hover : this.main;
        graphics.blit(texture, this.getX(), this.getY(), (float)this.uOffset, (float)this.vOffset, this.originalWidth, this.originalHeight, this.textureWidth, this.textureHeight);
        graphics.pose().popPose();
        this.renderString(graphics, Minecraft.getInstance().font, this.getFGColor() | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    public void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.customTooltip == null || !this.isHovered()) {
            return;
        }
        graphics.renderComponentTooltipFromElements(Minecraft.getInstance().font, this.customTooltip.get(), mouseX, mouseY, ItemStack.EMPTY);
    }
}

