/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons;

import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.DragonAbilityScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.LevelButton;
import by.dragonsurvivalteam.dragonsurvival.magic.AbilityAndPenaltyTooltipRenderer;
import by.dragonsurvivalteam.dragonsurvival.mixins.client.ScreenAccessor;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncDisableAbility;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncSlotAssignment;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade.UpgradeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbilityButton
extends ExtendedButton {
    public static final ResourceLocation ACTIVE_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"ability_screen/skill_main");
    public static final ResourceLocation PASSIVE_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"ability_screen/skill_main");
    public static final ResourceLocation DISABLED_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"ability_screen/skill_disabled");
    public static final ResourceLocation AUTO_UPGRADE_ORNAMENTATION = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"ability_screen/skill_autoupgrade");
    private static final int SIZE = 34;
    private static final int ORNAMENTATION_SIZE = 38;
    private final DragonAbilityScreen screen;
    @Nullable
    private DragonAbilityInstance ability;
    @Nullable
    private LevelButton leftLevelButton;
    @Nullable
    private LevelButton rightLevelButton;
    private Vec3 offset = Vec3.ZERO;
    private float scale;
    private int slot = -1;
    private int scrollAmount;
    private boolean isHotbar;
    private boolean isDragging;
    private boolean isInteractable = true;

    public AbilityButton(int x, int y, @Nullable DragonAbilityInstance ability, DragonAbilityScreen screen, float scale) {
        super(x, y, 34, 34, (Component)Component.empty(), button -> {}, DEFAULT_NARRATION);
        this.screen = screen;
        this.ability = ability;
        this.isHotbar = false;
        this.scale = scale;
        if (ability == null || UpgradeType.IS_MANUAL.negate().test(ability.value().upgrade())) {
            return;
        }
        this.leftLevelButton = new LevelButton(LevelButton.Type.DOWNGRADE, ability, x - this.width / 2 + 7, y + 10);
        this.rightLevelButton = new LevelButton(LevelButton.Type.UPGRADE, ability, x + this.width / 2 + 18, y + 10);
        ((ScreenAccessor)((Object)screen)).dragonSurvival$addRenderableWidget(this.leftLevelButton);
        ((ScreenAccessor)((Object)screen)).dragonSurvival$addRenderableWidget(this.rightLevelButton);
    }

    public AbilityButton(int x, int y, @Nullable DragonAbilityInstance ability, DragonAbilityScreen screen, boolean isHotbar, int slot) {
        this(x, y, ability, screen);
        this.isHotbar = isHotbar;
        this.slot = slot;
        MagicData data = MagicData.getData((Player)Minecraft.getInstance().player);
        this.ability = data.fromSlot(slot);
    }

    public AbilityButton(int x, int y, @Nullable DragonAbilityInstance ability, DragonAbilityScreen screen) {
        this(x, y, ability, screen, 1.0f);
    }

    public void setOffset(Vec3 offset) {
        this.offset = offset;
    }

    public Vec3 getOffset() {
        return this.offset;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.isInteractable && super.isMouseOver(mouseX, mouseY);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (this.leftLevelButton != null && this.rightLevelButton != null) {
            this.leftLevelButton.visible = visible;
            this.rightLevelButton.visible = visible;
        }
    }

    public void setInteractable(boolean interactable) {
        this.isInteractable = interactable;
        if (this.isInteractable) {
            this.width = 34;
            this.height = 34;
            if (this.leftLevelButton != null && this.rightLevelButton != null) {
                this.leftLevelButton.resetDimensions();
                this.rightLevelButton.resetDimensions();
            }
        } else {
            this.width = 0;
            this.height = 0;
            if (this.leftLevelButton != null && this.rightLevelButton != null) {
                this.leftLevelButton.setWidth(0);
                this.leftLevelButton.setHeight(0);
                this.rightLevelButton.setWidth(0);
                this.rightLevelButton.setHeight(0);
            }
        }
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        super.onDrag(mouseX, mouseY, dragX, dragY);
        if (this.ability == null || Screen.hasControlDown()) {
            return;
        }
        if (!this.ability.isPassive()) {
            this.isDragging = true;
        }
    }

    public void onClick(double mouseX, double mouseY) {
        if (!this.isHotbar && this.ability != null && this.ability.value().canBeManuallyDisabled() && Screen.hasControlDown()) {
            boolean isDisabled = !this.ability.isDisabled(true);
            this.ability.setDisabled((Player)Minecraft.getInstance().player, isDisabled, true);
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncDisableAbility(this.ability.key(), isDisabled, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        super.onClick(mouseX, mouseY);
    }

    public void onRelease(double mouseX, double mouseY) {
        super.onRelease(mouseX, mouseY);
        if (!this.isDragging) {
            return;
        }
        this.isDragging = false;
        if (this.ability == null) {
            return;
        }
        if (!this.ability.isPassive()) {
            MagicData data = MagicData.getData((Player)Minecraft.getInstance().player);
            boolean wasSwappedToASlot = false;
            for (Renderable renderable : this.screen.renderables) {
                if (!(renderable instanceof AbilityButton)) continue;
                AbilityButton button = (AbilityButton)renderable;
                if (button.slot == -1 || !button.isMouseOver(mouseX, mouseY)) continue;
                PacketDistributor.sendToServer((CustomPacketPayload)new SyncSlotAssignment(this.ability.key(), button.slot), (CustomPacketPayload[])new CustomPacketPayload[0]);
                data.moveAbilityToSlot(this.ability.key(), button.slot);
                wasSwappedToASlot = true;
                break;
            }
            if (this.isHotbar && !wasSwappedToASlot) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SyncSlotAssignment(this.ability.key(), -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                data.moveAbilityToSlot(this.ability.key(), -1);
            }
        }
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.isHotbar) {
            this.ability = MagicData.getData((Player)Minecraft.getInstance().player).fromSlot(this.slot);
        }
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        graphics.pose().scale(this.scale, this.scale, 1.0f);
        graphics.pose().translate((float)(-this.getX()), (float)(-this.getY()), 0.0f);
        float scaleXDiff = (this.scale - 1.0f) * 34.0f / 2.0f;
        float scaleYDiff = (this.scale - 1.0f) * 34.0f / 2.0f;
        graphics.pose().translate(this.offset.x - (double)scaleXDiff, this.offset.y - (double)scaleYDiff, this.offset.z);
        if (this.ability == null) {
            this.blit(graphics, PASSIVE_BACKGROUND, this.getX() - 2, this.getY() - 2, 38);
            graphics.pose().popPose();
            return;
        }
        if (!this.ability.isEnabled()) {
            this.blit(graphics, DISABLED_BACKGROUND, this.getX() - 2, this.getY() - 2, 38);
        } else if (this.ability.isPassive()) {
            this.blit(graphics, PASSIVE_BACKGROUND, this.getX() - 2, this.getY() - 2, 38);
        } else {
            this.blit(graphics, ACTIVE_BACKGROUND, this.getX() - 2, this.getY() - 2, 38);
        }
        if (this.ability.value().upgrade().isPresent() && UpgradeType.IS_MANUAL.negate().test(this.ability.value().upgrade())) {
            this.blit(graphics, AUTO_UPGRADE_ORNAMENTATION, this.getX() - 2, this.getY() - 2, 38);
        }
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 50.0f);
        if (this.isDragging) {
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 100.0f);
            this.blit(graphics, this.ability.getIcon(), mouseX - 17, mouseY - 17, 34);
            graphics.pose().popPose();
        }
        if (!this.isHotbar || !this.isDragging) {
            this.blit(graphics, this.ability.getIcon(), this.getX(), this.getY(), 34);
        }
        graphics.pose().popPose();
        if (this.isHovered() && this.shouldShowDescription()) {
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 150.0f);
            AbilityAndPenaltyTooltipRenderer.drawAbilityTooltip(graphics, mouseX, mouseY, this.ability, this.scrollAmount);
            graphics.pose().popPose();
        }
        graphics.pose().popPose();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (Screen.hasShiftDown() && this.isHovered()) {
            this.scrollAmount = Math.clamp((long)(this.scrollAmount + (int)(-scrollY)), 0, AbilityAndPenaltyTooltipRenderer.maxScroll());
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean isHovered() {
        boolean isHovered = super.isHovered();
        if (!isHovered) {
            this.scrollAmount = 0;
        }
        return isHovered;
    }

    private void blit(GuiGraphics graphics, ResourceLocation texture, int x, int y, int size) {
        graphics.blit(x, y, 0, size, size, Minecraft.getInstance().getGuiSprites().getSprite(texture), 1.0f, 1.0f, 1.0f, this.alpha);
    }

    private boolean shouldShowDescription() {
        if (this.isDragging) {
            return false;
        }
        if (this.ability != null && !this.ability.isPassive()) {
            for (Renderable renderable : this.screen.renderables) {
                if (!(renderable instanceof AbilityButton)) continue;
                AbilityButton button = (AbilityButton)renderable;
                if (!button.isDragging) continue;
                return false;
            }
        }
        return true;
    }
}

