/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.buttons.editor_part_selector;

import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.DragonEditorScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.HoverButton;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.SkinLayer;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.loader.DragonPartLoader;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonPart;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonStageCustomization;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.LayerSettings;
import by.dragonsurvivalteam.dragonsurvival.client.util.RenderingUtils;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;
import org.jetbrains.annotations.NotNull;

public class HueSelectorComponent
extends AbstractContainerEventHandler
implements Renderable {
    private static final ResourceLocation RESET_SETTINGS_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/color_reset_hover.png");
    private static final ResourceLocation RESET_SETTINGS_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/color_reset_main.png");
    private static final ResourceLocation SLIDER_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/color_slider_hover.png");
    private static final ResourceLocation SLIDER_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/color_slider_main.png");
    private static final ResourceLocation GLOW_ON = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/glow_on.png");
    private static final ResourceLocation GLOW_OFF = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/glow_off.png");
    public static final int BACKGROUND_COLOR = -14935012;
    public static final int INNER_BORDER_COLOR = new Color(0x78787880, true).getRGB();
    public boolean visible;
    private final ExtendedButton hueReset;
    private final ExtendedButton saturationReset;
    private final ExtendedButton brightnessReset;
    private final ExtendedButton glowing;
    private final ExtendedSlider hueSlider;
    private final ExtendedSlider saturationSlider;
    private final ExtendedSlider brightnessSlider;
    public final Supplier<LayerSettings> settingsSupplier;
    private final int x;
    private final int y;
    private final int xSize;
    private final int ySize;
    private static final int INITIAL_BAR_OFFSET = 5;
    private static final int GAP_BETWEEN_BARS = 25;

    private boolean hasModifiedColor(DragonPart dragonPart) {
        return !(dragonPart == null || Float.compare(Math.round(this.settingsSupplier.get().hue * 360.0f), Math.round(dragonPart.averageHue() * 360.0f)) == 0 && (double)Math.abs(this.settingsSupplier.get().saturation - 0.5f) < 0.05 && (double)Math.abs(this.settingsSupplier.get().brightness - 0.5f) < 0.05);
    }

    public HueSelectorComponent(final DragonEditorScreen screen, int x, int y, int xSize, int ySize, SkinLayer layer) {
        this.x = x;
        this.y = y;
        this.xSize = xSize;
        this.ySize = ySize;
        this.settingsSupplier = () -> (LayerSettings)((DragonStageCustomization)screen.preset.get((ResourceKey<DragonStage>)screen.stage.getKey()).get()).layerSettings.get((Object)layer).get();
        LayerSettings settings = this.settingsSupplier.get();
        final DragonPart dragonPart = DragonPartLoader.getDragonPart(layer, DragonEditorScreen.HANDLER.speciesKey(), DragonEditorScreen.HANDLER.body(), settings.partKey);
        this.glowing = new ExtendedButton(x + 4, y - 25, 27, 25, (Component)Component.empty(), button -> {
            Function<Boolean, Boolean> setGlowingAction = value -> {
                this.settingsSupplier.get().glowing = value;
                DragonEditorScreen.HANDLER.recompileCurrentSkin();
                screen.update();
                return value == false;
            };
            screen.actionHistory.add(new DragonEditorScreen.EditorAction<Boolean>(setGlowingAction, !this.settingsSupplier.get().glowing));
        }){

            public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                ResourceLocation texture = HueSelectorComponent.this.settingsSupplier.get().glowing ? GLOW_ON : GLOW_OFF;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
                guiGraphics.blit(texture, this.getX(), this.getY(), 0.0f, 0.0f, 27, 25, 27, 25);
                guiGraphics.pose().popPose();
            }
        };
        float[] hsb = new float[]{settings.hue, settings.saturation, settings.brightness};
        if (dragonPart == null) {
            hsb[0] = 0.5f;
            hsb[1] = 0.5f;
            hsb[2] = 0.5f;
        } else if (!settings.modifiedColor) {
            hsb[0] = dragonPart.averageHue();
            hsb[1] = 0.5f;
            hsb[2] = 0.5f;
        }
        this.hueSlider = new ExtendedSlider(x + 3, y + 5, xSize - 26, 20, (Component)Component.empty(), (Component)Component.empty(), 0.0, 360.0, hsb[0] * 360.0f, true){
            private int previousHue;
            private final Function<Integer, Integer> setHueAction;
            {
                super(x, y, width, height, prefix, suffix, minValue, maxValue, currentValue, drawString);
                this.previousHue = 0;
                this.setHueAction = value -> {
                    HueSelectorComponent.this.settingsSupplier.get().hue = (float)value.intValue() / 360.0f;
                    HueSelectorComponent.this.settingsSupplier.get().modifiedColor = HueSelectorComponent.this.hasModifiedColor(dragonPart);
                    DragonEditorScreen.HANDLER.recompileCurrentSkin();
                    screen.update();
                    return this.previousHue;
                };
            }

            protected void applyValue() {
                super.applyValue();
                this.setHueAction.apply(this.getValueInt());
            }

            public void setValue(double value) {
                super.setValue(value);
                this.applyValue();
            }

            public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
                if (this.visible) {
                    this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.getWidth() && mouseY < this.getY() + this.getHeight();
                    RenderingUtils.renderPureColorSquare(guiGraphics.pose(), this.getX() + 1, this.getY() + 1, this.getWidth() - 1, this.getHeight() - 1);
                    guiGraphics.renderOutline(this.getX() + 1, this.getY() + 1, this.getWidth() - 1, this.getHeight() - 1, Color.black.getRGB());
                    if (this.isHovered) {
                        guiGraphics.blit(SLIDER_HOVER, this.getX() + (int)(this.value * (double)(this.width - 8)), this.getY() - 3, 0.0f, 0.0f, 12, 26, 26, 26);
                    } else {
                        guiGraphics.blit(SLIDER_MAIN, this.getX() + (int)(this.value * (double)(this.width - 8)), this.getY() - 3, 0.0f, 0.0f, 12, 26, 26, 26);
                    }
                }
            }

            public void onClick(double mouseX, double mouseY) {
                super.onClick(mouseX, mouseY);
                this.previousHue = this.getValueInt();
            }

            public void onRelease(double mouseX, double mouseY) {
                super.onRelease(mouseX, mouseY);
                screen.actionHistory.add(new DragonEditorScreen.EditorAction<Integer>(this.setHueAction, this.getValueInt()));
            }
        };
        this.hueReset = new HoverButton(x + 3 + xSize - 26, y + 5 - 1, 24, 24, 24, 24, RESET_SETTINGS_MAIN, RESET_SETTINGS_HOVER, button -> this.hueSlider.setValue(dragonPart != null ? (double)Math.round(dragonPart.averageHue() * 360.0f) : 180.0));
        this.saturationSlider = new ExtendedSlider(x + 3, y + 5 + 25, xSize - 26, 20, (Component)Component.empty(), (Component)Component.empty(), 0.0, 360.0, hsb[1] * 360.0f, true){
            private int previousSaturation;
            private final Function<Integer, Integer> setSaturationAction;
            {
                super(x, y, width, height, prefix, suffix, minValue, maxValue, currentValue, drawString);
                this.previousSaturation = 0;
                this.setSaturationAction = value -> {
                    HueSelectorComponent.this.settingsSupplier.get().saturation = (float)value.intValue() / 360.0f;
                    HueSelectorComponent.this.settingsSupplier.get().modifiedColor = HueSelectorComponent.this.hasModifiedColor(dragonPart);
                    DragonEditorScreen.HANDLER.recompileCurrentSkin();
                    screen.update();
                    return this.previousSaturation;
                };
            }

            protected void applyValue() {
                super.applyValue();
                this.setSaturationAction.apply(this.getValueInt());
            }

            public void setValue(double value) {
                super.setValue(value);
                this.applyValue();
            }

            public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
                if (this.visible) {
                    this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.getWidth() && mouseY < this.getY() + this.getHeight();
                    float value1 = (float)HueSelectorComponent.this.hueSlider.getValueInt() / 360.0f;
                    int col1 = Color.getHSBColor(value1, 0.0f, 1.0f).getRGB();
                    int col2 = Color.getHSBColor(value1, 1.0f, 1.0f).getRGB();
                    RenderingUtils.drawGradientRect(guiGraphics.pose().last().pose(), 0, this.getX() + 1, this.getY() + 1, this.getX() + this.getWidth() - 1, this.getY() + this.getHeight() - 1, new int[]{col2, col1, col1, col2});
                    guiGraphics.renderOutline(this.getX() + 1, this.getY() + 1, this.getWidth() - 1, this.getHeight() - 1, Color.black.getRGB());
                    if (this.isHovered) {
                        guiGraphics.blit(SLIDER_HOVER, this.getX() + (int)(this.value * (double)(this.width - 8)), this.getY() - 3, 0.0f, 0.0f, 12, 26, 26, 26);
                    } else {
                        guiGraphics.blit(SLIDER_MAIN, this.getX() + (int)(this.value * (double)(this.width - 8)), this.getY() - 3, 0.0f, 0.0f, 12, 26, 26, 26);
                    }
                }
            }

            public void onRelease(double mouseX, double mouseY) {
                super.onRelease(mouseX, mouseY);
                screen.actionHistory.add(new DragonEditorScreen.EditorAction<Integer>(this.setSaturationAction, this.getValueInt()));
            }

            public void onClick(double mouseX, double mouseY) {
                super.onClick(mouseX, mouseY);
                this.previousSaturation = this.getValueInt();
            }
        };
        this.saturationReset = new HoverButton(x + 3 + xSize - 26, y + 5 + 25 - 1, 24, 24, 24, 24, RESET_SETTINGS_MAIN, RESET_SETTINGS_HOVER, button -> this.saturationSlider.setValue(180.0));
        this.brightnessSlider = new ExtendedSlider(x + 3, y + 5 + 50, xSize - 26, 20, (Component)Component.empty(), (Component)Component.empty(), 0.0, 360.0, hsb[2] * 360.0f, true){
            private int previousBrightness;
            private final Function<Integer, Integer> setBrightnessAction;
            {
                super(x, y, width, height, prefix, suffix, minValue, maxValue, currentValue, drawString);
                this.previousBrightness = 0;
                this.setBrightnessAction = value -> {
                    HueSelectorComponent.this.settingsSupplier.get().brightness = (float)value.intValue() / 360.0f;
                    HueSelectorComponent.this.settingsSupplier.get().modifiedColor = HueSelectorComponent.this.hasModifiedColor(dragonPart);
                    DragonEditorScreen.HANDLER.recompileCurrentSkin();
                    screen.update();
                    return this.previousBrightness;
                };
            }

            protected void applyValue() {
                super.applyValue();
                this.setBrightnessAction.apply(this.getValueInt());
            }

            public void setValue(double value) {
                super.setValue(value);
                this.applyValue();
            }

            public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
                if (this.visible) {
                    this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.getWidth() && mouseY < this.getY() + this.getHeight();
                    float value1 = (float)HueSelectorComponent.this.hueSlider.getValueInt() / 360.0f;
                    int col1 = Color.getHSBColor(value1, 1.0f, 0.0f).getRGB();
                    int col2 = Color.getHSBColor(value1, 1.0f, 1.0f).getRGB();
                    RenderingUtils.drawGradientRect(guiGraphics.pose().last().pose(), 0, this.getX() + 1, this.getY() + 1, this.getX() + this.getWidth() - 1, this.getY() + this.getHeight() - 1, new int[]{col2, col1, col1, col2});
                    guiGraphics.renderOutline(this.getX() + 1, this.getY() + 1, this.getWidth() - 1, this.getHeight() - 1, Color.black.getRGB());
                    if (this.isHovered) {
                        guiGraphics.blit(SLIDER_HOVER, this.getX() + (int)(this.value * (double)(this.width - 8)), this.getY() - 3, 0.0f, 0.0f, 12, 26, 26, 26);
                    } else {
                        guiGraphics.blit(SLIDER_MAIN, this.getX() + (int)(this.value * (double)(this.width - 8)), this.getY() - 3, 0.0f, 0.0f, 12, 26, 26, 26);
                    }
                }
            }

            public void onRelease(double mouseX, double mouseY) {
                super.onRelease(mouseX, mouseY);
                screen.actionHistory.add(new DragonEditorScreen.EditorAction<Integer>(this.setBrightnessAction, this.getValueInt()));
            }

            public void onClick(double mouseX, double mouseY) {
                super.onClick(mouseX, mouseY);
                this.previousBrightness = this.getValueInt();
            }
        };
        this.brightnessReset = new HoverButton(x + 3 + xSize - 26, y + 5 + 50 - 1, 24, 24, 24, 24, RESET_SETTINGS_MAIN, RESET_SETTINGS_HOVER, button -> this.brightnessSlider.setValue(180.0));
    }

    public boolean isMouseOver(double pMouseX, double pMouseY) {
        return this.visible && pMouseY >= (double)this.y - 30.0 && pMouseY <= (double)this.y + (double)this.ySize && pMouseX >= (double)this.x - 5.0 && pMouseX <= (double)this.x + (double)this.xSize;
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        return ImmutableList.of((Object)this.hueSlider, (Object)this.saturationSlider, (Object)this.brightnessSlider, (Object)this.hueReset, (Object)this.saturationReset, (Object)this.brightnessReset, (Object)this.glowing);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 150.0f);
        guiGraphics.fill(this.x + 2, this.y - 25, this.x + 32, this.y + 5, -14935012);
        guiGraphics.renderOutline(this.x + 2, this.y - 26, 30, 31, Color.black.getRGB());
        guiGraphics.renderOutline(this.x + 3, this.y - 25, 28, 29, INNER_BORDER_COLOR);
        guiGraphics.fill(this.x, this.y, this.x + this.xSize + 2, this.y + this.ySize - 10, -14935012);
        guiGraphics.renderOutline(this.x, this.y, this.xSize + 2, this.ySize - 10, Color.black.getRGB());
        guiGraphics.renderOutline(this.x + 1, this.y + 1, this.xSize, this.ySize - 12, INNER_BORDER_COLOR);
        this.glowing.render(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        this.hueReset.render(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        this.saturationReset.render(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        this.brightnessReset.render(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        this.hueSlider.render(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        this.saturationSlider.render(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        this.brightnessSlider.render(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        guiGraphics.pose().popPose();
    }
}

