/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.buttons.editor_part_selector;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.DragonEditorScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.buttons.editor_part_selector.ColorSelectorButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.HoverButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.ScrollableComponent;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.SkinLayer;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonPart;
import by.dragonsurvivalteam.dragonsurvival.mixins.client.ScreenAccessor;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class EditorPartComponent
implements ScrollableComponent {
    private static final ResourceLocation DROPDOWN_BUTTON_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/part_name_background.png");
    private static final ResourceLocation SMALL_LEFT_ARROW_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/small_left_arrow_hover.png");
    private static final ResourceLocation SMALL_LEFT_ARROW_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/small_left_arrow_main.png");
    private static final ResourceLocation SMALL_RIGHT_ARROW_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/small_right_arrow_hover.png");
    private static final ResourceLocation SMALL_RIGHT_ARROW_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/small_right_arrow_main.png");
    private final DragonEditorScreen screen;
    private final HoverButton partButton;
    private final ColorSelectorButton colorSelectorButton;
    private final Map<String, DragonPart> parts;
    private final List<String> sortedPartKeys;
    private final SkinLayer skinLayer;
    private String selectedPart;

    public EditorPartComponent(DragonEditorScreen screen, int xPos, int yPos, Map<String, DragonPart> parts, String partKey, final SkinLayer skinLayer, boolean isLeft, boolean isTop) {
        this.screen = screen;
        this.parts = parts;
        this.sortedPartKeys = parts.keySet().stream().sorted().toList();
        this.selectedPart = partKey;
        this.skinLayer = skinLayer;
        this.partButton = new HoverButton(xPos, yPos, 110, 19, 149, 22, DROPDOWN_BUTTON_BACKGROUND, DROPDOWN_BUTTON_BACKGROUND, button -> {}){

            public boolean isValidClickButton(int button) {
                return button == 1 && skinLayer != SkinLayer.BASE;
            }

            public void onClick(double mouseX, double mouseY, int button) {
                EditorPartComponent.this.setSelectedPartInternal("none");
            }
        };
        this.partButton.setMessage(this.translatePart(partKey));
        this.partButton.setTooltip(Tooltip.create((Component)Component.translatable((String)skinLayer.getTranslatedName())));
        ((ScreenAccessor)((Object)screen)).dragonSurvival$addRenderableWidget(this.partButton);
        ((ScreenAccessor)((Object)screen)).dragonSurvival$addRenderableWidget(new HoverButton(xPos - 7, yPos + 2, 10, 16, 10, 16, SMALL_LEFT_ARROW_MAIN, SMALL_LEFT_ARROW_HOVER, button -> this.previousPart()));
        ((ScreenAccessor)((Object)screen)).dragonSurvival$addRenderableWidget(new HoverButton(xPos + 108, yPos + 2, 10, 16, 10, 16, SMALL_RIGHT_ARROW_MAIN, SMALL_RIGHT_ARROW_HOVER, button -> this.nextPart()));
        this.colorSelectorButton = new ColorSelectorButton(screen, skinLayer, isLeft ? xPos - 23 : xPos + 120, yPos + 3, 15, 15, isLeft, isTop);
        ((ScreenAccessor)((Object)screen)).dragonSurvival$addRenderableWidget(this.colorSelectorButton);
    }

    public boolean colorSelectorIsToggled() {
        return this.colorSelectorButton.toggled;
    }

    public ColorSelectorButton getColorSelectorButton() {
        return this.colorSelectorButton;
    }

    @Override
    public void scroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.partButton.isMouseOver(mouseX, mouseY)) {
            return;
        }
        if (scrollY < 0.0) {
            this.nextPart();
        } else if (scrollY > 0.0) {
            this.previousPart();
        }
    }

    private void nextPart() {
        if (this.sortedPartKeys.isEmpty()) {
            return;
        }
        int currentPart = this.sortedPartKeys.indexOf(this.selectedPart);
        if (currentPart == -1) {
            DragonSurvival.LOGGER.error("Part {} not found in sorted part keys. Did you forget to add the default parts to this species' part map?", (Object)this.selectedPart);
        }
        if (currentPart < 0) {
            this.setSelectedPartInternal(this.sortedPartKeys.getLast());
        } else if (currentPart - 1 < 0) {
            this.setSelectedPartInternal(this.sortedPartKeys.getLast());
        } else {
            this.setSelectedPartInternal(this.sortedPartKeys.get(currentPart - 1));
        }
    }

    private void previousPart() {
        if (this.sortedPartKeys.isEmpty()) {
            return;
        }
        int currentPart = this.sortedPartKeys.indexOf(this.selectedPart);
        if (currentPart == -1) {
            DragonSurvival.LOGGER.error("Part {} not found in sorted part keys. Did you forget to add the default parts to this species' part map?", (Object)this.selectedPart);
        }
        if (currentPart < 0) {
            this.setSelectedPartInternal(this.sortedPartKeys.getFirst());
        } else if (currentPart + 1 >= this.sortedPartKeys.size()) {
            this.setSelectedPartInternal(this.sortedPartKeys.getFirst());
        } else {
            this.setSelectedPartInternal(this.sortedPartKeys.get(currentPart + 1));
        }
    }

    public void setSelectedPart(String partKey) {
        this.selectedPart = partKey;
        this.partButton.setMessage(this.translatePart(partKey));
    }

    private Component translatePart(String partKey) {
        MutableComponent translation = Component.translatable((String)Translation.Type.SKIN_PART.wrap(DragonEditorScreen.HANDLER.speciesId().getPath() + "." + partKey.toLowerCase(Locale.ENGLISH)));
        DragonPart part = this.parts.get(partKey);
        if (part != null) {
            return part.localization().orElse((Component)translation);
        }
        return translation;
    }

    private void setSelectedPartInternal(String partKey) {
        if (this.selectedPart.equals(partKey)) {
            return;
        }
        this.screen.actionHistory.add(new DragonEditorScreen.EditorAction<Pair>(this.screen.dragonPartSelectAction, new Pair((Object)this.skinLayer, (Object)partKey)));
    }
}

