/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.buttons;

import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.DragonEditorScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.BackgroundColorSelectorComponent;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonStageCustomization;
import by.dragonsurvivalteam.dragonsurvival.mixins.client.ScreenAccessor;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;

public class BackgroundColorButton
extends ExtendedButton {
    @Translation(comments={"Change the background color"})
    private static final String BACKGROUND_COLOR = Translation.Type.GUI.wrap("dragon_editor.background_color");
    private static final ResourceLocation BACKGROUND_COLOR_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/gui_color_main.png");
    private static final ResourceLocation BACKGROUND_COLOR_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/gui_color_hover.png");
    private final DragonEditorScreen screen;
    private BackgroundColorSelectorComponent colorComponent;
    private Renderable renderButton;
    public boolean toggled;

    public BackgroundColorButton(int xPos, int yPos, int width, int height, Component displayString, Button.OnPress handler, DragonEditorScreen dragonEditorScreen) {
        super(xPos, yPos, width, height, displayString, handler);
        this.screen = dragonEditorScreen;
        this.setTooltip(Tooltip.create((Component)Component.translatable((String)BACKGROUND_COLOR)));
    }

    @NotNull
    public List<? extends GuiEventListener> childrenAndSelf() {
        return ImmutableList.of((Object)((Object)this.colorComponent), (Object)((Object)this), (Object)this.colorComponent.children().getFirst(), (Object)this.colorComponent.children().getLast());
    }

    public void onPress() {
        if (!this.toggled) {
            this.renderButton = new ExtendedButton(0, 0, 0, 0, (Component)Component.empty(), button -> {}){

                public void renderWidget(@NotNull GuiGraphics guiGraphics, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
                    this.visible = false;
                    this.active = false;
                    if (BackgroundColorButton.this.colorComponent != null) {
                        BackgroundColorButton.this.colorComponent.visible = BackgroundColorButton.this.visible;
                        if (BackgroundColorButton.this.colorComponent.visible) {
                            BackgroundColorButton.this.colorComponent.render(guiGraphics, p_230430_2_, p_230430_3_, p_230430_4_);
                        }
                    }
                }
            };
            this.colorComponent = new BackgroundColorSelectorComponent(this.screen, this.getX() - 60, this.getY() - this.height - 50, 80, 70);
            this.screen.renderables.add(this.renderButton);
            this.colorComponent.children().forEach(listener -> ((ScreenAccessor)((Object)this.screen)).dragonSurvival$children().add((GuiEventListener)listener));
        } else {
            this.colorComponent.children().forEach(component -> this.screen.children().removeIf(other -> component == other));
            this.screen.children().removeIf(listener -> listener == this.colorComponent);
            this.screen.renderables.removeIf(renderable -> renderable == this.renderButton);
        }
        this.toggled = !this.toggled;
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        boolean bl = this.active = !((DragonStageCustomization)this.screen.preset.get((ResourceKey<DragonStage>)this.screen.stage.getKey()).get()).defaultSkin;
        if (!(!this.toggled || this.visible && (this.isMouseOver(mouseX, mouseY) || this.colorComponent != null && this.colorComponent.isMouseOver(mouseX, mouseY)))) {
            this.toggled = false;
            this.colorComponent.children().forEach(component -> this.screen.children().removeIf(other -> component == other));
            this.screen.children().removeIf(s -> s == this.colorComponent);
            this.screen.renderables.removeIf(s -> s == this.renderButton);
        }
        if (this.visible) {
            if (this.isHovered()) {
                guiGraphics.blit(BACKGROUND_COLOR_HOVER, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            } else {
                guiGraphics.blit(BACKGROUND_COLOR_MAIN, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        }
    }
}

