/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.ConfirmableScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.DragonAltarScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.buttons.BackgroundColorButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.buttons.DragonBodyButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.buttons.DragonEditorSlotButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.buttons.editor_part_selector.EditorPartComponent;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.buttons.editor_part_selector.HueSelectorComponent;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.HoverButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.HoverDisableable;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.BarComponent;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.DragonEditorConfirmComponent;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.DragonUIRenderComponent;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.ScrollableComponent;
import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.CustomizationFileHandler;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.SkinLayer;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.loader.DragonPartLoader;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonPart;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonStageCustomization;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.LayerSettings;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.SkinPreset;
import by.dragonsurvivalteam.dragonsurvival.client.util.FakeClientPlayerUtils;
import by.dragonsurvivalteam.dragonsurvival.client.util.TextRenderUtil;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.UnlockableBehavior;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.mixins.client.ScreenAccessor;
import by.dragonsurvivalteam.dragonsurvival.network.dragon_editor.SyncPlayerSkinPreset;
import by.dragonsurvivalteam.dragonsurvival.network.status.SyncAltarCooldown;
import by.dragonsurvivalteam.dragonsurvival.network.syncing.SyncComplete;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.AltarData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.ClawInventoryData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.FlightData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import by.dragonsurvivalteam.dragonsurvival.util.ResourceHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(value={Dist.CLIENT})
public class DragonEditorScreen
extends Screen
implements ConfirmableScreen {
    @Translation(comments={"Randomize"})
    private static final String RANDOMIZE = Translation.Type.GUI.wrap("dragon_editor.randomize");
    @Translation(comments={"Undo changes"})
    private static final String UNDO = Translation.Type.GUI.wrap("dragon_editor.undo");
    @Translation(comments={"Redo changes"})
    private static final String REDO = Translation.Type.GUI.wrap("dragon_editor.redo");
    @Translation(comments={"\u25a0 You can select any \u00a76slot\u00a7r here and click the \u00a76load/save button\u00a7r to save your current settings to that slot or load the settings from that slot.", "\u25a0 Your exports are stored here: %s"})
    private static final String SAVING_INFO = Translation.Type.GUI.wrap("dragon_editor.save_slot_info");
    @Translation(comments={"Save to current slot"})
    private static final String SAVE = Translation.Type.GUI.wrap("dragon_editor.save");
    @Translation(comments={"Load from current slot"})
    private static final String LOAD = Translation.Type.GUI.wrap("dragon_editor.load");
    @Translation(comments={"\u25a0 Click here to \u00a76copy\u00a7r your current settings to the other growth stages."})
    private static final String COPY = Translation.Type.GUI.wrap("dragon_editor.copy");
    @Translation(comments={"Show/Hide UI"})
    private static final String SHOW_UI = Translation.Type.GUI.wrap("dragon_editor.show_ui");
    @Translation(comments={"Reset to default"})
    private static final String RESET = Translation.Type.GUI.wrap("dragon_editor.reset");
    @Translation(comments={"\u25a0 The texture from this editor is only visible if your \u00a76custom\u00a7r skins are turned off in Skin Tab (dragon inventory). You can learn how to create your own custom skins or commission it on the \u00a76Github Wiki\u00a7r or Dragon Survival discord.", "\u00a7r-\u00a77 Dragon Survival works with shaders, but they can affect the appearance of glowing textures.\u00a7r"})
    private static final String CUSTOMIZATION = Translation.Type.GUI.wrap("dragon_editor.customization");
    @Translation(comments={"Save data invalid for this dragon species"})
    private static final String INVALID_FOR_TYPE = Translation.Type.GUI.wrap("dragon_editor.invalid_for_type");
    @Translation(comments={"Save data invalid for this model"})
    private static final String INVALID_FOR_MODEL = Translation.Type.GUI.wrap("dragon_editor.invalid_for_model");
    @Translation(comments={"No save data for this slot"})
    private static final String NO_DATA = Translation.Type.GUI.wrap("dragon_editor.no_data");
    @Translation(comments={"Slot saved"})
    private static final String SLOT_SAVED = Translation.Type.GUI.wrap("dragon_editor.slot_saved");
    public static final DragonStateHandler HANDLER = new DragonStateHandler();
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/block/black_concrete.png");
    private static final ResourceLocation COPY_ALL_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/copy_off.png");
    private static final ResourceLocation COPY_ALL_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/copy_on.png");
    private static final ResourceLocation INFO_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/info_main.png");
    private static final ResourceLocation INFO_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/info_hover.png");
    private static final ResourceLocation ALTERNATIVE_ON = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/alternative_on.png");
    private static final ResourceLocation ALTERNATIVE_OFF = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/alternative_off.png");
    private static final ResourceLocation CONFIRM_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/accept_background_hover.png");
    private static final ResourceLocation CONFIRM_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/accept_background_main.png");
    private static final ResourceLocation CANCEL_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/cancel_background_hover.png");
    private static final ResourceLocation CANCEL_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/cancel_background_main.png");
    private static final ResourceLocation SHOW_UI_ON = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/gui_on.png");
    private static final ResourceLocation SHOW_UI_OFF = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/gui_off.png");
    private static final ResourceLocation RESET_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/reset_main.png");
    private static final ResourceLocation RESET_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/reset_hover.png");
    private static final ResourceLocation ANIMATION_NAME_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/animation_name_background.png");
    private static final ResourceLocation SMALL_LEFT_ARROW_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/small_left_arrow_hover.png");
    private static final ResourceLocation SMALL_LEFT_ARROW_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/small_left_arrow_main.png");
    private static final ResourceLocation SMALL_RIGHT_ARROW_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/small_right_arrow_hover.png");
    private static final ResourceLocation SMALL_RIGHT_ARROW_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/small_right_arrow_main.png");
    private static final ResourceLocation LEFT_ARROW_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/left_arrow_hover.png");
    private static final ResourceLocation LEFT_ARROW_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/left_arrow_main.png");
    private static final ResourceLocation RIGHT_ARROW_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/right_arrow_hover.png");
    private static final ResourceLocation RIGHT_ARROW_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/right_arrow_main.png");
    private static final ResourceLocation REDO_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/redo_main.png");
    private static final ResourceLocation REDO_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/redo_hover.png");
    private static final ResourceLocation UNDO_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/undo_main.png");
    private static final ResourceLocation UNDO_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/undo_hover.png");
    private static final ResourceLocation RANDOM_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/random_hover.png");
    private static final ResourceLocation RANDOM_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/random_main.png");
    private static final ResourceLocation SAVE_SLOT_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/slot_background.png");
    private static final ResourceLocation SLOT_LOAD_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/slot_load_hover.png");
    private static final ResourceLocation SLOT_LOAD_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/slot_load_main.png");
    private static final ResourceLocation SLOT_SAVE_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/slot_save_hover.png");
    private static final ResourceLocation SLOT_SAVE_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/slot_save_main.png");
    private static final ResourceLocation SLOT_INFO_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/slot_info_hover.png");
    private static final ResourceLocation SLOT_INFO_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/slot_info_main.png");
    public int guiTop;
    public boolean confirmation;
    public boolean showUi = true;
    public Holder<DragonSpecies> species;
    public Holder<DragonBody> body;
    public Holder<DragonStage> stage;
    public SkinPreset preset;
    public int selectedSaveSlot = 1;
    public int backgroundColor = -804253680;
    private int guiLeft;
    private final String[] animations = new String[]{"sit_dentist", "sit", "idle", "fly", "swim", "run", "spinning_on_back"};
    private DragonUIRenderComponent dragonRender;
    private ExtendedButton uiButton;
    private DragonEditorConfirmComponent confirmComponent;
    private ExtendedButton wingsButton;
    private HoverButton animationNameButton;
    private BackgroundColorButton backgroundColorButton;
    private BarComponent dragonBodyBar;
    private final List<ScrollableComponent> scrollableComponents = new ArrayList<ScrollableComponent>();
    private final Map<SkinLayer, EditorPartComponent> partComponents = new HashMap<SkinLayer, EditorPartComponent>();
    private float tick;
    private int curAnimation;
    private int selectedDragonStage;
    private boolean hasInit;
    private final boolean fromAltar;
    private final List<UnlockableBehavior.BodyEntry> unlockedBodies;
    private float tickWhenSlotDisplayMessageSet = -1.0f;
    private SlotDisplayMessage slotDisplayMessage = SlotDisplayMessage.NONE;
    public final Function<Holder<DragonStage>, Holder<DragonStage>> selectStageAction = newStage -> {
        Holder<DragonStage> previousLevel = this.stage;
        this.stage = newStage;
        this.dragonRender.zoom = DragonEditorScreen.setZoom(this.stage);
        HANDLER.setStage(null, this.stage);
        HANDLER.recompileCurrentSkin();
        this.update();
        return previousLevel;
    };
    public final Function<CompoundTag, CompoundTag> setSkinPresetAction = tag -> {
        CompoundTag prevTag = HANDLER.getCurrentSkinPreset().serializeNBT((HolderLookup.Provider)Objects.requireNonNull(Minecraft.getInstance().player).registryAccess());
        HANDLER.getCurrentSkinPreset().deserializeNBT((HolderLookup.Provider)Minecraft.getInstance().player.registryAccess(), (CompoundTag)tag);
        HANDLER.recompileCurrentSkin();
        this.update();
        return prevTag;
    };
    public final Function<Holder<DragonBody>, Holder<DragonBody>> dragonBodySelectAction = dragonBody -> {
        Holder<DragonBody> previousBody = this.body;
        this.body = dragonBody;
        this.update();
        return previousBody;
    };
    public final Function<Pair<SkinLayer, String>, Pair<SkinLayer, String>> dragonPartSelectAction = pair -> {
        Pair previousPair = new Pair((Object)((SkinLayer)((Object)((Object)pair.getFirst()))), (Object)((LayerSettings)((DragonStageCustomization)this.preset.get((ResourceKey<DragonStage>)Objects.requireNonNull(this.stage.getKey())).get()).layerSettings.get((Object)pair.getFirst()).get()).partKey);
        SkinLayer layer = (SkinLayer)((Object)((Object)pair.getFirst()));
        String value = (String)pair.getSecond();
        this.partComponents.get((Object)layer).setSelectedPart(value);
        ((LayerSettings)((DragonStageCustomization)this.preset.get((ResourceKey<DragonStage>)this.stage.getKey()).get()).layerSettings.get((Object)((Object)((Object)layer))).get()).partKey = value;
        LayerSettings settings = (LayerSettings)((DragonStageCustomization)this.preset.get((ResourceKey<DragonStage>)this.stage.getKey()).get()).layerSettings.get((Object)layer).get();
        DragonPart part = DragonPartLoader.getDragonPart(layer, (ResourceKey<DragonSpecies>)this.species.getKey(), this.body, settings.partKey);
        if (part != null && !settings.modifiedColor) {
            settings.hue = part.averageHue();
        }
        HANDLER.recompileCurrentSkin();
        this.update();
        return previousPair;
    };
    public final Function<Boolean, Boolean> checkWingsButtonAction = selected -> {
        boolean prevSelected = ((DragonStageCustomization)this.preset.get((ResourceKey<DragonStage>)Objects.requireNonNull(this.stage.getKey())).get()).wings;
        ((DragonStageCustomization)this.preset.get((ResourceKey<DragonStage>)Objects.requireNonNull(this.stage.getKey())).get()).wings = selected;
        HANDLER.recompileCurrentSkin();
        this.update();
        return prevSelected;
    };
    public final Function<DragonStageCustomization, DragonStageCustomization> loadStageCustomizationAction = newStageCustomization -> {
        DragonStageCustomization previousStageCustomization = HANDLER.getCurrentStageCustomization();
        HANDLER.setCurrentStageCustomization((DragonStageCustomization)newStageCustomization);
        HANDLER.recompileCurrentSkin();
        this.update();
        return previousStageCustomization;
    };
    public final UndoRedoList actionHistory = new UndoRedoList(200);

    private Component loadSlotDisplayMessage(SlotDisplayMessage reason) {
        return switch (reason.ordinal()) {
            case 0 -> Component.translatable((String)INVALID_FOR_TYPE);
            case 1 -> Component.translatable((String)INVALID_FOR_MODEL);
            case 2 -> Component.translatable((String)NO_DATA);
            case 3 -> Component.translatable((String)SLOT_SAVED);
            default -> Component.empty();
        };
    }

    public DragonEditorScreen(Holder<DragonSpecies> species, List<UnlockableBehavior.BodyEntry> unlockedBodies, boolean fromAltar) {
        super((Component)Component.translatable((String)LangKey.GUI_DRAGON_EDITOR));
        this.fromAltar = fromAltar;
        this.species = species;
        this.unlockedBodies = unlockedBodies;
    }

    public static float setZoom(Holder<DragonStage> dragonStage) {
        return (float)(0.4 * ((DragonStage)dragonStage.value()).growthRange().min() + 20.0);
    }

    private void refreshPartComponents() {
        HashMap<SkinLayer, Lazy<LayerSettings>> layerSettingsMap = DragonEditorScreen.HANDLER.getCurrentStageCustomization().layerSettings;
        for (SkinLayer layer : layerSettingsMap.keySet()) {
            if (!this.partComponents.containsKey((Object)layer)) continue;
            this.partComponents.get((Object)layer).setSelectedPart(((LayerSettings)layerSettingsMap.get((Object)((Object)layer)).get()).partKey);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        for (ScrollableComponent component : this.scrollableComponents) {
            component.scroll(mouseX, mouseY, scrollX, scrollY);
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    private boolean onlyCheckForColorSelectorComponentButtons() {
        boolean onlyCheckForColorSelectorComponentButtons = false;
        for (EditorPartComponent partComponent : this.partComponents.values()) {
            if (!partComponent.colorSelectorIsToggled()) continue;
            onlyCheckForColorSelectorComponentButtons = true;
            break;
        }
        return onlyCheckForColorSelectorComponentButtons;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.onlyCheckForColorSelectorComponentButtons()) {
            for (EditorPartComponent editorPartComponent : this.partComponents.values()) {
                HueSelectorComponent hueComponent = editorPartComponent.getColorSelectorButton().getHueComponent();
                if (hueComponent == null || !editorPartComponent.getColorSelectorButton().toggled) continue;
                ArrayList<? extends GuiEventListener> hueComponentChildrenAndColorButton = new ArrayList<GuiEventListener>(hueComponent.children());
                hueComponentChildrenAndColorButton.add((GuiEventListener)editorPartComponent.getColorSelectorButton());
                for (GuiEventListener guiEventListener : hueComponentChildrenAndColorButton) {
                    if (!guiEventListener.mouseClicked(mouseX, mouseY, button)) continue;
                    this.setFocused(guiEventListener);
                    if (button == 0) {
                        this.setDragging(true);
                    }
                    return true;
                }
            }
            return false;
        }
        if (this.confirmComponent != null && this.confirmation) {
            for (GuiEventListener guiEventListener : this.confirmComponent.children()) {
                if (!guiEventListener.mouseClicked(mouseX, mouseY, button)) continue;
                this.setFocused(guiEventListener);
                if (button == 0) {
                    this.setDragging(true);
                }
                return true;
            }
            return false;
        }
        if (this.backgroundColorButton != null && this.backgroundColorButton.toggled) {
            for (GuiEventListener guiEventListener : this.backgroundColorButton.childrenAndSelf()) {
                if (!guiEventListener.mouseClicked(mouseX, mouseY, button)) continue;
                this.setFocused(guiEventListener);
                if (button == 0) {
                    this.setDragging(true);
                }
                return true;
            }
            return false;
        }
        for (GuiEventListener guiEventListener : this.children()) {
            HoverDisableable hoverDisableable;
            if (!guiEventListener.mouseClicked(mouseX, mouseY, button)) continue;
            this.setFocused(guiEventListener);
            if (button == 0) {
                this.setDragging(true);
            }
            if (this.onlyCheckForColorSelectorComponentButtons()) {
                for (GuiEventListener guieventlistener2 : this.children()) {
                    if (!(guieventlistener2 instanceof HoverDisableable)) continue;
                    hoverDisableable = (HoverDisableable)guieventlistener2;
                    if (guiEventListener == guieventlistener2) continue;
                    hoverDisableable.disableHover();
                }
            }
            if (this.confirmComponent != null && this.confirmation) {
                for (GuiEventListener guieventlistener2 : this.children()) {
                    if (!(guieventlistener2 instanceof HoverDisableable)) continue;
                    hoverDisableable = (HoverDisableable)guieventlistener2;
                    hoverDisableable.disableHover();
                }
            }
            if (this.backgroundColorButton != null && this.backgroundColorButton.toggled) {
                for (GuiEventListener guieventlistener2 : this.children()) {
                    if (!(guieventlistener2 instanceof HoverDisableable)) continue;
                    hoverDisableable = (HoverDisableable)guieventlistener2;
                    if (this.backgroundColorButton.childrenAndSelf().contains(guieventlistener2)) continue;
                    hoverDisableable.disableHover();
                }
            }
            return true;
        }
        return false;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.dragonRender == null) {
            this.init();
        }
        this.tick += partialTick;
        if (this.tick >= 1200.0f) {
            this.tick = 0.0f;
        }
        if (this.showUi) {
            this.dragonRender.x = this.width / 2 - 70;
            this.dragonRender.y = this.guiTop;
            this.dragonRender.width = 140;
            this.dragonRender.height = 125;
        } else {
            this.dragonRender.x = 0;
            this.dragonRender.width = this.width;
        }
        FakeClientPlayerUtils.getFakePlayer((int)0, (DragonStateHandler)DragonEditorScreen.HANDLER).animationSupplier = () -> this.animations[this.curAnimation];
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        this.children().stream().filter(DragonUIRenderComponent.class::isInstance).toList().forEach(s -> ((DragonUIRenderComponent)((Object)s)).render(graphics, mouseX, mouseY, partialTick));
        DragonAltarScreen.renderBorders(graphics, BACKGROUND_TEXTURE, 0, this.width, 32, this.height - 32, this.width, this.height);
        TextRenderUtil.drawCenteredScaledText(graphics, this.width / 2, 10, 2.0f, DragonStage.translatableName((ResourceKey<DragonStage>)Objects.requireNonNull(this.stage.getKey())).getString().toUpperCase(), DyeColor.WHITE.getTextColor());
        if (this.slotDisplayMessage != SlotDisplayMessage.NONE) {
            int color = this.slotDisplayMessage == SlotDisplayMessage.SLOT_SAVED ? DyeColor.GREEN.getTextColor() : DyeColor.RED.getTextColor();
            if (this.tickWhenSlotDisplayMessageSet + 200.0f - this.tick > 0.0f) {
                TextRenderUtil.drawCenteredScaledText(graphics, this.width / 2, this.height / 2 + 20, 0.5f, this.loadSlotDisplayMessage(this.slotDisplayMessage).getString(), color);
            } else {
                this.slotDisplayMessage = SlotDisplayMessage.NONE;
            }
        }
        for (Renderable renderable : new CopyOnWriteArrayList(this.renderables)) {
            AbstractWidget widget;
            if (!(this.onlyCheckForColorSelectorComponentButtons() || this.confirmation || this.backgroundColorButton != null && this.backgroundColorButton.toggled || !(renderable instanceof HoverDisableable))) {
                HoverDisableable hoverDisableable = (HoverDisableable)renderable;
                hoverDisableable.enableHover();
            }
            if (renderable instanceof AbstractWidget && (widget = (AbstractWidget)renderable) != this.uiButton) {
                if (widget == this.wingsButton) {
                    if (this.body != null && ((DragonBody)this.body.value()).canHideWings() && widget == this.wingsButton) {
                        this.wingsButton.visible = this.showUi;
                        this.wingsButton.setTooltip(Tooltip.create((Component)Component.translatable((String)DragonBody.getWingButtonDescription(this.body))));
                        this.wingsButton.setMessage((Component)Component.translatable((String)DragonBody.getWingButtonName(this.body)));
                    } else {
                        this.wingsButton.visible = false;
                    }
                } else {
                    widget.visible = this.dragonBodyBar.isHidden(widget) ? false : this.showUi;
                }
            }
            renderable.render(graphics, mouseX, mouseY, partialTick);
        }
        this.uiButton.visible = true;
    }

    public void renderBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.fill(0, 0, this.width, this.height, -350, this.backgroundColor);
    }

    private void initDummyDragon(DragonStateHandler localHandler) {
        if (this.stage == null && localHandler.isDragon()) {
            this.body = this.species != null && !((DragonSpecies)this.species.value()).isValidForBody(localHandler.body()) ? DragonBody.getRandomUnlocked(this.species, this.unlockedBodies) : localHandler.body();
            this.stage = this.species != null && ((DragonSpecies)this.species.value()).stages().map(stages -> !stages.contains(localHandler.stage())).orElse(!((DragonStage)localHandler.stage().value()).isDefault()).booleanValue() ? ((DragonSpecies)this.species.value()).getStartingStage(null) : localHandler.stage();
        } else if (this.species != null) {
            if (this.stage == null) {
                this.stage = ((DragonSpecies)this.species.value()).getStartingStage(null);
            }
            this.body = !(this.body != null || localHandler.isDragon() && (((DragonSpecies)this.species.value()).bodies().size() == 0 && ((DragonBody)localHandler.body().value()).isDefault() || ((DragonSpecies)this.species.value()).isValidForBody(localHandler.body()))) ? DragonBody.getRandomUnlocked(this.species, this.unlockedBodies) : localHandler.body();
        } else {
            return;
        }
        HANDLER.setSpecies(null, this.species);
        HANDLER.setDesiredGrowth(null, ((DragonStage)this.stage.value()).growthRange().min());
        HANDLER.setBody(null, this.body);
        SkinPreset skinPreset = localHandler.getSkinPresetForSpecies(this.species, this.body);
        SkinPreset copy = new SkinPreset();
        copy.deserializeNBT((HolderLookup.Provider)this.minecraft.player.registryAccess(), skinPreset.serializeNBT((HolderLookup.Provider)this.minecraft.player.registryAccess()));
        if (copy.getModel().equals((Object)((DragonBody)this.body.value()).model())) {
            HANDLER.setCurrentSkinPreset(copy);
        } else {
            HANDLER.refreshSkinPresetForSpecies(this.species, this.body);
        }
        this.preset = HANDLER.getCurrentSkinPreset();
        this.dragonRender.zoom = DragonEditorScreen.setZoom(this.stage);
    }

    public void onClose() {
        super.onClose();
        this.species = null;
        this.stage = null;
        this.body = null;
    }

    private boolean dragonSpeciesWouldChange(DragonStateHandler handler) {
        return handler.species() != null && !handler.species().equals(this.species);
    }

    private boolean dragonBodyWouldChange(DragonStateHandler handler) {
        return handler.body() != null && !handler.body().equals(this.body);
    }

    public boolean dragonWouldChange(DragonStateHandler handler) {
        return handler.species() != null && !handler.species().equals(this.species) || handler.body() != null && !handler.body().equals(this.body);
    }

    public void init() {
        super.init();
        this.guiLeft = (this.width - 256) / 2;
        this.guiTop = (this.height - 120) / 2;
        this.slotDisplayMessage = SlotDisplayMessage.NONE;
        this.confirmComponent = new DragonEditorConfirmComponent(this, this.width / 2 - 65, this.height / 2 - 90, 130, 154);
        this.confirmation = false;
        this.initDragonRender();
        DragonStateHandler data = DragonStateProvider.getData((Player)this.minecraft.player);
        if (!this.hasInit) {
            this.initDummyDragon(data);
            this.update();
            this.hasInit = true;
        }
        this.selectedDragonStage = ((DragonSpecies)this.species.value()).getStages(null).stream().toList().indexOf(this.stage);
        HoverButton leftArrow = new HoverButton(this.width / 2 - 120, 10, 18, 20, 20, 20, LEFT_ARROW_MAIN, LEFT_ARROW_HOVER, button -> {
            List stages = ((DragonSpecies)this.species.value()).getStages(null).stream().toList();
            this.selectedDragonStage = Functions.wrap(this.selectedDragonStage - 1, 0, stages.size() - 1);
            this.actionHistory.add(new EditorAction<Holder>(this.selectStageAction, (Holder)stages.get(this.selectedDragonStage)));
        });
        this.addRenderableWidget((GuiEventListener)leftArrow);
        HoverButton rightArrow = new HoverButton(this.width / 2 + 103, 10, 18, 20, 20, 20, RIGHT_ARROW_MAIN, RIGHT_ARROW_HOVER, button -> {
            List stages = ((DragonSpecies)this.species.value()).getStages(null).stream().toList();
            this.selectedDragonStage = Functions.wrap(this.selectedDragonStage + 1, 0, stages.size() - 1);
            this.actionHistory.add(new EditorAction<Holder>(this.selectStageAction, (Holder)stages.get(this.selectedDragonStage)));
        });
        this.addRenderableWidget((GuiEventListener)rightArrow);
        ArrayList dragonBodyWidgets = new ArrayList();
        this.unlockedBodies.forEach(bodyEntry -> {
            if (DragonBody.bodyIsValidForSpecies(bodyEntry.body(), this.species)) {
                dragonBodyWidgets.add(this.createButton(bodyEntry.body(), bodyEntry.isUnlocked(), 0, 0));
            }
        });
        this.dragonBodyBar = new BarComponent(this, this.width / 2 - 43, this.height / 2 + 30, 3, dragonBodyWidgets, 5, -15, 92, 4, 10, 16, SMALL_LEFT_ARROW_HOVER, SMALL_LEFT_ARROW_MAIN, SMALL_RIGHT_ARROW_HOVER, SMALL_RIGHT_ARROW_MAIN);
        int maxWidth = -1;
        for (SkinLayer layer : SkinLayer.values()) {
            String name = layer.getNameUpperCase().charAt(0) + layer.getNameLowerCase().substring(1).replace("_", " ");
            maxWidth = (int)Math.max((float)maxWidth, (float)this.font.width(name) * 1.45f);
        }
        int row = 0;
        for (SkinLayer layer : SkinLayer.values()) {
            Map<String, DragonPart> parts = DragonPartLoader.getDragonParts(layer, (ResourceKey<DragonSpecies>)this.species.getKey(), this.body);
            if (layer != SkinLayer.BASE) {
                parts.put("none", null);
            }
            String partKey = ((LayerSettings)((DragonStageCustomization)this.preset.get((ResourceKey<DragonStage>)this.stage.getKey()).get()).layerSettings.get((Object)((Object)layer)).get()).partKey;
            int x = row < 8 ? this.width / 2 - 184 : this.width / 2 + 74;
            int y = this.guiTop - 24 + (row >= 8 ? (row - 8) * 21 : row * 21);
            EditorPartComponent editorPartComponent = new EditorPartComponent(this, x, y, parts, partKey, layer, row < 8, row / 4 % 2 == 0);
            this.scrollableComponents.add(editorPartComponent);
            this.partComponents.put(layer, editorPartComponent);
            ++row;
        }
        this.animationNameButton = new HoverButton(this.width / 2 - 50, this.height / 2 + 63, 100, 20, 100, 20, ANIMATION_NAME_BACKGROUND, ANIMATION_NAME_BACKGROUND, btn -> {});
        this.animationNameButton.setMessage((Component)Component.empty().append(WordUtils.capitalize((String)this.animations[this.curAnimation].replace("_", " "))));
        this.addRenderableWidget((GuiEventListener)this.animationNameButton);
        HoverButton leftAnimationArrow = new HoverButton(this.width / 2 - 57, this.height / 2 + 65, 10, 16, 10, 16, SMALL_LEFT_ARROW_MAIN, SMALL_LEFT_ARROW_HOVER, button -> {
            --this.curAnimation;
            if (this.curAnimation < 0) {
                this.curAnimation = this.animations.length - 1;
            }
            this.animationNameButton.setMessage((Component)Component.empty().append(WordUtils.capitalize((String)this.animations[this.curAnimation].replace("_", " "))));
        });
        this.addRenderableWidget((GuiEventListener)leftAnimationArrow);
        HoverButton rightAnimationArrow = new HoverButton(this.width / 2 + 48, this.height / 2 + 65, 10, 16, 10, 16, SMALL_RIGHT_ARROW_MAIN, SMALL_RIGHT_ARROW_HOVER, button -> {
            ++this.curAnimation;
            if (this.curAnimation >= this.animations.length) {
                this.curAnimation = 0;
            }
            this.animationNameButton.setMessage((Component)Component.empty().append(WordUtils.capitalize((String)this.animations[this.curAnimation].replace("_", " "))));
        });
        this.addRenderableWidget((GuiEventListener)rightAnimationArrow);
        HoverButton saveButton = new HoverButton(this.width / 2 - 60, this.height - 30, 60, 20, 60, 20, CONFIRM_MAIN, CONFIRM_HOVER, button -> {}){
            Renderable renderButton;
            boolean toggled;

            @Override
            public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
                super.renderWidget(guiGraphics, mouseX, mouseY, partial);
                if (!(!this.toggled || this.visible && DragonEditorScreen.this.confirmation)) {
                    this.toggled = false;
                    Screen screen = Minecraft.getInstance().screen;
                    Objects.requireNonNull(screen).children().removeIf(s -> s == DragonEditorScreen.this.confirmComponent);
                    screen.renderables.removeIf(s -> s == this.renderButton);
                }
            }

            public void onPress() {
                boolean dragonDataIsPreserved;
                DragonStateHandler handler = DragonStateProvider.getData((Player)((DragonEditorScreen)DragonEditorScreen.this).minecraft.player);
                ((DragonEditorScreen)DragonEditorScreen.this).minecraft.player.level().playSound((Player)((DragonEditorScreen)DragonEditorScreen.this).minecraft.player, ((DragonEditorScreen)DragonEditorScreen.this).minecraft.player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 0.7f);
                boolean bl = dragonDataIsPreserved = ServerConfig.saveAllAbilities != false && ServerConfig.saveGrowthStage != false;
                if (handler.isDragon() && DragonEditorScreen.this.dragonWouldChange(handler) && !dragonDataIsPreserved) {
                    DragonEditorScreen.this.confirmation = true;
                    DragonEditorScreen.this.confirmComponent.isBodyTypeChange = DragonEditorScreen.this.dragonBodyWouldChange(handler) && !DragonEditorScreen.this.dragonSpeciesWouldChange(handler);
                } else {
                    DragonEditorScreen.this.confirm();
                }
                if (DragonEditorScreen.this.confirmation) {
                    if (!this.toggled) {
                        this.renderButton = new ExtendedButton(0, 0, 0, 0, (Component)Component.empty(), button -> {}){

                            public void renderWidget(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                                if (DragonEditorScreen.this.confirmComponent != null && DragonEditorScreen.this.confirmation) {
                                    DragonEditorScreen.this.confirmComponent.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
                                }
                                super.renderWidget(guiGraphics, pMouseX, pMouseY, pPartialTick);
                            }
                        };
                        ((ScreenAccessor)((Object)DragonEditorScreen.this)).dragonSurvival$children().add((GuiEventListener)DragonEditorScreen.this.confirmComponent);
                        DragonEditorScreen.this.renderables.add(this.renderButton);
                    }
                    this.toggled = !this.toggled;
                } else {
                    DragonEditorScreen.this.children().removeIf(listener -> listener == DragonEditorScreen.this.confirmComponent);
                    DragonEditorScreen.this.renderables.removeIf(renderable -> renderable == this.renderButton);
                }
            }
        };
        saveButton.setMessage((Component)Component.translatable((String)LangKey.GUI_CONFIRM));
        this.addRenderableWidget((GuiEventListener)saveButton);
        HoverButton discardButton = new HoverButton(this.width / 2 + 1, this.height - 30, 60, 20, 60, 20, CANCEL_MAIN, CANCEL_HOVER, btn -> Minecraft.getInstance().setScreen(null));
        discardButton.setMessage((Component)Component.translatable((String)LangKey.GUI_CANCEL));
        this.addRenderableWidget((GuiEventListener)discardButton);
        RegistryAccess access = Objects.requireNonNull(Minecraft.getInstance().player).registryAccess();
        HoverButton randomButton = new HoverButton(this.width / 2 - 8, 40, 16, 17, 20, 20, RANDOM_MAIN, RANDOM_HOVER, btn -> {
            Map<String, DragonPart> extraParts = DragonPartLoader.getDragonParts((Player)FakeClientPlayerUtils.getFakePlayer(0, HANDLER), SkinLayer.EXTRA);
            SkinPreset preset = new SkinPreset();
            preset.initDefaults(this.species, ((DragonBody)this.body.value()).model());
            preset.deserializeNBT((HolderLookup.Provider)access, this.preset.serializeNBT((HolderLookup.Provider)access));
            for (SkinLayer layer : SkinLayer.values()) {
                Map<String, DragonPart> parts = Objects.equals(layer.name, "Extra") ? extraParts : DragonPartLoader.getDragonParts((Player)FakeClientPlayerUtils.getFakePlayer(0, HANDLER), layer);
                List<String> partKeys = DragonEditorScreen.getPartKeys(layer, parts);
                if (parts.isEmpty()) continue;
                String partKey = partKeys.get(this.minecraft.player.getRandom().nextInt(partKeys.size()));
                if (Objects.equals(layer.name, "Extra")) {
                    extraParts.remove(partKey);
                }
                DragonPart part = DragonPartLoader.getDragonPart(layer, (ResourceKey<DragonSpecies>)this.species.getKey(), this.body, partKey);
                LayerSettings settings = (LayerSettings)((DragonStageCustomization)preset.get((ResourceKey<DragonStage>)this.stage.getKey()).get()).layerSettings.get((Object)layer).get();
                settings.partKey = partKey;
                if (part != null && part.isHueRandomizable()) {
                    settings.hue = this.minecraft.player.getRandom().nextFloat();
                    settings.saturation = 0.25f + this.minecraft.player.getRandom().nextFloat() * 0.5f;
                    settings.brightness = 0.3f + this.minecraft.player.getRandom().nextFloat() * 0.3f;
                } else {
                    settings.hue = part != null ? part.averageHue() : 0.0f;
                    settings.saturation = 0.5f;
                    settings.brightness = 0.5f;
                }
                settings.modifiedColor = true;
            }
            this.actionHistory.add(new EditorAction<CompoundTag>(this.setSkinPresetAction, preset.serializeNBT((HolderLookup.Provider)access)));
        });
        randomButton.setTooltip(Tooltip.create((Component)Component.translatable((String)RANDOMIZE)));
        this.addRenderableWidget((GuiEventListener)randomButton);
        HoverButton undoButton = new HoverButton(this.width / 2 - 27, 40, 15, 14, 20, 20, UNDO_MAIN, UNDO_HOVER, button -> this.actionHistory.undo());
        undoButton.setTooltip(Tooltip.create((Component)Component.translatable((String)UNDO)));
        this.addRenderableWidget((GuiEventListener)undoButton);
        HoverButton redoButton = new HoverButton(this.width / 2 + 12, 40, 15, 14, 20, 20, REDO_MAIN, REDO_HOVER, button -> this.actionHistory.redo());
        redoButton.setTooltip(Tooltip.create((Component)Component.translatable((String)REDO)));
        this.addRenderableWidget((GuiEventListener)redoButton);
        HoverButton copyToAllStagesButton = new HoverButton(this.guiLeft - 75, 10, 18, 18, 18, 18, COPY_ALL_MAIN, COPY_ALL_HOVER, button -> {
            Lazy<DragonStageCustomization> lazy = this.preset.get((ResourceKey<DragonStage>)Objects.requireNonNull(this.stage.getKey()));
            CompoundTag storedPresetData = ((DragonStageCustomization)lazy.get()).serializeNBT((HolderLookup.Provider)access);
            for (Holder holder : ResourceHelper.all((HolderLookup.Provider)access, DragonStage.REGISTRY)) {
                this.preset.put((ResourceKey<DragonStage>)Objects.requireNonNull(holder.getKey()), (Lazy<DragonStageCustomization>)Lazy.of(() -> {
                    DragonStageCustomization customization = new DragonStageCustomization();
                    customization.deserializeNBT((HolderLookup.Provider)access, storedPresetData);
                    return customization;
                }));
            }
            this.actionHistory.clear();
        });
        copyToAllStagesButton.setTooltip(Tooltip.create((Component)Component.translatable((String)COPY)));
        this.addRenderableWidget((GuiEventListener)copyToAllStagesButton);
        HoverButton helpButton = new HoverButton(this.guiLeft - 75, this.height - 30, 20, 20, 20, 20, INFO_MAIN, INFO_HOVER, button -> {});
        helpButton.setTooltip(Tooltip.create((Component)Component.translatable((String)CUSTOMIZATION)));
        this.addRenderableWidget((GuiEventListener)helpButton);
        this.wingsButton = new ExtendedButton(this.guiLeft - 35, this.height - 30, 20, 20, (Component)Component.translatable((String)DragonBody.getWingButtonDescription(this.body)), button -> this.actionHistory.add(new EditorAction<Boolean>(this.checkWingsButtonAction, !((DragonStageCustomization)this.preset.get((ResourceKey<DragonStage>)Objects.requireNonNull(this.stage.getKey())).get()).wings))){

            public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                ResourceLocation texture = ((DragonStageCustomization)DragonEditorScreen.this.preset.get((ResourceKey<DragonStage>)Objects.requireNonNull(DragonEditorScreen.this.stage.getKey())).get()).wings ? ALTERNATIVE_ON : ALTERNATIVE_OFF;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
                guiGraphics.blit(texture, this.getX(), this.getY(), 0.0f, 0.0f, 20, 20, 20, 20);
                guiGraphics.pose().popPose();
            }
        };
        this.addRenderableWidget((GuiEventListener)this.wingsButton);
        this.uiButton = new ExtendedButton(this.guiLeft - 13, this.height - 30, 20, 20, (Component)Component.translatable((String)SHOW_UI), button -> {
            this.showUi = !this.showUi;
        }){

            public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                ResourceLocation texture = DragonEditorScreen.this.showUi ? SHOW_UI_ON : SHOW_UI_OFF;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
                guiGraphics.blit(texture, this.getX(), this.getY(), 0.0f, 0.0f, 20, 20, 20, 20);
                guiGraphics.pose().popPose();
            }
        };
        this.uiButton.setTooltip(Tooltip.create((Component)Component.translatable((String)SHOW_UI)));
        this.addRenderableWidget((GuiEventListener)this.uiButton);
        HoverButton resetButton = new HoverButton(this.guiLeft + 9, this.height - 30, 20, 20, 20, 20, RESET_MAIN, RESET_HOVER, button -> {
            SkinPreset preset = new SkinPreset();
            preset.initDefaults(this.species, ((DragonBody)this.body.value()).model());
            preset.deserializeNBT((HolderLookup.Provider)access, this.preset.serializeNBT((HolderLookup.Provider)access));
            preset.put((ResourceKey<DragonStage>)this.stage.getKey(), (Lazy<DragonStageCustomization>)Lazy.of(() -> new DragonStageCustomization((ResourceKey<DragonStage>)this.stage.getKey(), (ResourceKey<DragonSpecies>)this.species.getKey(), ((DragonBody)this.body.value()).model())));
            this.actionHistory.add(new EditorAction<CompoundTag>(this.setSkinPresetAction, preset.serializeNBT((HolderLookup.Provider)access)));
        });
        resetButton.setTooltip(Tooltip.create((Component)Component.translatable((String)RESET)));
        this.addRenderableWidget((GuiEventListener)resetButton);
        this.backgroundColorButton = new BackgroundColorButton(this.guiLeft + 31, this.height - 30, 20, 20, (Component)Component.empty(), action -> {}, this);
        this.addRenderableWidget((GuiEventListener)this.backgroundColorButton);
        HoverButton slotBackground = new HoverButton(this.width / 2 + 85, this.height - 28, 121, 18, 121, 18, SAVE_SLOT_BACKGROUND, SAVE_SLOT_BACKGROUND, button -> {});
        this.addRenderableOnly((Renderable)slotBackground);
        HoverButton slotInfoButton = new HoverButton(this.width / 2 + 74, this.height - 28, 17, 18, 20, 20, SLOT_INFO_MAIN, SLOT_INFO_HOVER, button -> {});
        slotInfoButton.setTooltip(this.createSlotInfoTooltip());
        this.addRenderableWidget((GuiEventListener)slotInfoButton);
        for (int slot = 1; slot <= 5; ++slot) {
            this.addRenderableWidget((GuiEventListener)new DragonEditorSlotButton(this.width / 2 + 95 + 12 * (slot - 1), this.height - 26, slot, this, () -> slotInfoButton.setTooltip(this.createSlotInfoTooltip())));
        }
        HoverButton loadSlotButton = new HoverButton(this.width / 2 + 182, this.height - 28, 17, 18, 20, 20, SLOT_LOAD_MAIN, SLOT_LOAD_HOVER, button -> {
            CustomizationFileHandler.SavedCustomization savedCustomization = CustomizationFileHandler.load(this.selectedSaveSlot);
            if (savedCustomization == null) {
                this.slotDisplayMessage = SlotDisplayMessage.NO_DATA;
                this.tickWhenSlotDisplayMessageSet = this.tick;
                return;
            }
            if (!savedCustomization.getDragonModel().equals((Object)((DragonBody)this.body.value()).model())) {
                this.slotDisplayMessage = SlotDisplayMessage.INVALID_FOR_MODEL;
                this.tickWhenSlotDisplayMessageSet = this.tick;
                return;
            }
            if (savedCustomization.getDragonSpecies() != this.species.getKey()) {
                this.slotDisplayMessage = SlotDisplayMessage.INVALID_FOR_TYPE;
                this.tickWhenSlotDisplayMessageSet = this.tick;
                return;
            }
            this.actionHistory.add(new EditorAction<DragonStageCustomization>(this.loadStageCustomizationAction, savedCustomization.getCustomization()));
        });
        loadSlotButton.setTooltip(Tooltip.create((Component)Component.translatable((String)LOAD)));
        this.addRenderableWidget((GuiEventListener)loadSlotButton);
        HoverButton saveSlotButton = new HoverButton(this.width / 2 + 160, this.height - 28, 17, 18, 20, 20, SLOT_SAVE_MAIN, SLOT_SAVE_HOVER, button -> {
            CustomizationFileHandler.save(HANDLER, this.selectedSaveSlot);
            this.slotDisplayMessage = SlotDisplayMessage.SLOT_SAVED;
            this.tickWhenSlotDisplayMessageSet = this.tick;
        });
        saveSlotButton.setTooltip(Tooltip.create((Component)Component.translatable((String)SAVE)));
        this.addRenderableWidget((GuiEventListener)saveSlotButton);
    }

    @NotNull
    private static List<String> getPartKeys(SkinLayer layer, Map<String, DragonPart> parts) {
        ArrayList<String> partKeys = new ArrayList<String>(parts.keySet());
        partKeys.removeIf(key -> {
            DragonPart part = (DragonPart)parts.get(key);
            if (part == null && !key.equals("none")) {
                DragonSurvival.LOGGER.error("Key {} not found!", key);
                return true;
            }
            if (part == null) {
                return true;
            }
            return !part.includeInRandomizer();
        });
        if (layer != SkinLayer.BASE) {
            partKeys.add("none");
        }
        return partKeys;
    }

    private DragonBodyButton createButton(Holder<DragonBody> dragonBody, boolean unlocked, int x, int y) {
        DragonBodyButton.LockedReason lockedReason = !this.fromAltar ? DragonBodyButton.LockedReason.NOT_IN_ALTAR : (!unlocked ? DragonBodyButton.LockedReason.NOT_UNLOCKED : DragonBodyButton.LockedReason.NONE);
        return new DragonBodyButton(this, x, y, 25, 25, dragonBody, lockedReason, button -> {
            if (((DragonBodyButton)button).lockedReason() == DragonBodyButton.LockedReason.NONE && dragonBody.value() != this.body.value()) {
                this.actionHistory.add(new EditorAction<Holder>(this.dragonBodySelectAction, dragonBody));
                if (((DragonBody)dragonBody.value()).model() != ((DragonBody)this.body.value()).model()) {
                    this.actionHistory.clear();
                }
            }
        });
    }

    public void update() {
        if (this.species != null) {
            HANDLER.setSpecies(null, this.species);
        }
        HANDLER.setBody(null, this.body);
        HANDLER.setCurrentSkinPreset(this.preset);
        HANDLER.setDesiredGrowth(null, ((DragonStage)this.stage.value()).growthRange().min());
        this.refreshPartComponents();
    }

    private void initDragonRender() {
        this.children().removeIf(DragonUIRenderComponent.class::isInstance);
        float yRot = -3.0f;
        float xRot = -5.0f;
        float zoom = 0.0f;
        float xOffset = 0.0f;
        float yOffset = -20.0f;
        if (this.dragonRender != null) {
            yRot = this.dragonRender.yRot;
            xRot = this.dragonRender.xRot;
            zoom = this.dragonRender.zoom;
            xOffset = this.dragonRender.xOffset;
            yOffset = this.dragonRender.yOffset;
        }
        this.dragonRender = new DragonUIRenderComponent(this, this.width / 2 - 70, this.guiTop, 140, 125, () -> {
            DragonEntity dragon = FakeClientPlayerUtils.getFakeDragon(0, HANDLER);
            dragon.tailLocked = true;
            dragon.neckLocked = true;
            return dragon;
        });
        this.dragonRender.xRot = xRot;
        this.dragonRender.yRot = yRot;
        this.dragonRender.zoom = zoom;
        this.dragonRender.xOffset = xOffset;
        this.dragonRender.yOffset = yOffset;
        ((ScreenAccessor)((Object)this)).dragonSurvival$children().addFirst((GuiEventListener)this.dragonRender);
    }

    @Override
    public void cancel() {
        this.confirmation = false;
        this.showUi = true;
    }

    @Override
    public void confirm() {
        DragonStateHandler data = DragonStateProvider.getData((Player)this.minecraft.player);
        this.minecraft.player.level().playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 0.7f);
        if (!data.isDragon() || this.dragonWouldChange(data)) {
            if (this.species == null && data.species() != null) {
                ClawInventoryData.reInsertClawTools((Player)this.minecraft.player);
            }
            data.setBody((Player)this.minecraft.player, this.body);
            data.setSpecies((Player)this.minecraft.player, this.species);
            double savedSize = data.getSavedDragonAge(data.speciesKey());
            if (!ServerConfig.saveGrowthStage.booleanValue() || savedSize == -1.0) {
                data.setGrowth((Player)this.minecraft.player, ((DragonSpecies)this.species.value()).getStartingGrowth((HolderLookup.Provider)this.minecraft.player.registryAccess()));
            } else {
                data.setDesiredGrowth((Player)this.minecraft.player, savedSize);
            }
            FlightData.getData((Player)this.minecraft.player).hasSpin = ServerConfig.saveGrowthStage != false && FlightData.getData((Player)this.minecraft.player).hasSpin;
            data.setCurrentSkinPreset(this.preset);
            data.getSkinData().renderCustomSkin = ClientDragonRenderer.renderCustomSkin;
            AltarData altarData = AltarData.getData((Player)this.minecraft.player);
            altarData.altarCooldown = Functions.secondsToTicks(ServerConfig.altarUsageCooldown.intValue());
            altarData.hasUsedAltar = true;
            altarData.isInAltar = false;
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncAltarCooldown(altarData.altarCooldown), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncComplete(this.minecraft.player.getId(), data.serializeNBT((HolderLookup.Provider)this.minecraft.player.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            data.setCurrentSkinPreset(this.preset);
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncPlayerSkinPreset(this.minecraft.player.getId(), HANDLER.speciesKey(), HANDLER.getCurrentSkinPreset().serializeNBT((HolderLookup.Provider)this.minecraft.player.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.minecraft.player.closeContainer();
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.dragonRender != null && this.dragonRender.isMouseOver(pMouseX, pMouseY) && (this.backgroundColorButton == null || !this.backgroundColorButton.toggled)) {
            return this.dragonRender.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    @SubscribeEvent
    public static void undoRedoKeybinds(ScreenEvent.KeyPressed.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof DragonEditorScreen) {
            DragonEditorScreen screen2 = (DragonEditorScreen)screen;
            if (event.getKeyCode() == 90 && event.getModifiers() == 2) {
                screen2.actionHistory.undo();
            } else if (event.getKeyCode() == 89 && event.getModifiers() == 2) {
                screen2.actionHistory.redo();
            }
        }
    }

    private Tooltip createSlotInfoTooltip() {
        return Tooltip.create((Component)Component.translatable((String)SAVING_INFO, (Object[])new Object[]{Component.literal((String)("dragon-survival/" + CustomizationFileHandler.FILE_NAME.apply(this.selectedSaveSlot))).withColor(0xFFAA00)}));
    }

    private static enum SlotDisplayMessage {
        INVALID_FOR_TYPE,
        INVALID_FOR_MODEL,
        NO_DATA,
        SLOT_SAVED,
        NONE;

    }

    public static class UndoRedoList {
        private final List<UndoRedoPair> delegate = new ArrayList<UndoRedoPair>();
        private final int maxSize;
        private int selectedIndex = 0;

        public UndoRedoList(int maxSize) {
            this.maxSize = maxSize;
        }

        public <T> void add(EditorAction<T> action) {
            T previousState = action.run();
            if (this.selectedIndex > 0 && action.equals(this.delegate.get((int)(this.selectedIndex - 1)).redo)) {
                return;
            }
            this.delegate.subList(this.selectedIndex, this.delegate.size()).clear();
            EditorAction undoAction = new EditorAction(action.action, previousState);
            this.delegate.add(new UndoRedoPair(undoAction, action));
            if (this.delegate.size() > this.maxSize) {
                this.delegate.removeFirst();
            } else {
                ++this.selectedIndex;
            }
        }

        public void undo() {
            if (this.selectedIndex > 0) {
                --this.selectedIndex;
                this.delegate.get((int)this.selectedIndex).undo.run();
            }
        }

        public void redo() {
            if (this.selectedIndex < this.delegate.size()) {
                this.delegate.get((int)this.selectedIndex).redo.run();
                ++this.selectedIndex;
            }
        }

        public void clear() {
            this.delegate.clear();
            this.selectedIndex = 0;
        }

        private record UndoRedoPair(EditorAction<?> undo, EditorAction<?> redo) {
        }
    }

    public record EditorAction<T>(Function<T, T> action, T value) {
        public T run() {
            return this.action.apply(this.value);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof EditorAction) {
                EditorAction editorAction = (EditorAction)object;
                if (editorAction.action != null && editorAction.value != null) {
                    return editorAction.action.equals(this.action) && editorAction.value.equals(this.value);
                }
            }
            return false;
        }
    }
}

