/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.screens;

import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.GrowthCrystalButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.TabButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.ClickHoverButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.HoverButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.BarComponent;
import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.MiscResources;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.StageResources;
import by.dragonsurvivalteam.dragonsurvival.network.claw.SyncDragonClawMenuToggle;
import by.dragonsurvivalteam.dragonsurvival.network.claw.SyncDragonClawRender;
import by.dragonsurvivalteam.dragonsurvival.network.container.RequestOpenVanillaInventory;
import by.dragonsurvivalteam.dragonsurvival.network.container.SortInventory;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.ClawInventoryData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.server.containers.DragonContainer;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.NotNull;

public class DragonInventoryScreen
extends EffectRenderingInventoryScreen<DragonContainer> {
    @Translation(comments={"Toggle showing claws and teeth textures on your model."})
    private static final String TOGGLE_CLAWS = Translation.Type.GUI.wrap("dragon_inventory.toggle_claws");
    @Translation(comments={"Sort inventory"})
    private static final String SORT_INVENTORY = Translation.Type.GUI.wrap("dragon_inventory.sort_inventory");
    @Translation(comments={"Open vanilla inventory screen"})
    private static final String TOGGLE_VANILLA_INVENTORY = Translation.Type.GUI.wrap("dragon_inventory.toggle_vanilla_inventory");
    @Translation(comments={"Open the config screen"})
    private static final String TOGGLE_CONFIG = Translation.Type.GUI.wrap("inventory.toggle_config");
    @Translation(comments={"\u25a0 Just put \u00a76any tools\u00a7r\u00a7f here in your claw slots and your bare paw will borrow their aspect as long as they are intact.", "\u00a77\u25a0 Does not stack with \u00a72\u00abClaws and Teeth\u00bb\u00a7r\u00a77 skill, which only applies if these slots are empty."})
    private static final String HELP_CLAWS = Translation.Type.GUI.wrap("help.claws");
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/inventory/dragon_inventory.png");
    private static final ResourceLocation CLAWS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/inventory/dragon_claws.png");
    private static final ResourceLocation CLAW_ARROW_CLICK = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/inventory/claw_arrow_left_click.png");
    private static final ResourceLocation CLAW_ARROW_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/inventory/claw_arrow_left_hover.png");
    private static final ResourceLocation CLAW_ARROW_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/inventory/claw_arrow_left_main.png");
    private static final ResourceLocation CLAW_DISPLAY_ON = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/inventory/claw_display_on.png");
    private static final ResourceLocation CLAW_DISPLAY_OFF = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/inventory/claw_display_off.png");
    private static final ResourceLocation INFO_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/inventory/info_hover.png");
    private static final ResourceLocation INFO_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/inventory/info_main.png");
    private static final ResourceLocation CONFIG_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/inventory/config_hover.png");
    private static final ResourceLocation CONFIG_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/inventory/config_main.png");
    private static final ResourceLocation VANILLA_INVENTORY_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/inventory/vanilla_inventory_hover.png");
    private static final ResourceLocation VANILLA_INVENTORY_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/inventory/vanilla_inventory_main.png");
    private static final ResourceLocation SORT_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/inventory/sort_hover.png");
    private static final ResourceLocation SORT_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/inventory/sort_main.png");
    public static double mouseX = -1.0;
    public static double mouseY = -1.0;
    private HoverButton growthButton;
    private int growthTooltipScroll;
    private boolean clawsMenu;
    private final Player player;
    private final List<ExtendedButton> clawMenuButtons = new ArrayList<ExtendedButton>();

    public DragonInventoryScreen(DragonContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.player = inv.player;
        this.clawsMenu = ClawInventoryData.getData(this.player).isMenuOpen();
        this.imageWidth = 203;
        this.imageHeight = 166;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.growthTooltipScroll = this.growthButton.isHovered() ? (this.growthTooltipScroll += (int)(-scrollY)) : 0;
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    protected void init() {
        super.init();
        if (mouseX != -1.0 && mouseY != -1.0) {
            InputConstants.grabOrReleaseMouse((long)this.minecraft.getWindow().getWindow(), (int)212993, (double)mouseX, (double)mouseY);
            mouseX = -1.0;
            mouseY = -1.0;
        }
        this.leftPos = (this.width - this.imageWidth) / 2;
        ClawInventoryData clawInventory = ClawInventoryData.getData(this.player);
        this.clawsMenu = clawInventory.isMenuOpen();
        PacketDistributor.sendToServer((CustomPacketPayload)new SyncDragonClawMenuToggle(this.clawsMenu), (CustomPacketPayload[])new CustomPacketPayload[0]);
        TabButton.addTabButtonsToScreen((Screen)this, this.leftPos + 5, this.topPos - 26, TabButton.TabButtonType.INVENTORY_TAB);
        ClickHoverButton clawMenuArrow = new ClickHoverButton(this.leftPos - 8, this.topPos + 73, 10, 18, 0, 0, 18, 18, (Component)Component.empty(), button -> {
            this.clawsMenu = !this.clawsMenu;
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncDragonClawMenuToggle(this.clawsMenu), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }, CLAW_ARROW_CLICK, CLAW_ARROW_HOVER, CLAW_ARROW_MAIN);
        this.addRenderableWidget((GuiEventListener)clawMenuArrow);
        HoverButton infoButton = new HoverButton(this.leftPos - 23, this.topPos + 4, 12, INFO_MAIN, INFO_HOVER);
        infoButton.setTooltip(Tooltip.create((Component)Component.translatable((String)HELP_CLAWS)));
        this.addRenderableWidget((GuiEventListener)infoButton);
        this.clawMenuButtons.add(infoButton);
        ExtendedButton clawRenderButton = new ExtendedButton(this, this.leftPos - 30 + 7, this.topPos + 120 + 27, 10, 10, (Component)Component.translatable((String)TOGGLE_CLAWS), button -> {
            ClientDragonRenderer.renderDragonClaws = ClientDragonRenderer.renderDragonClaws == false;
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncDragonClawRender(this.player.getId(), ClientDragonRenderer.renderDragonClaws), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }){

            public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            }
        };
        clawRenderButton.setTooltip(Tooltip.create((Component)Component.translatable((String)TOGGLE_CLAWS)));
        this.addRenderableWidget((GuiEventListener)clawRenderButton);
        this.clawMenuButtons.add(clawRenderButton);
        DragonStateHandler data = DragonStateProvider.getData((Player)this.minecraft.player);
        StageResources.GrowthIcon growthIcon = StageResources.getGrowthIcon(data.species(), data.stageKey());
        this.growthButton = new HoverButton(this.leftPos + 175, this.topPos + 4, 20, growthIcon.icon(), growthIcon.hoverIcon(), () -> {
            DragonStateHandler handler = DragonStateProvider.getData((Player)this.minecraft.player);
            Pair<List<Either<FormattedText, TooltipComponent>>, Integer> growthDescriptionResult = handler.getGrowthDescription(this.growthTooltipScroll);
            List components = (List)growthDescriptionResult.getFirst();
            this.growthTooltipScroll = (Integer)growthDescriptionResult.getSecond();
            return components;
        });
        this.addRenderableWidget((GuiEventListener)this.growthButton);
        List<Holder<DragonStage>> stages = data.getStagesSortedByProgression((HolderLookup.Provider)this.minecraft.player.registryAccess());
        if (!stages.isEmpty()) {
            List<AbstractWidget> crystals = stages.stream().map(stage -> new GrowthCrystalButton(0, 0, (Holder<DragonStage>)stage)).toList();
            MiscResources textures = ((DragonSpecies)data.species().value()).miscResources();
            new BarComponent((Screen)this, this.leftPos + 124, this.topPos + 6, 4, crystals, 2, -11, 39, 1, 12, 16, textures.growthLeftArrow().hoverIcon(), textures.growthLeftArrow().icon(), textures.growthRightArrow().hoverIcon(), textures.growthRightArrow().icon());
        }
        HoverButton vanillaInventoryButton = new HoverButton(this.leftPos + 177, this.topPos + 84, 18, 16, 18, 18, VANILLA_INVENTORY_MAIN, VANILLA_INVENTORY_HOVER, button -> {
            Minecraft.getInstance().setScreen((Screen)new InventoryScreen(this.player));
            PacketDistributor.sendToServer((CustomPacketPayload)RequestOpenVanillaInventory.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
        vanillaInventoryButton.setTooltip(Tooltip.create((Component)Component.translatable((String)TOGGLE_VANILLA_INVENTORY)));
        this.addRenderableWidget((GuiEventListener)vanillaInventoryButton);
        HoverButton configButton = new HoverButton(this.leftPos + 177, this.topPos + 102, 18, 16, 18, 18, CONFIG_MAIN, CONFIG_HOVER, button -> {
            Minecraft minecraft = Minecraft.getInstance();
            Optional configScreen = ModList.get().getModContainerById("dragonsurvival").flatMap(m -> {
                IModInfo modInfo = m.getModInfo();
                return IConfigScreenFactory.getForMod((IModInfo)modInfo).map(f -> f.createScreen(m, minecraft.screen));
            });
            minecraft.setScreen((Screen)configScreen.orElse(null));
        });
        configButton.setTooltip(Tooltip.create((Component)Component.translatable((String)TOGGLE_CONFIG)));
        this.addRenderableWidget((GuiEventListener)configButton);
        HoverButton sortInventoryButton = new HoverButton(this.leftPos + 177, this.topPos + 120, 18, 16, 18, 18, SORT_MAIN, SORT_HOVER, button -> PacketDistributor.sendToServer((CustomPacketPayload)SortInventory.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]));
        sortInventoryButton.setTooltip(Tooltip.create((Component)Component.translatable((String)SORT_INVENTORY)));
        this.addRenderableWidget((GuiEventListener)sortInventoryButton);
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        guiGraphics.blit(BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
        int scissorY1 = this.topPos + 77;
        int scissorX1 = this.leftPos + 101;
        int scissorX0 = this.leftPos + 25;
        int scissorY0 = this.topPos + 8;
        int scale = (int)(20.0f * this.player.getScale());
        scale = Math.clamp((long)scale, 10, 40);
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)scissorX0, (int)scissorY0, (int)scissorX1, (int)scissorY1, (int)scale, (float)0.0f, (float)mouseX, (float)mouseY, (LivingEntity)this.player);
        if (!this.clawsMenu) {
            return;
        }
        guiGraphics.blit(CLAWS_TEXTURE, this.leftPos - 33, this.topPos, 0, 0, 77, 170);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.clawMenuButtons.forEach(button -> {
            button.visible = this.clawsMenu;
        });
        super.render(graphics, mouseX, mouseY, partialTick);
        if (this.clawsMenu) {
            ResourceLocation texture = ClientDragonRenderer.renderDragonClaws != false ? CLAW_DISPLAY_ON : CLAW_DISPLAY_OFF;
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 100.0f);
            graphics.blit(texture, this.leftPos - 30, this.topPos + 120, 0.0f, 0.0f, 24, 42, 24, 42);
            graphics.pose().popPose();
        }
        this.renderTooltip(graphics, mouseX, mouseY);
        this.growthButton.renderTooltip(graphics, mouseX, mouseY);
    }
}

