/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.screens;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.ConfirmableScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.AltarTypeButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.HoverButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.HoverDisableable;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.BarComponent;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.DragonEditorConfirmComponent;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.ScrollableComponent;
import by.dragonsurvivalteam.dragonsurvival.client.util.FakeClientPlayerUtils;
import by.dragonsurvivalteam.dragonsurvival.client.util.TextRenderUtil;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.UnlockableBehavior;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.mixins.HolderSet$NamedAccess;
import by.dragonsurvivalteam.dragonsurvival.mixins.client.ScreenAccessor;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.AltarData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSDragonSpeciesTags;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class DragonAltarScreen
extends Screen
implements ConfirmableScreen {
    @Translation(comments={"Choose a Species"})
    private static final String CHOOSE_SPECIES = Translation.Type.GUI.wrap("altar.choose_species");
    @Translation(comments={"You didn't make your initial choice in the Dragon Altar!", "You may still open the altar in your inventory."})
    private static final String NO_CHOICE = Translation.Type.GUI.wrap("altar.no_choice");
    @Translation(comments={"\u00a76\u25a0 Welcome to Dragon Survival!\u00a7r", "\u25a0 You can choose which dragon \u00a76species\u00a7r\u00a7r you want to become. This decision is not permanent, but you may lose progress if you change your mind.", "\u25a0\u00a77 Don't forget to read patch notes and delete old configs if you update our mod to avoid bugs! Enjoy the game! :3"})
    private static final String HELP = Translation.Type.GUI.wrap("altar.help");
    @Translation(comments={"Dragon Survival"})
    private static final String TITLE = Translation.Type.GUI.wrap("altar.title");
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/block/black_concrete.png");
    private final DragonStateHandler handler1 = new DragonStateHandler();
    private final DragonStateHandler handler2 = new DragonStateHandler();
    private final String[] animations = new String[]{"sit", "idle", "fly", "swim", "run", "dig", "vibing_sitting", "shy_sitting", "rocking_on_back"};
    private final List<ScrollableComponent> scrollableComponents = new ArrayList<ScrollableComponent>();
    private static final ResourceLocation ALTAR_ARROW_LEFT_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/altar/arrow_left_hover.png");
    private static final ResourceLocation ALTAR_ARROW_LEFT_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/altar/arrow_left_main.png");
    private static final ResourceLocation ALTAR_ARROW_RIGHT_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/altar/arrow_right_hover.png");
    private static final ResourceLocation ALTAR_ARROW_RIGHT_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/altar/arrow_right_main.png");
    private static final ResourceLocation INFO_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/altar/info_hover.png");
    private static final ResourceLocation INFO_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/altar/info_main.png");
    private final List<UnlockableBehavior.SpeciesEntry> entries;
    private boolean hasInit = false;
    private int animation1 = 1;
    private int animation2 = 0;
    private int tick;
    private DragonEditorConfirmComponent confirmComponent;
    private AltarTypeButton humanButton;
    private Renderable renderButton;
    private boolean confirmation;

    public DragonAltarScreen(List<UnlockableBehavior.SpeciesEntry> entries) {
        super((Component)Component.translatable((String)CHOOSE_SPECIES));
        DragonSurvival.PROXY.getAccess().registryOrThrow(DragonSpecies.REGISTRY).getTag(DSDragonSpeciesTags.ORDER).ifPresent(order -> {
            List list = ((HolderSet$NamedAccess)order).dragonSurvival$contents();
            Comparator<UnlockableBehavior.SpeciesEntry> comparator = Comparator.comparingInt(entry -> {
                int index = list.indexOf(entry.species());
                return index == -1 ? Integer.MAX_VALUE : index;
            });
            entries.sort(comparator);
        });
        this.entries = entries;
    }

    public void onClose() {
        super.onClose();
        LocalPlayer player = Minecraft.getInstance().player;
        AltarData data = AltarData.getData((Player)player);
        data.isInAltar = false;
        if (!data.hasUsedAltar) {
            data.hasUsedAltar = DragonStateProvider.isDragon((Entity)player);
        }
        if (!data.hasUsedAltar) {
            player.displayClientMessage((Component)Component.translatable((String)NO_CHOICE), false);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        for (ScrollableComponent component : this.scrollableComponents) {
            component.scroll(mouseX, mouseY, scrollX, scrollY);
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.confirmComponent != null && this.confirmation) {
            for (GuiEventListener guiEventListener : this.confirmComponent.children()) {
                if (!guiEventListener.mouseClicked(mouseX, mouseY, button)) continue;
                this.setFocused(guiEventListener);
                if (button == 0) {
                    this.setDragging(true);
                }
                return true;
            }
            return false;
        }
        for (GuiEventListener guiEventListener : this.children()) {
            if (!guiEventListener.mouseClicked(mouseX, mouseY, button)) continue;
            this.setFocused(guiEventListener);
            if (button == 0) {
                this.setDragging(true);
            }
            if (this.confirmComponent != null && this.confirmation) {
                for (GuiEventListener guieventlistener2 : this.children()) {
                    if (!(guieventlistener2 instanceof HoverDisableable)) continue;
                    HoverDisableable hoverDisableable = (HoverDisableable)guieventlistener2;
                    hoverDisableable.disableHover();
                }
            }
            return true;
        }
        return false;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.minecraft == null) {
            return;
        }
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        ++this.tick;
        if (this.tick % 200 * 20 == 0) {
            ++this.animation1;
            ++this.animation2;
            if (this.handler1.species() != null && this.handler2.species() != null) {
                if (this.handler1.body() == null) {
                    this.handler1.setBody(null, DragonBody.getRandom(null, this.handler1.species()));
                }
                this.handler2.setBody(null, this.handler1.body());
                this.handler1.setBody(null, DragonBody.getRandom(null, this.handler1.species()));
                if (this.animation1 >= this.animations.length) {
                    this.animation1 = 0;
                }
                if (this.animation2 >= this.animations.length) {
                    this.animation2 = 0;
                }
            }
        }
        if (!this.confirmation) {
            this.children().removeIf(s -> s == this.confirmComponent);
            this.renderables.removeIf(s -> s == this.renderButton);
        }
        for (Renderable btn : this.renderables) {
            AltarTypeButton button;
            if (btn instanceof AltarTypeButton && (button = (AltarTypeButton)btn).isHovered()) {
                Object entity2;
                Object entity1;
                Holder<DragonSpecies> handler1PreviousSpecies = this.handler1.species();
                Holder<DragonSpecies> handler2PreviousSpecies = this.handler2.species();
                Holder<DragonSpecies> species = button.speciesEntry != null ? button.speciesEntry.species() : null;
                this.handler1.setSpecies(null, species);
                this.handler2.setSpecies(null, species);
                if (this.handler1.species() != null && !DragonUtils.isSpecies(this.handler1.species(), handler1PreviousSpecies)) {
                    this.initializeHandler(this.handler1);
                }
                if (this.handler2.species() != null && !DragonUtils.isSpecies(this.handler2.species(), handler2PreviousSpecies)) {
                    this.initializeHandler(this.handler2);
                }
                FakeClientPlayerUtils.getFakePlayer((int)0, (DragonStateHandler)this.handler1).animationSupplier = () -> this.animations[Math.min(this.animation1, this.animations.length - 1)];
                FakeClientPlayerUtils.getFakePlayer((int)1, (DragonStateHandler)this.handler2).animationSupplier = () -> this.animations[Math.min(this.animation2, this.animations.length - 1)];
                int entity1Scale = Math.clamp((long)((int)this.handler1.getGrowth()), 20, 50);
                if (this.handler1.isDragon()) {
                    Object dragon = entity1 = FakeClientPlayerUtils.getFakeDragon(0, this.handler1);
                    dragon.neckLocked = true;
                    dragon.tailLocked = true;
                } else {
                    entity1 = FakeClientPlayerUtils.getFakePlayer(0, this.handler1);
                    entity1Scale = 40;
                }
                int entity2Scale = Math.clamp((long)((int)this.handler2.getGrowth()), 20, 50);
                if (this.handler2.isDragon()) {
                    Object dragon = entity2 = FakeClientPlayerUtils.getFakeDragon(1, this.handler2);
                    dragon.neckLocked = true;
                    dragon.tailLocked = true;
                } else {
                    entity2 = FakeClientPlayerUtils.getFakePlayer(1, this.handler2);
                    entity2Scale = 40;
                }
                Quaternionf quaternion = Axis.ZP.rotationDegrees(180.0f);
                quaternion.rotateY((float)Math.toRadians(210.0));
                InventoryScreen.renderEntityInInventory((GuiGraphics)graphics, (float)((float)this.width / 2.0f - 180.0f), (float)(button.getY() + button.getHeight()), (float)entity1Scale, (Vector3f)new Vector3f(), (Quaternionf)quaternion, null, (LivingEntity)entity1);
                Quaternionf quaternion2 = Axis.ZP.rotationDegrees(180.0f);
                quaternion2.rotateY((float)Math.toRadians(150.0));
                InventoryScreen.renderEntityInInventory((GuiGraphics)graphics, (float)((float)this.width / 2.0f + 180.0f), (float)(button.getY() + button.getHeight()), (float)entity2Scale, (Vector3f)new Vector3f(), (Quaternionf)quaternion2, null, (LivingEntity)entity2);
            }
            if (this.confirmation || !(btn instanceof HoverDisableable)) continue;
            HoverDisableable hoverDisableable = (HoverDisableable)btn;
            hoverDisableable.enableHover();
        }
        TextRenderUtil.drawCenteredScaledText(graphics, this.width / 2 + 7, 10, 2.0f, Component.translatable((String)TITLE).getString(), DyeColor.WHITE.getTextColor());
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 300.0f);
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.pose().popPose();
    }

    private void initializeHandler(DragonStateHandler handler) {
        if (handler.species() == null) {
            return;
        }
        handler.setGrowth(null, ((DragonStage)((DragonSpecies)handler.species().value()).getStartingStage(null).value()).growthRange().max() - 1.0E-7);
        if (handler.body() == null) {
            handler.setBody(null, DragonBody.getRandom(null, handler.species()));
        }
        handler.setRandomValidStage(null);
        handler.getCurrentStageCustomization().defaultSkin = true;
    }

    public void renderBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.fillGradient(0, 0, this.width, this.height, -300, -1072689136, -804253680);
        DragonAltarScreen.renderBorders(guiGraphics, BACKGROUND_TEXTURE, 0, this.width, 25, this.height - 25, this.width, this.height);
    }

    public static void renderBorders(@NotNull GuiGraphics guiGraphics, ResourceLocation texture, int x0, int x1, int y0, int y1, int width, int height) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        float zLevel = 0.0f;
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        bufferbuilder.addVertex((float)x0, (float)y0, zLevel).setUv(0.0f, (float)y0 / 32.0f).setColor(64, 64, 64, 55);
        bufferbuilder.addVertex((float)(x0 + width), (float)y0, zLevel).setUv((float)width / 32.0f, (float)y0 / 32.0f).setColor(64, 64, 64, 255);
        bufferbuilder.addVertex((float)(x0 + width), 0.0f, zLevel).setUv((float)width / 32.0f, 0.0f).setColor(64, 64, 64, 255);
        bufferbuilder.addVertex((float)x0, 0.0f, zLevel).setUv(0.0f, 0.0f).setColor(64, 64, 64, 255);
        bufferbuilder.addVertex((float)x0, (float)height, zLevel).setUv(0.0f, (float)height / 32.0f).setColor(64, 64, 64, 255);
        bufferbuilder.addVertex((float)(x0 + width), (float)height, zLevel).setUv((float)width / 32.0f, (float)height / 32.0f).setColor(64, 64, 64, 255);
        bufferbuilder.addVertex((float)(x0 + width), (float)y1, zLevel).setUv((float)width / 32.0f, (float)y1 / 32.0f).setColor(64, 64, 64, 255);
        bufferbuilder.addVertex((float)x0, (float)y1, zLevel).setUv(0.0f, (float)y1 / 32.0f).setColor(64, 64, 64, 255);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        bufferbuilder.addVertex((float)x0, (float)(y0 + 4), zLevel).setUv(0.0f, 1.0f).setColor(0, 0, 0, 0);
        bufferbuilder.addVertex((float)x1, (float)(y0 + 4), zLevel).setUv(1.0f, 1.0f).setColor(0, 0, 0, 0);
        bufferbuilder.addVertex((float)x1, (float)y0, zLevel).setUv(1.0f, 0.0f).setColor(0, 0, 0, 255);
        bufferbuilder.addVertex((float)x0, (float)y0, zLevel).setUv(0.0f, 0.0f).setColor(0, 0, 0, 255);
        bufferbuilder.addVertex((float)x0, (float)y1, zLevel).setUv(0.0f, 1.0f).setColor(0, 0, 0, 255);
        bufferbuilder.addVertex((float)x1, (float)y1, zLevel).setUv(1.0f, 1.0f).setColor(0, 0, 0, 255);
        bufferbuilder.addVertex((float)x1, (float)(y1 - 4), zLevel).setUv(1.0f, 0.0f).setColor(0, 0, 0, 0);
        bufferbuilder.addVertex((float)x0, (float)(y1 - 4), zLevel).setUv(0.0f, 0.0f).setColor(0, 0, 0, 0);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    protected void init() {
        super.init();
        if (!this.hasInit) {
            this.hasInit = true;
        }
        int guiTop = (this.height - 190) / 2;
        int xPos = this.width / 2 - 104;
        HoverButton helpButton = new HoverButton(this.width / 2 - 29, 31, 65, 18, 65, 18, INFO_MAIN, INFO_HOVER, button -> {});
        helpButton.setTooltip(Tooltip.create((Component)Component.translatable((String)HELP)));
        this.addRenderableWidget((GuiEventListener)helpButton);
        List altarButtons = this.entries.stream().map(species -> new AltarTypeButton(this, (UnlockableBehavior.SpeciesEntry)species, 0, 0)).collect(Collectors.toList());
        this.humanButton = new AltarTypeButton(this, null, 0, 0){
            boolean toggled;

            @Override
            public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
                super.renderWidget(guiGraphics, mouseX, mouseY, partial);
                if (!(!this.toggled || this.visible && DragonAltarScreen.this.confirmation)) {
                    this.toggled = false;
                    Screen screen = Minecraft.getInstance().screen;
                    Objects.requireNonNull(screen).children().removeIf(s -> s == DragonAltarScreen.this.confirmComponent);
                    screen.renderables.removeIf(s -> s == DragonAltarScreen.this.renderButton);
                }
            }

            @Override
            public void onPress() {
                boolean dragonDataIsPreserved;
                DragonStateHandler handler = DragonStateProvider.getData((Player)((DragonAltarScreen)DragonAltarScreen.this).minecraft.player);
                boolean bl = dragonDataIsPreserved = ServerConfig.saveAllAbilities != false && ServerConfig.saveGrowthStage != false;
                if (handler.isDragon() && !dragonDataIsPreserved) {
                    DragonAltarScreen.this.confirmation = true;
                }
                if (DragonAltarScreen.this.confirmation) {
                    if (!this.toggled) {
                        DragonAltarScreen.this.renderButton = new ExtendedButton(0, 0, 0, 0, (Component)Component.empty(), button -> {}){

                            public void renderWidget(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                                if (DragonAltarScreen.this.confirmComponent != null && DragonAltarScreen.this.confirmation) {
                                    DragonAltarScreen.this.confirmComponent.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
                                }
                                super.renderWidget(guiGraphics, pMouseX, pMouseY, pPartialTick);
                            }
                        };
                        ((ScreenAccessor)((Object)DragonAltarScreen.this)).dragonSurvival$children().add((GuiEventListener)DragonAltarScreen.this.confirmComponent);
                        DragonAltarScreen.this.renderables.add(DragonAltarScreen.this.renderButton);
                        DragonAltarScreen.this.confirmation = true;
                    } else {
                        DragonAltarScreen.this.confirmation = false;
                    }
                } else {
                    this.initiateDragonForm(null);
                }
                this.toggled = !this.toggled;
            }
        };
        if (!ServerConfig.noHumansAllowed.booleanValue()) {
            altarButtons.add(this.humanButton);
        }
        this.scrollableComponents.add(new BarComponent(this, xPos, guiTop + 30, 4, altarButtons, 5, -13, 215, 60, 12, 19, ALTAR_ARROW_LEFT_HOVER, ALTAR_ARROW_LEFT_MAIN, ALTAR_ARROW_RIGHT_HOVER, ALTAR_ARROW_RIGHT_MAIN));
        DragonStateHandler handler = DragonStateProvider.getData((Player)this.minecraft.player);
        if (handler.isDragon()) {
            ResourceKey<DragonSpecies> species2 = handler.speciesKey();
            this.addRenderableWidget((GuiEventListener)new ExtendedButton(xPos + 32, this.height - 25, 150, 20, (Component)Component.translatable((String)LangKey.GUI_DRAGON_EDITOR), action -> ClientProxy.openDragonEditor(species2, true)));
        }
        this.confirmComponent = new DragonEditorConfirmComponent(this, this.width / 2 - 65, this.height / 2 - 90, 130, 154);
        this.confirmation = false;
    }

    @Override
    public void confirm() {
        this.humanButton.initiateDragonForm(null);
    }

    @Override
    public void cancel() {
        this.confirmation = false;
    }
}

