/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.util.uints;

import folk.sisby.surveyor.util.ArrayUtil;
import folk.sisby.surveyor.util.uints.UByte;
import folk.sisby.surveyor.util.uints.UByteArray;
import folk.sisby.surveyor.util.uints.UInt;
import folk.sisby.surveyor.util.uints.UIntArray;
import folk.sisby.surveyor.util.uints.UNibbleArray;
import folk.sisby.surveyor.util.uints.UShort;
import folk.sisby.surveyor.util.uints.UShortArray;
import java.util.Arrays;
import java.util.BitSet;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public interface UInts {
    public static final byte NULL_TYPE = 0;
    public static final int MAX_SHORT = 65535;
    public static final int MAX_BYTE = 255;
    public static final int MAX_NIBBLE = 15;
    public static final int NIBBLE_SIZE = 4;
    public static final int SHORT_MASK = 65535;
    public static final int BYTE_MASK = 255;
    public static final int NIBBLE_MASK = 15;

    public static UInts remap(UInts input, Function<Integer, Integer> remapping, int defaultValue, int cardinality) {
        return (input == null ? new UInt(defaultValue) : input).remap(remapping, defaultValue, cardinality);
    }

    public static void writeBuf(UInts array, FriendlyByteBuf buf) {
        if (array == null) {
            buf.writeVarInt(0);
            return;
        }
        buf.writeVarInt(array.getType());
        array.writeBuf(buf);
    }

    public static UInts readNbt(Tag nbt, int cardinality) {
        if (nbt == null) {
            return null;
        }
        return switch (nbt.getId()) {
            case 1 -> UByte.fromNbt(nbt);
            case 2 -> UShort.fromNbt(nbt);
            case 3 -> UInt.fromNbt(nbt);
            case 7 -> UByteArray.fromNbt(nbt, cardinality);
            case 11 -> UIntArray.fromNbt(nbt, cardinality);
            default -> throw new IllegalStateException("UIntArray encountered unexpected NBT type: " + nbt.getId());
        };
    }

    public static UInts readBuf(FriendlyByteBuf buf, int cardinality) {
        int type = buf.readVarInt();
        return switch (type) {
            case 0 -> null;
            case 1 -> UByte.fromBuf(buf);
            case 2 -> UShort.fromBuf(buf);
            case 3 -> UInt.fromBuf(buf);
            case 6 -> UNibbleArray.fromBuf(buf);
            case 7 -> UByteArray.fromBuf(buf);
            case 8 -> UShortArray.fromBuf(buf, cardinality);
            case 11 -> UIntArray.fromBuf(buf);
            default -> throw new IllegalStateException("UIntArray encountered unexpected buf type: " + type);
        };
    }

    public static UInts fromUInts(int[] uints, int defaultValue) {
        return ArrayUtil.isSingle(uints) ? UInts.ofSingle(uints[0], defaultValue) : UInts.ofMany(uints);
    }

    public static UInts ofMany(int[] uints) {
        int max = Arrays.stream(uints).max().orElseThrow();
        if (max <= 15) {
            return UNibbleArray.ofInts(uints);
        }
        if (max <= 255) {
            return UByteArray.ofInts(uints);
        }
        if (max <= 65535) {
            return UShortArray.ofInts(uints);
        }
        return UIntArray.ofInts(uints);
    }

    public static UInts ofSingle(int uint, int defaultValue) {
        if (uint == defaultValue) {
            return null;
        }
        if (uint <= 255) {
            return UByte.ofInt(uint);
        }
        if (uint <= 65535) {
            return UShort.ofInt(uint);
        }
        return UInt.ofInt(uint);
    }

    public int getType();

    public int[] getUnmasked(BitSet var1);

    public void writeNbt(CompoundTag var1, String var2);

    public void writeBuf(FriendlyByteBuf var1);

    public int get(int var1);

    public UInts remap(Function<Integer, Integer> var1, int var2, int var3);
}

