/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.util.uints;

import folk.sisby.surveyor.util.uints.ArrayUInts;
import folk.sisby.surveyor.util.uints.UInts;
import folk.sisby.surveyor.util.uints.UShortArray;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public record UIntArray(int[] value) implements ArrayUInts
{
    public static final byte TYPE = 11;

    public static UInts ofInts(int[] ints) {
        return new UIntArray(ints);
    }

    public static UInts fromNbt(Tag nbt, int cardinality) {
        int[] value = ((IntArrayTag)nbt).getAsIntArray();
        return value.length == cardinality ? new UIntArray(value) : UShortArray.ofPacked(value, cardinality);
    }

    public static UInts fromBuf(FriendlyByteBuf buf) {
        return new UIntArray(buf.readVarIntArray());
    }

    @Override
    public int get(int i) {
        return this.value[i];
    }

    @Override
    public void writeNbt(CompoundTag nbt, String key) {
        nbt.putIntArray(key, this.value);
    }

    @Override
    public void writeBuf(FriendlyByteBuf buf) {
        buf.writeVarIntArray(this.value);
    }

    @Override
    public int getType() {
        return 11;
    }
}

