/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RaycastUtil {
    public static HitResult playerViewRaycast(ServerPlayer player, int renderDistance) {
        Vec3 cameraPos = player.getEyePosition(1.0f);
        double pitch = player.getViewXRot(1.0f);
        double phi = -pitch * 0.01745329238474369;
        int blockRadius = renderDistance << 4;
        double y = (double)blockRadius * Math.tan(phi);
        double bottom = (double)player.level().getMinBuildHeight() - cameraPos.y;
        double top = (double)player.level().getMaxBuildHeight() - cameraPos.y;
        double distance = y < bottom || y > top ? Math.abs(Mth.clamp((double)y, (double)bottom, (double)top) / Math.sin(phi)) : Math.sqrt(y * y + (double)(blockRadius * blockRadius));
        Vec3 cameraRotation = player.getViewVector(1.0f);
        Vec3 endPos = cameraPos.add(cameraRotation.x * distance, cameraRotation.y * distance, cameraRotation.z * distance);
        return (HitResult)BlockGetter.traverseBlocks((Vec3)cameraPos, (Vec3)endPos, (Object)new ClipContext(cameraPos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player), (innerContext, pos) -> {
            LevelChunk chunk = player.serverLevel().getChunkSource().getChunkNow(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
            if (chunk == null) {
                Vec3 vec3d = innerContext.getFrom().subtract(innerContext.getTo());
                return BlockHitResult.miss((Vec3)pos.getCenter(), (Direction)Direction.getNearest((double)vec3d.x, (double)vec3d.y, (double)vec3d.z), (BlockPos)pos);
            }
            BlockState blockState = chunk.getBlockState(pos);
            FluidState fluidState = blockState.getFluidState();
            Vec3 vec3d = innerContext.getFrom();
            Vec3 vec3d2 = innerContext.getTo();
            VoxelShape voxelShape = innerContext.getBlockShape(blockState, (BlockGetter)player.level(), pos);
            BlockHitResult blockHitResult = player.level().clipWithInteractionOverride(vec3d, vec3d2, pos, voxelShape, blockState);
            VoxelShape voxelShape2 = innerContext.getFluidShape(fluidState, (BlockGetter)player.level(), pos);
            BlockHitResult blockHitResult2 = voxelShape2.clip(vec3d, vec3d2, pos);
            double d = blockHitResult == null ? Double.MAX_VALUE : innerContext.getFrom().distanceToSqr(blockHitResult.getLocation());
            double e = blockHitResult2 == null ? Double.MAX_VALUE : innerContext.getFrom().distanceToSqr(blockHitResult2.getLocation());
            return d <= e ? blockHitResult : blockHitResult2;
        }, innerContext -> {
            Vec3 vec3d = innerContext.getFrom().subtract(innerContext.getTo());
            return BlockHitResult.miss((Vec3)innerContext.getTo(), (Direction)Direction.getNearest((double)vec3d.x, (double)vec3d.y, (double)vec3d.z), (BlockPos)BlockPos.containing((Position)innerContext.getTo()));
        });
    }
}

