/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.terrain;

import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.terrain.ChunkSummary;
import folk.sisby.surveyor.terrain.RegionSummary;
import folk.sisby.surveyor.util.ChunkUtil;
import folk.sisby.surveyor.util.RegistryPalette;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;

public class WorldTerrainSummary {
    protected final ResourceKey<Level> worldKey;
    protected final RegistryAccess registryManager;
    protected final Map<ChunkPos, RegionSummary> regions = new ConcurrentHashMap<ChunkPos, RegionSummary>();

    public WorldTerrainSummary(ResourceKey<Level> worldKey, RegistryAccess registryManager, Map<ChunkPos, RegionSummary> regions) {
        this.worldKey = worldKey;
        this.registryManager = registryManager;
        this.regions.putAll(regions);
    }

    protected static ChunkPos regionPosOf(ChunkPos pos) {
        return new ChunkPos(pos.x >> 5, pos.z >> 5);
    }

    public static Set<ChunkPos> toKeys(Map<ChunkPos, BitSet> bitSets) {
        return WorldTerrainSummary.toKeys(bitSets, Comparator.comparingInt(pos -> pos.x + pos.z));
    }

    public static Set<ChunkPos> toKeys(Map<ChunkPos, BitSet> bitSets, ChunkPos originChunk) {
        ChunkPos oPos = new ChunkPos(RegionSummary.chunkToRegion(originChunk.x), RegionSummary.chunkToRegion(originChunk.z));
        return WorldTerrainSummary.toKeys(bitSets, Comparator.comparingDouble(pos -> (oPos.x - pos.x) * (oPos.x - pos.x) + (oPos.z - pos.z) * (oPos.z - pos.z)));
    }

    public static Set<ChunkPos> toKeys(Map<ChunkPos, BitSet> bitSets, Comparator<ChunkPos> regionComparator) {
        LinkedHashSet<ChunkPos> set = new LinkedHashSet<ChunkPos>();
        bitSets.entrySet().stream().sorted(Map.Entry.comparingByKey(regionComparator)).forEach(e -> ((BitSet)e.getValue()).stream().forEach(i -> set.add(RegionSummary.chunkForBit((ChunkPos)e.getKey(), i))));
        return set;
    }

    public static WorldTerrainSummary load(Level world, File folder) {
        HashMap<ChunkPos, RegionSummary> regions = new HashMap<ChunkPos, RegionSummary>();
        ChunkUtil.getRegionNbt(folder, "c").forEach((pos, nbt) -> regions.put((ChunkPos)pos, RegionSummary.readNbt(nbt, world.registryAccess(), pos)));
        return new WorldTerrainSummary((ResourceKey<Level>)world.dimension(), world.registryAccess(), regions);
    }

    public static void onChunkLoad(Level world, LevelChunk chunk) {
        WorldSummary summary = WorldSummary.of(world);
        if (!(summary.terrain() == null || summary.terrain().contains(chunk.getPos()) && ChunkUtil.airCount((ChunkAccess)chunk).equals(summary.terrain().get(chunk.getPos()).getAirCount()))) {
            summary.terrain().put(world, chunk);
        }
    }

    public static void onChunkUnload(Level world, LevelChunk chunk) {
        WorldSummary summary = WorldSummary.of(world);
        if (summary.terrain() != null && chunk.isUnsaved()) {
            summary.terrain().put(world, chunk);
        }
    }

    public boolean contains(ChunkPos pos) {
        ChunkPos regionPos = WorldTerrainSummary.regionPosOf(pos);
        return this.regions.containsKey(regionPos) && this.regions.get(regionPos).contains(pos);
    }

    public ChunkSummary get(ChunkPos pos) {
        ChunkPos regionPos = WorldTerrainSummary.regionPosOf(pos);
        return this.regions.containsKey(regionPos) ? this.regions.get(regionPos).get(pos) : null;
    }

    public RegionSummary getRegion(ChunkPos regionPos) {
        return this.regions.computeIfAbsent(regionPos, k -> new RegionSummary(this.registryManager));
    }

    public RegistryPalette.ValueView getBiomePalette(ChunkPos pos) {
        ChunkPos regionPos = WorldTerrainSummary.regionPosOf(pos);
        return this.regions.get(regionPos).getBiomePalette();
    }

    public RegistryPalette.ValueView getBlockPalette(ChunkPos pos) {
        ChunkPos regionPos = WorldTerrainSummary.regionPosOf(pos);
        return this.regions.get(regionPos).getBlockPalette();
    }

    public Map<ChunkPos, BitSet> bitSet(SurveyorExploration exploration) {
        HashMap<ChunkPos, BitSet> map = new HashMap<ChunkPos, BitSet>();
        this.regions.forEach((p, r) -> map.put((ChunkPos)p, r.bitSet()));
        return exploration == null ? map : exploration.limitTerrainBitset(this.worldKey, map);
    }

    public void put(Level world, LevelChunk chunk) {
        if (Surveyor.CONFIG.terrain == SystemMode.FROZEN) {
            return;
        }
        this.regions.computeIfAbsent(WorldTerrainSummary.regionPosOf(chunk.getPos()), k -> new RegionSummary(this.registryManager)).putChunk(world, chunk);
        SurveyorEvents.Invoke.terrainUpdated(world, chunk.getPos());
    }

    public int save(Level world, File folder) {
        ArrayList savedRegions = new ArrayList();
        this.regions.forEach((pos, summary) -> {
            if (!summary.isDirty()) {
                return;
            }
            savedRegions.add(pos);
            CompoundTag regionCompound = summary.writeNbt(world.registryAccess(), new CompoundTag(), (ChunkPos)pos);
            File regionFile = new File(folder, "c.%d.%d.dat".formatted(pos.x, pos.z));
            try {
                NbtIo.writeCompressed((CompoundTag)regionCompound, (Path)regionFile.toPath());
                summary.dirty = false;
            }
            catch (IOException e) {
                Surveyor.LOGGER.error("[Surveyor] Error writing region summary file {}.", (Object)regionFile.getName(), (Object)e);
            }
        });
        return savedRegions.size();
    }

    public boolean isDirty() {
        return this.regions.values().stream().anyMatch(RegionSummary::isDirty);
    }
}

