/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.terrain;

import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PalettedContainer;

public record SectionSummary(Palette<BlockState> blockPalette, int[] blockIndices, Palette<Holder<Biome>> biomePalette, int[] biomeIndices) {
    public static SectionSummary ofSection(LevelChunkSection section) {
        if (section.hasOnlyAir()) {
            return null;
        }
        int[] blockIndices = new int[PalettedContainer.Strategy.SECTION_STATES.size()];
        section.getStates().data.storage.unpack(blockIndices);
        int[] biomeIndices = new int[PalettedContainer.Strategy.SECTION_BIOMES.size()];
        ((PalettedContainer)section.getBiomes()).data.storage.unpack(biomeIndices);
        return new SectionSummary((Palette<BlockState>)section.getStates().data.palette, blockIndices, (Palette<Holder<Biome>>)((PalettedContainer)section.getBiomes()).data.palette, biomeIndices);
    }

    public BlockState getBlockState(int relativeX, int y, int relativeZ) {
        return (BlockState)this.blockPalette().valueFor(this.blockIndices()[PalettedContainer.Strategy.SECTION_STATES.getIndex(relativeX, y & 0xF, relativeZ)]);
    }

    public Holder<Biome> getBiomeEntry(int relativeX, int y, int relativeZ, int bottomY, int topY) {
        return (Holder)this.biomePalette().valueFor(this.biomeIndices()[PalettedContainer.Strategy.SECTION_BIOMES.getIndex(QuartPos.fromBlock((int)relativeX) & 3, Mth.clamp((int)QuartPos.fromBlock((int)y), (int)QuartPos.fromBlock((int)bottomY), (int)(QuartPos.fromBlock((int)topY) - 1)) & 3, QuartPos.fromBlock((int)relativeZ) & 3)]);
    }
}

