/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.terrain;

import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.packet.S2CUpdateRegionPacket;
import folk.sisby.surveyor.terrain.ChunkSummary;
import folk.sisby.surveyor.terrain.DimensionSupport;
import folk.sisby.surveyor.util.RegistryPalette;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.LevelChunk;

public class RegionSummary {
    public static final int REGION_POWER = 5;
    public static final int REGION_SIZE = 32;
    public static final int BITSET_SIZE = 1024;
    public static final String KEY_BIOMES = "biomes";
    public static final String KEY_BLOCKS = "blocks";
    public static final String KEY_BIOME_WATER = "biomeWater";
    public static final String KEY_BIOME_FOLIAGE = "biomeFoliage";
    public static final String KEY_BIOME_GRASS = "biomeGrass";
    public static final String KEY_BLOCK_COLORS = "blockColors";
    public static final String KEY_CHUNKS = "chunks";
    protected final RegistryPalette<Biome> biomePalette;
    protected final RegistryPalette<Block> blockPalette;
    protected final ChunkSummary[][] chunks = new ChunkSummary[32][32];
    protected boolean dirty = false;

    public RegionSummary(RegistryAccess manager) {
        this.biomePalette = new RegistryPalette(manager.registryOrThrow(Registries.BIOME));
        this.blockPalette = new RegistryPalette(manager.registryOrThrow(Registries.BLOCK));
    }

    public static <T, O> List<O> mapIterable(Iterable<T> palette, Function<T, O> mapper) {
        ArrayList<O> list = new ArrayList<O>();
        for (T value : palette) {
            list.add(mapper.apply(value));
        }
        return list;
    }

    public static int regionToChunk(int xz) {
        return xz << 5;
    }

    public static int chunkToRegion(int xz) {
        return xz >> 5;
    }

    public static int regionRelative(int xz) {
        return xz & 0x1F;
    }

    public static int bitForXZ(int x, int z) {
        return (x << 5) + z;
    }

    public static int bitForChunk(ChunkPos pos) {
        return RegionSummary.bitForXZ(RegionSummary.regionRelative(pos.x), RegionSummary.regionRelative(pos.z));
    }

    public static int xForBit(int i) {
        return i >> 5;
    }

    public static int zForBit(int i) {
        return i & 0x1F;
    }

    public static ChunkPos chunkForBit(ChunkPos rPos, int i) {
        return new ChunkPos(RegionSummary.regionToChunk(rPos.x) + RegionSummary.xForBit(i), RegionSummary.regionToChunk(rPos.z) + RegionSummary.zForBit(i));
    }

    public static RegionSummary readNbt(CompoundTag nbt, RegistryAccess manager, ChunkPos pos) {
        RegionSummary summary = new RegionSummary(manager);
        Registry biomeRegistry = manager.registryOrThrow(Registries.BIOME);
        Registry blockRegistry = manager.registryOrThrow(Registries.BLOCK);
        ListTag biomeList = nbt.getList(KEY_BIOMES, 8);
        Int2IntArrayMap biomeRemap = new Int2IntArrayMap(biomeList.size());
        for (int i = 0; i < biomeList.size(); ++i) {
            ResourceLocation biomeId = ResourceLocation.tryParse((String)biomeList.get(i).getAsString());
            Biome biome = (Biome)biomeRegistry.get(biomeId);
            Biome newBiome = biome == null ? (Biome)biomeRegistry.get(Biomes.THE_VOID) : biome;
            int newIndex = summary.biomePalette.findOrAdd(newBiome);
            if (biome != null && newIndex == i) continue;
            Surveyor.LOGGER.warn("[Surveyor] Remapping biome palette in region {}: {} (#{}) is now {} (#{})", new Object[]{pos, biomeId, i, biomeRegistry.getKey((Object)newBiome), newIndex});
            biomeRemap.put(i, newIndex);
            summary.dirty();
        }
        ListTag blockList = nbt.getList(KEY_BLOCKS, 8);
        Int2IntArrayMap blockRemap = new Int2IntArrayMap(blockList.size());
        for (int i = 0; i < blockList.size(); ++i) {
            ResourceLocation blockId = ResourceLocation.tryParse((String)blockList.get(i).getAsString());
            Block block = (Block)blockRegistry.get(blockId);
            Block newBlock = block == null ? Blocks.AIR : block;
            int newIndex = summary.blockPalette.findOrAdd(newBlock);
            if (block != null && newIndex == i) continue;
            Surveyor.LOGGER.warn("[Surveyor] Remapping block palette in region {}: {} (#{}) is now {} (#{})", new Object[]{pos, blockList.get(i).getAsString(), i, blockRegistry.getKey((Object)newBlock), newIndex});
            blockRemap.put(i, newIndex);
            summary.dirty();
        }
        CompoundTag chunksCompound = nbt.getCompound(KEY_CHUNKS);
        for (String posKey : chunksCompound.getAllKeys()) {
            int x = RegionSummary.regionRelative(Integer.parseInt(posKey.split(",")[0]));
            int z = RegionSummary.regionRelative(Integer.parseInt(posKey.split(",")[1]));
            summary.chunks[x][z] = new ChunkSummary(chunksCompound.getCompound(posKey));
            if (biomeRemap.isEmpty() && blockRemap.isEmpty()) continue;
            summary.chunks[x][z].remap((Map<Integer, Integer>)biomeRemap, (Map<Integer, Integer>)blockRemap);
        }
        return summary;
    }

    public boolean contains(ChunkPos pos) {
        return this.chunks[RegionSummary.regionRelative(pos.x)][RegionSummary.regionRelative(pos.z)] != null;
    }

    public ChunkSummary get(ChunkPos pos) {
        return this.chunks[RegionSummary.regionRelative(pos.x)][RegionSummary.regionRelative(pos.z)];
    }

    public BitSet bitSet() {
        BitSet bitSet = new BitSet(1024);
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                if (this.chunks[x][z] == null) continue;
                bitSet.set(RegionSummary.bitForXZ(x, z));
            }
        }
        return bitSet;
    }

    public void putChunk(Level world, LevelChunk chunk) {
        if (Surveyor.CONFIG.terrain == SystemMode.FROZEN) {
            return;
        }
        if (world.getHeight() == 0) {
            return;
        }
        this.chunks[RegionSummary.regionRelative((int)chunk.getPos().x)][RegionSummary.regionRelative((int)chunk.getPos().z)] = new ChunkSummary(world, chunk, DimensionSupport.getSummaryLayers(world), this.biomePalette, this.blockPalette, !(world instanceof ServerLevel));
        this.dirty();
    }

    public CompoundTag writeNbt(RegistryAccess manager, CompoundTag nbt, ChunkPos regionPos) {
        Registry biomeRegistry = manager.registryOrThrow(Registries.BIOME);
        Registry blockRegistry = manager.registryOrThrow(Registries.BLOCK);
        nbt.put(KEY_BIOMES, (Tag)new ListTag(RegionSummary.mapIterable(this.biomePalette.view(), b -> StringTag.valueOf((String)biomeRegistry.getKey(b).toString())), 8));
        nbt.put(KEY_BLOCKS, (Tag)new ListTag(RegionSummary.mapIterable(this.blockPalette.view(), b -> StringTag.valueOf((String)blockRegistry.getKey(b).toString())), 8));
        nbt.putIntArray(KEY_BIOME_WATER, RegionSummary.mapIterable(this.biomePalette.view(), Biome::getWaterColor));
        nbt.putIntArray(KEY_BIOME_FOLIAGE, RegionSummary.mapIterable(this.biomePalette.view(), Biome::getFoliageColor));
        nbt.putIntArray(KEY_BIOME_GRASS, RegionSummary.mapIterable(this.biomePalette.view(), b -> b.getGrassColor(0.0, 0.0)));
        nbt.putIntArray(KEY_BLOCK_COLORS, RegionSummary.mapIterable(this.blockPalette.view(), b -> b.defaultMapColor().col));
        CompoundTag chunksCompound = new CompoundTag();
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                if (this.chunks[x][z] == null) continue;
                chunksCompound.put("%s,%s".formatted((regionPos.x << 5) + x, (regionPos.z << 5) + z), (Tag)this.chunks[x][z].writeNbt(new CompoundTag()));
            }
        }
        nbt.put(KEY_CHUNKS, (Tag)chunksCompound);
        return nbt;
    }

    public BitSet readUpdatePacket(RegistryAccess manager, S2CUpdateRegionPacket packet) {
        if (Surveyor.CONFIG.terrain == SystemMode.FROZEN) {
            return new BitSet();
        }
        Int2IntArrayMap biomeRemap = new Int2IntArrayMap();
        for (int i = 0; i < packet.biomePalette().size(); ++i) {
            biomeRemap.put(i, this.biomePalette.findOrAdd(packet.biomePalette().get(i)));
        }
        Int2IntArrayMap blockRemap = new Int2IntArrayMap();
        for (int i = 0; i < packet.blockPalette().size(); ++i) {
            blockRemap.put(i, this.blockPalette.findOrAdd(packet.blockPalette().get(i)));
        }
        int[] indices = packet.set().stream().toArray();
        for (int i = 0; i < packet.chunks().size(); ++i) {
            ChunkSummary summary = packet.chunks().get(i);
            summary.remap((Map<Integer, Integer>)biomeRemap, (Map<Integer, Integer>)blockRemap);
            this.chunks[RegionSummary.xForBit((int)indices[i])][RegionSummary.zForBit((int)indices[i])] = summary;
        }
        this.dirty();
        return packet.set();
    }

    public S2CUpdateRegionPacket createUpdatePacket(boolean shared, ChunkPos rPos, BitSet set) {
        return new S2CUpdateRegionPacket(shared, rPos, RegionSummary.mapIterable(this.biomePalette, i -> i), RegionSummary.mapIterable(this.blockPalette, i -> i), set, set.stream().mapToObj(i -> this.chunks[RegionSummary.xForBit(i)][RegionSummary.zForBit(i)]).toList());
    }

    public RegistryPalette.ValueView getBiomePalette() {
        return this.biomePalette.view();
    }

    public RegistryPalette.ValueView getBlockPalette() {
        return this.blockPalette.view();
    }

    public boolean isDirty() {
        return this.dirty && Surveyor.CONFIG.terrain != SystemMode.FROZEN;
    }

    private void dirty() {
        this.dirty = true;
    }
}

