/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.terrain;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;

public class DimensionSupport {
    public static final Map<ResourceKey<Level>, int[]> cache = new HashMap<ResourceKey<Level>, int[]>();

    private static void softAdd(DimensionType dimension, List<Integer> layers, int y) {
        if (dimension.minY() < y && y < dimension.minY() + dimension.height()) {
            layers.add(y);
        }
    }

    private static int[] getSummaryLayersInternal(Level world) {
        ArrayList<Integer> layers = new ArrayList<Integer>();
        DimensionType dimension = world.dimensionType();
        layers.add(dimension.minY() + dimension.height() - 1);
        if (dimension.logicalHeight() != dimension.height()) {
            DimensionSupport.softAdd(dimension, layers, dimension.minY() + dimension.logicalHeight() - 2);
        }
        if (dimension.minY() + dimension.height() > 256) {
            DimensionSupport.softAdd(dimension, layers, 256);
        }
        if (dimension.hasSkyLight()) {
            DimensionSupport.softAdd(dimension, layers, world.getSeaLevel() - 2);
        }
        if (dimension.minY() < 0) {
            DimensionSupport.softAdd(dimension, layers, 0);
        }
        if (world.dimensionTypeRegistration().unwrapKey().orElseThrow() == BuiltinDimensionTypes.NETHER) {
            DimensionSupport.softAdd(dimension, layers, 70);
            DimensionSupport.softAdd(dimension, layers, 40);
        }
        layers.add(dimension.minY());
        layers.sort(Comparator.comparingInt(i -> i).reversed());
        int[] outLayers = new int[layers.size()];
        for (int i2 = 0; i2 < outLayers.length; ++i2) {
            outLayers[i2] = (Integer)layers.get(i2);
        }
        return outLayers;
    }

    public static int[] getSummaryLayers(Level world) {
        return cache.computeIfAbsent((ResourceKey<Level>)world.dimension(), k -> DimensionSupport.getSummaryLayersInternal(world));
    }
}

