/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.terrain;

import folk.sisby.surveyor.terrain.LayerSummary;
import folk.sisby.surveyor.terrain.SectionSummary;
import folk.sisby.surveyor.util.ChunkUtil;
import folk.sisby.surveyor.util.RegistryPalette;
import folk.sisby.surveyor.util.uints.UInts;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.Nullable;

public class ChunkSummary {
    public static final int MINIMUM_AIR_DEPTH = 2;
    public static final String KEY_AIR_COUNT = "air";
    public static final String KEY_LAYERS = "layers";
    protected final Integer airCount;
    protected final TreeMap<Integer, @Nullable LayerSummary> layers = new TreeMap();

    public ChunkSummary(Level world, LevelChunk chunk, int[] layerHeights, RegistryPalette<Biome> biomePalette, RegistryPalette<Block> blockPalette, boolean countAir) {
        this.airCount = countAir ? ChunkUtil.airCount((ChunkAccess)chunk) : null;
        LayerSummary.FloorSummary[][] layerFloors = new LayerSummary.FloorSummary[layerHeights.length - 1][256];
        LevelChunkSection[] rawSections = chunk.getSections();
        SectionSummary[] sections = new SectionSummary[rawSections.length];
        for (int i = 0; i < rawSections.length; ++i) {
            sections[i] = SectionSummary.ofSection(rawSections[i]);
        }
        int chunkX = chunk.getPos().getMinBlockX();
        int chunkZ = chunk.getPos().getMinBlockZ();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int walkspaceHeight = 2;
                int waterDepth = 0;
                Block carpetBlock = null;
                BlockPos carpetPos = new BlockPos(chunkX + x, Integer.MAX_VALUE, chunkZ + z);
                for (int layerIndex = 0; layerIndex < layerHeights.length - 1; ++layerIndex) {
                    LayerSummary.FloorSummary foundFloor = null;
                    for (int y = layerHeights[layerIndex]; y > layerHeights[layerIndex + 1]; --y) {
                        int sectionIndex = chunk.getSectionIndex(y);
                        SectionSummary section = sections[sectionIndex];
                        if (section == null) {
                            int sectionBottom = SectionPos.sectionToBlockCoord((int)chunk.getSectionYFromSectionIndex(sectionIndex));
                            walkspaceHeight += y - sectionBottom + 1;
                            waterDepth = 0;
                            y = sectionBottom;
                            continue;
                        }
                        BlockPos pos = new BlockPos(chunkX + x, y, chunkZ + z);
                        BlockState state = section.getBlockState(x, y, z);
                        Fluid fluid = state.getFluidState().getType();
                        if (!state.blocksMotion() && fluid.isSame(Fluids.EMPTY)) {
                            waterDepth = 0;
                            if (++walkspaceHeight < 2 || state.getMapColor((BlockGetter)world, pos) == MapColor.NONE) continue;
                            carpetPos = pos;
                            carpetBlock = state.getBlock();
                            continue;
                        }
                        if (fluid.isSame((Fluid)Fluids.WATER) || fluid.isSame((Fluid)Fluids.FLOWING_WATER)) {
                            ++waterDepth;
                            continue;
                        }
                        if (foundFloor == null) {
                            if (carpetPos.getY() == y + 1) {
                                foundFloor = new LayerSummary.FloorSummary(carpetPos.getY(), biomePalette.findOrAdd((Biome)section.getBiomeEntry(x, carpetPos.getY(), z, world.getMinBuildHeight(), world.getMaxBuildHeight()).value()), blockPalette.findOrAdd(carpetBlock), world.getBrightness(LightLayer.BLOCK, carpetPos), waterDepth, waterDepth == 0 ? 0 : world.getBrightness(LightLayer.BLOCK, pos.above().above(waterDepth)));
                                if (carpetPos.getY() > layerHeights[layerIndex]) {
                                    if (layerFloors[layerIndex - 1][x * 16 + z] == null) {
                                        layerFloors[layerIndex - 1][x * 16 + z] = foundFloor;
                                    }
                                    foundFloor = null;
                                }
                                walkspaceHeight = 0;
                                waterDepth = 0;
                            } else if (walkspaceHeight >= 2 && state.getMapColor((BlockGetter)world, pos) != MapColor.NONE) {
                                foundFloor = new LayerSummary.FloorSummary(y, biomePalette.findOrAdd((Biome)section.getBiomeEntry(x, y, z, world.getMinBuildHeight(), world.getMaxBuildHeight()).value()), blockPalette.findOrAdd(state.getBlock()), world.getBrightness(LightLayer.BLOCK, pos.above()), waterDepth, waterDepth == 0 ? 0 : world.getBrightness(LightLayer.BLOCK, pos.above().above(waterDepth)));
                            }
                        }
                        if (state.getMapColor((BlockGetter)world, pos) == MapColor.NONE) continue;
                        walkspaceHeight = 0;
                        waterDepth = 0;
                    }
                    layerFloors[layerIndex][x * 16 + z] = foundFloor;
                }
            }
        }
        for (int i = 0; i < layerFloors.length; ++i) {
            this.layers.put(layerHeights[i], LayerSummary.fromSummaries(layerFloors[i], layerHeights[i]));
        }
    }

    public ChunkSummary(CompoundTag nbt) {
        this.airCount = nbt.contains(KEY_AIR_COUNT) ? Integer.valueOf(nbt.getInt(KEY_AIR_COUNT)) : null;
        CompoundTag layersCompound = nbt.getCompound(KEY_LAYERS);
        for (String key : layersCompound.getAllKeys()) {
            int layerY = Integer.parseInt(key);
            this.layers.put(layerY, LayerSummary.fromNbt(layersCompound.getCompound(key)));
        }
    }

    public ChunkSummary(FriendlyByteBuf buf) {
        this.layers.putAll(buf.readMap(FriendlyByteBuf::readVarInt, b -> {
            if (b.readByte() == 0) {
                return null;
            }
            return LayerSummary.fromBuf(buf);
        }));
        this.airCount = -1;
    }

    public CompoundTag writeNbt(CompoundTag nbt) {
        if (this.airCount != null) {
            nbt.putInt(KEY_AIR_COUNT, this.airCount.intValue());
        }
        CompoundTag layersCompound = new CompoundTag();
        this.layers.forEach((layerY, layerSummary) -> {
            CompoundTag layerCompound = new CompoundTag();
            if (layerSummary != null) {
                layerSummary.writeNbt(layerCompound);
            }
            layersCompound.put(String.valueOf(layerY), (Tag)layerCompound);
        });
        nbt.put(KEY_LAYERS, (Tag)layersCompound);
        return nbt;
    }

    public void writeBuf(FriendlyByteBuf buf) {
        buf.writeMap(this.layers, FriendlyByteBuf::writeVarInt, (b, summary) -> {
            if (summary == null) {
                b.writeByte(0);
            } else {
                b.writeByte(1);
                summary.writeBuf(buf);
            }
        });
    }

    public void remap(Map<Integer, Integer> biomeRemap, Map<Integer, Integer> blockRemap) {
        HashMap newLayers = new HashMap();
        this.layers.forEach((y, layer) -> newLayers.put(y, layer == null ? null : new LayerSummary(layer.found, layer.depth, UInts.remap(layer.biome, biomeRemap::get, 0, layer.found.cardinality()), UInts.remap(layer.block, blockRemap::get, 0, layer.found.cardinality()), layer.light, layer.water, layer.glint)));
        this.layers.clear();
        this.layers.putAll(newLayers);
    }

    public Integer getAirCount() {
        return this.airCount;
    }

    @Nullable
    public LayerSummary.Raw toSingleLayer(Integer minY, Integer maxY, int worldHeight) {
        LayerSummary.Raw outRaw = new LayerSummary.Raw(new BitSet(256), new int[256], new int[256], new int[256], new int[256], new int[256], new int[256]);
        this.layers.descendingMap().forEach((y, layer) -> {
            if (layer != null) {
                layer.fillEmptyFloors(worldHeight - y, maxY == null ? Integer.MIN_VALUE : y - maxY, minY == null ? Integer.MAX_VALUE : y - minY, outRaw);
            }
        });
        return outRaw.exists().cardinality() == 0 ? null : outRaw;
    }
}

