/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.structure;

import com.google.common.collect.Multimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.structure.JigsawPieceSummary;
import folk.sisby.surveyor.structure.StructurePieceSummary;
import folk.sisby.surveyor.structure.StructureStartSummary;
import folk.sisby.surveyor.util.MapUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class RegionStructureSummary {
    public static final String KEY_STRUCTURES = "structures";
    public static final String KEY_STARTS = "starts";
    public static final String KEY_PIECES = "pieces";
    protected final Map<ResourceKey<Structure>, Map<ChunkPos, StructureStartSummary>> structures = new ConcurrentHashMap<ResourceKey<Structure>, Map<ChunkPos, StructureStartSummary>>();
    protected boolean dirty = false;

    RegionStructureSummary() {
    }

    RegionStructureSummary(Map<ResourceKey<Structure>, Map<ChunkPos, StructureStartSummary>> structures) {
        this.structures.putAll(structures);
    }

    protected static StructureStartSummary summarisePieces(StructurePieceSerializationContext context, StructureStart start) {
        ArrayList<StructurePieceSummary> pieces = new ArrayList<StructurePieceSummary>();
        for (StructurePiece piece : start.getPieces()) {
            if (piece.getType().equals((Object)StructurePieceType.JIGSAW)) {
                pieces.addAll(JigsawPieceSummary.tryFromPiece(piece));
                continue;
            }
            pieces.add(StructurePieceSummary.fromPiece(context, piece, start.getPieces().size() <= 10));
        }
        return new StructureStartSummary(pieces);
    }

    public static StructurePieceSummary readStructurePieceNbt(CompoundTag nbt) {
        if (nbt.getString("id").equals(BuiltInRegistries.STRUCTURE_PIECE.getKey((Object)StructurePieceType.JIGSAW).toString())) {
            return new JigsawPieceSummary(nbt);
        }
        return new StructurePieceSummary(nbt);
    }

    protected static RegionStructureSummary readNbt(CompoundTag nbt) {
        ConcurrentHashMap<ResourceKey<Structure>, Map<ChunkPos, StructureStartSummary>> structures = new ConcurrentHashMap<ResourceKey<Structure>, Map<ChunkPos, StructureStartSummary>>();
        CompoundTag structuresCompound = nbt.getCompound(KEY_STRUCTURES);
        for (String structureId : structuresCompound.getAllKeys()) {
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.parse((String)structureId));
            CompoundTag structureCompound = structuresCompound.getCompound(structureId);
            CompoundTag startsCompound = structureCompound.getCompound(KEY_STARTS);
            for (String posKey : startsCompound.getAllKeys()) {
                int x = Integer.parseInt(posKey.split(",")[0]);
                int z = Integer.parseInt(posKey.split(",")[1]);
                CompoundTag startCompound = startsCompound.getCompound(posKey);
                ArrayList<StructurePieceSummary> pieces = new ArrayList<StructurePieceSummary>();
                for (Tag pieceElement : startCompound.getList(KEY_PIECES, 10)) {
                    pieces.add(RegionStructureSummary.readStructurePieceNbt((CompoundTag)pieceElement));
                }
                structures.computeIfAbsent((ResourceKey<Structure>)key, p -> new ConcurrentHashMap()).put(new ChunkPos(x, z), new StructureStartSummary(pieces));
            }
        }
        return new RegionStructureSummary(structures);
    }

    public boolean contains(Level world, StructureStart start) {
        ResourceKey key = world.registryAccess().registryOrThrow(Registries.STRUCTURE).getResourceKey((Object)start.getStructure()).orElse(null);
        if (key == null) {
            Surveyor.LOGGER.error("Encountered an unregistered structure! {} | {}", (Object)start, (Object)start.getStructure());
            return true;
        }
        return this.structures.containsKey(key) && this.structures.get(key).containsKey(start.getChunkPos());
    }

    public boolean contains(ResourceKey<Structure> key, ChunkPos pos) {
        return this.structures.containsKey(key) && this.structures.get(key).containsKey(pos);
    }

    public StructureStartSummary get(ResourceKey<Structure> key, ChunkPos pos) {
        return this.structures.get(key).get(pos);
    }

    public Multimap<ResourceKey<Structure>, ChunkPos> keySet() {
        return MapUtil.keyMultiMap(this.structures);
    }

    public void put(ServerLevel world, StructureStart start) {
        ResourceKey key = (ResourceKey)world.registryAccess().registryOrThrow(Registries.STRUCTURE).getResourceKey((Object)start.getStructure()).orElseThrow();
        this.structures.computeIfAbsent((ResourceKey<Structure>)key, k -> new ConcurrentHashMap());
        ChunkPos pos = start.getChunkPos();
        StructureStartSummary summary = RegionStructureSummary.summarisePieces(StructurePieceSerializationContext.fromLevel((ServerLevel)world), start);
        this.structures.get(key).put(pos, summary);
        this.dirty();
    }

    public void put(ResourceKey<Structure> key, ChunkPos pos, StructureStartSummary summary) {
        this.structures.computeIfAbsent(key, k -> new ConcurrentHashMap()).put(pos, summary);
        this.dirty();
    }

    protected CompoundTag writeNbt(CompoundTag nbt) {
        CompoundTag structuresCompound = new CompoundTag();
        this.structures.forEach((key, starts) -> {
            CompoundTag structureCompound = new CompoundTag();
            CompoundTag startsCompound = new CompoundTag();
            starts.forEach((pos, summary) -> {
                ListTag pieceList = new ListTag(summary.getChildren().stream().map(p -> p.toNbt()).toList(), 10);
                CompoundTag startCompound = new CompoundTag();
                startCompound.put(KEY_PIECES, (Tag)pieceList);
                startsCompound.put("%s,%s".formatted(pos.x, pos.z), (Tag)startCompound);
            });
            structureCompound.put(KEY_STARTS, (Tag)startsCompound);
            structuresCompound.put(key.location().toString(), (Tag)structureCompound);
        });
        nbt.put(KEY_STRUCTURES, (Tag)structuresCompound);
        return nbt;
    }

    public boolean isDirty() {
        return this.dirty && Surveyor.CONFIG.structures != SystemMode.FROZEN;
    }

    private void dirty() {
        this.dirty = true;
    }
}

