/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.structure;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import folk.sisby.surveyor.structure.StructurePieceSummary;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.FeaturePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.ListPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class JigsawPieceSummary
extends StructurePieceSummary {
    public static final String KEY_POS = "pos";
    public static final String KEY_DELTA_Y = "deltaY";
    public static final String KEY_ROTATION = "rotation";
    public static final String KEY_JUNCTIONS = "junctions";
    public static final BiMap<String, StructurePoolElementType<?>> TYPE_KEYS = HashBiMap.create(Map.of("single", StructurePoolElementType.SINGLE, "feature", StructurePoolElementType.FEATURE));
    protected final BlockPos pos;
    protected final int deltaY;
    protected final Rotation rotation;
    protected final List<JigsawJunction> junctions;
    protected final StructurePoolElementType<?> elementType;
    protected final ResourceLocation id;

    public JigsawPieceSummary(BlockPos pos, int deltaY, Rotation rotation, StructurePoolElementType<?> elementType, ResourceLocation id, int chainLength, BoundingBox boundingBox, List<JigsawJunction> junctions) {
        super(StructurePieceType.JIGSAW, chainLength, boundingBox, new CompoundTag());
        this.pos = pos;
        this.deltaY = deltaY;
        this.rotation = rotation;
        this.elementType = elementType;
        this.id = id;
        this.junctions = junctions;
    }

    public JigsawPieceSummary(CompoundTag nbt) {
        super(nbt);
        this.pos = BlockPos.of((long)nbt.getLong(KEY_POS));
        this.deltaY = nbt.getInt(KEY_DELTA_Y);
        this.rotation = Rotation.values()[nbt.getInt(KEY_ROTATION)];
        this.junctions = new ArrayList<JigsawJunction>();
        if (nbt.contains(KEY_JUNCTIONS)) {
            int[] junctionArray = nbt.getIntArray(KEY_JUNCTIONS);
            for (int i = 4; i <= junctionArray.length; i += 5) {
                this.junctions.add(new JigsawJunction(junctionArray[i - 4], junctionArray[i - 3], junctionArray[i - 2], junctionArray[i - 1], StructureTemplatePool.Projection.values()[junctionArray[i]]));
            }
        }
        String idKey = TYPE_KEYS.keySet().stream().filter(arg_0 -> ((CompoundTag)nbt).contains(arg_0)).findFirst().orElseThrow();
        this.elementType = (StructurePoolElementType)TYPE_KEYS.get((Object)idKey);
        this.id = ResourceLocation.parse((String)nbt.getString(idKey));
    }

    public static List<StructurePieceSummary> tryFromElement(StructurePoolElement poolElement, PoolElementStructurePiece piece) {
        if (poolElement instanceof ListPoolElement) {
            ListPoolElement listElement = (ListPoolElement)poolElement;
            ArrayList<StructurePieceSummary> allSummaries = new ArrayList<StructurePieceSummary>();
            listElement.elements.forEach(e -> allSummaries.addAll(JigsawPieceSummary.tryFromElement(e, piece)));
            return allSummaries;
        }
        if (poolElement instanceof SinglePoolElement) {
            SinglePoolElement singleElement = (SinglePoolElement)poolElement;
            if (singleElement.template.left().isPresent()) {
                return List.of(new JigsawPieceSummary(piece.getPosition(), piece.getGroundLevelDelta(), piece.getRotation(), StructurePoolElementType.SINGLE, (ResourceLocation)singleElement.template.left().orElseThrow(), piece.getGenDepth(), poolElement.getBoundingBox(piece.structureTemplateManager, piece.getPosition(), piece.getRotation()), piece.getJunctions()));
            }
        }
        if (poolElement instanceof FeaturePoolElement) {
            FeaturePoolElement featureElement = (FeaturePoolElement)poolElement;
            if (featureElement.feature.unwrapKey().isPresent()) {
                return List.of(new JigsawPieceSummary(piece.getPosition(), piece.getGroundLevelDelta(), piece.getRotation(), StructurePoolElementType.FEATURE, ((ResourceKey)featureElement.feature.unwrapKey().orElseThrow()).location(), piece.getGenDepth(), poolElement.getBoundingBox(piece.structureTemplateManager, piece.getPosition(), piece.getRotation()), piece.getJunctions()));
            }
        }
        return List.of();
    }

    public static List<StructurePieceSummary> tryFromPiece(StructurePiece piece) {
        if (piece instanceof PoolElementStructurePiece) {
            PoolElementStructurePiece poolPiece = (PoolElementStructurePiece)piece;
            return JigsawPieceSummary.tryFromElement(poolPiece.getElement(), poolPiece);
        }
        return List.of();
    }

    @Override
    public void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag nbt) {
        super.addAdditionalSaveData(context, nbt);
        nbt.putLong(KEY_POS, this.pos.asLong());
        nbt.putInt(KEY_DELTA_Y, this.deltaY);
        nbt.putInt(KEY_ROTATION, this.rotation.ordinal());
        String idKey = (String)TYPE_KEYS.inverse().get(this.elementType);
        nbt.putString(idKey, this.id.toString());
        if (!this.junctions.isEmpty()) {
            int[] junctionArray = new int[this.junctions.size() * 5];
            for (int i = 0; i < this.junctions.size(); ++i) {
                JigsawJunction j = this.junctions.get(i);
                junctionArray[i * 5] = j.getSourceX();
                junctionArray[i * 5 + 1] = j.getSourceGroundY();
                junctionArray[i * 5 + 2] = j.getSourceZ();
                junctionArray[i * 5 + 3] = j.getDeltaY();
                junctionArray[i * 5 + 4] = j.getDestProjection().ordinal();
            }
            nbt.putIntArray(KEY_JUNCTIONS, junctionArray);
        }
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getDeltaY() {
        return this.deltaY;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public StructurePoolElementType<?> getElementType() {
        return this.elementType;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<JigsawJunction> getJunctions() {
        return this.junctions;
    }
}

