/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.packet;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.packet.SurveyorPacket;
import folk.sisby.surveyor.packet.SurveyorPacketCodecs;
import folk.sisby.surveyor.packet.SyncPacket;
import folk.sisby.surveyor.util.MapUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record SyncLandmarksAddedPacket(Map<LandmarkType<?>, Map<BlockPos, Landmark<?>>> landmarks) implements SyncPacket
{
    public static final CustomPacketPayload.Type<SyncLandmarksAddedPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"surveyor", (String)"landmarks_added"));
    public static final StreamCodec<ByteBuf, SyncLandmarksAddedPacket> CODEC = SurveyorPacketCodecs.LANDMARK_SUMMARIES.map(SyncLandmarksAddedPacket::new, SyncLandmarksAddedPacket::landmarks);

    public static SyncLandmarksAddedPacket of(Multimap<LandmarkType<?>, BlockPos> keySet, WorldLandmarks summary) {
        return summary.createUpdatePacket(keySet);
    }

    @Override
    public List<SurveyorPacket> toPayloads() {
        ArrayList<SurveyorPacket> payloads = new ArrayList<SurveyorPacket>();
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        CODEC.encode((Object)buf, (Object)this);
        if (buf.readableBytes() < 0x100000) {
            payloads.add(this);
        } else {
            Multimap<LandmarkType<?>, BlockPos> keySet = MapUtil.keyMultiMap(this.landmarks);
            if (keySet.size() == 1) {
                Surveyor.LOGGER.error("Couldn't create a landmark update packet for {} at {} - an individual landmark would be too large to send!", (Object)((LandmarkType)keySet.keys().stream().findFirst().orElseThrow()).id(), keySet.values().stream().findFirst().orElseThrow());
                return List.of();
            }
            HashMultimap firstHalf = HashMultimap.create();
            HashMultimap secondHalf = HashMultimap.create();
            keySet.forEach((arg_0, arg_1) -> SyncLandmarksAddedPacket.lambda$toPayloads$0((Multimap)firstHalf, keySet, (Multimap)secondHalf, arg_0, arg_1));
            payloads.addAll(new SyncLandmarksAddedPacket(MapUtil.splitByKeyMap(this.landmarks, firstHalf)).toPayloads());
            payloads.addAll(new SyncLandmarksAddedPacket(MapUtil.splitByKeyMap(this.landmarks, secondHalf)).toPayloads());
        }
        return payloads;
    }

    public CustomPacketPayload.Type<SyncLandmarksAddedPacket> type() {
        return ID;
    }

    private static /* synthetic */ void lambda$toPayloads$0(Multimap firstHalf, Multimap keySet, Multimap secondHalf, LandmarkType key, BlockPos pos) {
        if (firstHalf.size() < keySet.size() / 2) {
            firstHalf.put((Object)key, (Object)pos);
        } else {
            secondHalf.put((Object)key, (Object)pos);
        }
    }
}

