/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.packet;

import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.landmark.Landmarks;
import folk.sisby.surveyor.structure.RegionStructureSummary;
import folk.sisby.surveyor.structure.StructureStartSummary;
import folk.sisby.surveyor.util.MapUtil;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;

public interface SurveyorPacketCodecs {
    public static final StreamCodec<FriendlyByteBuf, Map<ChunkPos, BitSet>> TERRAIN_KEYS = ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.VAR_LONG.map(ChunkPos::new, ChunkPos::toLong), (StreamCodec)ByteBufCodecs.fromCodec((Codec)ExtraCodecs.BIT_SET));
    public static final StreamCodec<FriendlyByteBuf, Multimap<ResourceKey<Structure>, ChunkPos>> STRUCTURE_KEYS = ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.STRUCTURE), (StreamCodec)ByteBufCodecs.VAR_LONG.map(ChunkPos::new, ChunkPos::toLong).apply(ByteBufCodecs.list())).map(MapUtil::asMultiMap, MapUtil::asListMap);
    public static final StreamCodec<FriendlyByteBuf, Map<ResourceKey<Structure>, LongSet>> STRUCTURE_KEYS_LONG_SET = ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.STRUCTURE), (StreamCodec)ByteBufCodecs.fromCodec((Codec)Codec.LONG_STREAM).map(LongOpenHashSet::toSet, LongCollection::longStream));
    public static final StreamCodec<FriendlyByteBuf, Multimap<LandmarkType<?>, BlockPos>> LANDMARK_KEYS = ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.fromCodec(LandmarkType.CODEC), (StreamCodec)BlockPos.STREAM_CODEC.apply(ByteBufCodecs.list())).map(MapUtil::asMultiMap, MapUtil::asListMap);
    public static final StreamCodec<RegistryFriendlyByteBuf, Map<UUID, PlayerSummary>> GROUP_SUMMARIES = ByteBufCodecs.map(HashMap::new, (StreamCodec)UUIDUtil.STREAM_CODEC, (StreamCodec)StreamCodec.ofMember(PlayerSummary.OfflinePlayerSummary::writeBuf, PlayerSummary.OfflinePlayerSummary::readBuf));
    public static final StreamCodec<FriendlyByteBuf, Map<ResourceKey<Structure>, Map<ChunkPos, StructureStartSummary>>> STRUCTURE_SUMMARIES = ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.STRUCTURE), (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.VAR_LONG.map(ChunkPos::new, ChunkPos::toLong), (StreamCodec)StreamCodec.ofMember((s, b) -> b.writeNbt((Tag)s.toNbt()), b -> RegionStructureSummary.readStructurePieceNbt(b.readNbt())).apply(ByteBufCodecs.list()).map(StructureStartSummary::new, StructureStartSummary::getChildren)));
    public static final StreamCodec<FriendlyByteBuf, Map<ResourceKey<Structure>, ResourceKey<StructureType<?>>>> STRUCTURE_TYPES = ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.STRUCTURE), (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.STRUCTURE_TYPE));
    public static final StreamCodec<FriendlyByteBuf, Multimap<ResourceKey<Structure>, TagKey<Structure>>> STRUCTURE_TAGS = ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.STRUCTURE), (StreamCodec)ByteBufCodecs.fromCodec((Codec)TagKey.hashedCodec((ResourceKey)Registries.STRUCTURE)).apply(ByteBufCodecs.list())).map(MapUtil::asMultiMap, MapUtil::asListMap);
    public static final StreamCodec<ByteBuf, Map<LandmarkType<?>, Map<BlockPos, Landmark<?>>>> LANDMARK_SUMMARIES = ByteBufCodecs.fromCodec(Landmarks.CODEC);
}

