/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.packet;

import com.mojang.serialization.Codec;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.packet.S2CPacket;
import folk.sisby.surveyor.packet.SurveyorPacket;
import folk.sisby.surveyor.terrain.ChunkSummary;
import folk.sisby.surveyor.terrain.RegionSummary;
import folk.sisby.surveyor.util.BitSetUtil;
import folk.sisby.surveyor.util.ListUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkPos;

public record S2CUpdateRegionPacket(boolean shared, ChunkPos regionPos, List<Integer> biomePalette, List<Integer> blockPalette, BitSet set, List<ChunkSummary> chunks) implements S2CPacket
{
    public static final CustomPacketPayload.Type<S2CUpdateRegionPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"surveyor", (String)"s2c_update_region"));
    public static final StreamCodec<FriendlyByteBuf, S2CUpdateRegionPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, S2CUpdateRegionPacket::shared, (StreamCodec)ByteBufCodecs.VAR_LONG.map(ChunkPos::new, ChunkPos::toLong), S2CUpdateRegionPacket::regionPos, (StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.list()), S2CUpdateRegionPacket::biomePalette, (StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.list()), S2CUpdateRegionPacket::blockPalette, (StreamCodec)ByteBufCodecs.fromCodec((Codec)ExtraCodecs.BIT_SET), S2CUpdateRegionPacket::set, (StreamCodec)StreamCodec.ofMember(ChunkSummary::writeBuf, ChunkSummary::new).apply(ByteBufCodecs.list()), S2CUpdateRegionPacket::chunks, S2CUpdateRegionPacket::new);

    public static S2CUpdateRegionPacket of(boolean shared, ChunkPos regionPos, RegionSummary summary, BitSet keys) {
        return summary.createUpdatePacket(shared, regionPos, keys);
    }

    @Override
    public List<SurveyorPacket> toPayloads() {
        ArrayList<SurveyorPacket> payloads = new ArrayList<SurveyorPacket>();
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        CODEC.encode((Object)buf, (Object)this);
        if (buf.readableBytes() < 0x100000) {
            payloads.add(this);
        } else {
            if (this.set.cardinality() == 1) {
                int bit = this.set.stream().findFirst().orElseThrow();
                Surveyor.LOGGER.error("Couldn't create a terrain update packet at {} - an individual chunk would be too large to send!", (Object)"[%d,%d]".formatted(this.regionPos.x + RegionSummary.xForBit(bit), this.regionPos.z + RegionSummary.zForBit(bit)));
                return List.of();
            }
            for (BitSet splitChunks : BitSetUtil.half(this.set)) {
                payloads.addAll(new S2CUpdateRegionPacket(this.shared, this.regionPos, this.biomePalette, this.blockPalette, splitChunks, ListUtil.splitSet(this.chunks, splitChunks, this.set)).toPayloads());
            }
        }
        return payloads;
    }

    public CustomPacketPayload.Type<S2CUpdateRegionPacket> type() {
        return ID;
    }
}

