/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.packet;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.packet.S2CPacket;
import folk.sisby.surveyor.packet.SurveyorPacket;
import folk.sisby.surveyor.packet.SurveyorPacketCodecs;
import folk.sisby.surveyor.structure.StructureStartSummary;
import folk.sisby.surveyor.structure.WorldStructureSummary;
import folk.sisby.surveyor.util.MapUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;

public record S2CStructuresAddedPacket(boolean shared, Map<ResourceKey<Structure>, Map<ChunkPos, StructureStartSummary>> structures, Map<ResourceKey<Structure>, ResourceKey<StructureType<?>>> types, Multimap<ResourceKey<Structure>, TagKey<Structure>> tags) implements S2CPacket
{
    public static final CustomPacketPayload.Type<S2CStructuresAddedPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"surveyor", (String)"s2c_structures_added"));
    public static final StreamCodec<FriendlyByteBuf, S2CStructuresAddedPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, S2CStructuresAddedPacket::shared, SurveyorPacketCodecs.STRUCTURE_SUMMARIES, S2CStructuresAddedPacket::structures, SurveyorPacketCodecs.STRUCTURE_TYPES, S2CStructuresAddedPacket::types, SurveyorPacketCodecs.STRUCTURE_TAGS, S2CStructuresAddedPacket::tags, S2CStructuresAddedPacket::new);

    public static S2CStructuresAddedPacket of(boolean shared, Multimap<ResourceKey<Structure>, ChunkPos> keys, WorldStructureSummary summary) {
        return summary.createUpdatePacket(shared, keys);
    }

    public static S2CStructuresAddedPacket of(boolean shared, ResourceKey<Structure> key, ChunkPos pos, WorldStructureSummary summary) {
        return S2CStructuresAddedPacket.of(shared, MapUtil.asMultiMap(Map.of(key, List.of(pos))), summary);
    }

    @Override
    public List<SurveyorPacket> toPayloads() {
        ArrayList<SurveyorPacket> payloads = new ArrayList<SurveyorPacket>();
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        CODEC.encode((Object)buf, (Object)this);
        if (buf.readableBytes() < 0x100000) {
            payloads.add(this);
        } else {
            Multimap<ResourceKey<Structure>, ChunkPos> keySet = MapUtil.keyMultiMap(this.structures);
            if (keySet.size() == 1) {
                Surveyor.LOGGER.error("Couldn't create a structure update packet for {} at {} - an individual structure would be too large to send!", (Object)((ResourceKey)keySet.keys().stream().findFirst().orElseThrow()).location(), keySet.values().stream().findFirst().orElseThrow());
                return List.of();
            }
            HashMultimap firstHalf = HashMultimap.create();
            HashMultimap secondHalf = HashMultimap.create();
            keySet.forEach((arg_0, arg_1) -> S2CStructuresAddedPacket.lambda$toPayloads$0((Multimap)firstHalf, keySet, (Multimap)secondHalf, arg_0, arg_1));
            payloads.addAll(new S2CStructuresAddedPacket(this.shared, MapUtil.splitByKeyMap(this.structures, firstHalf), MapUtil.splitByKeySet(this.types, firstHalf.keySet()), MapUtil.asMultiMap(MapUtil.splitByKeySet(this.tags.asMap(), firstHalf.keySet()))).toPayloads());
            payloads.addAll(new S2CStructuresAddedPacket(this.shared, MapUtil.splitByKeyMap(this.structures, secondHalf), MapUtil.splitByKeySet(this.types, secondHalf.keySet()), MapUtil.asMultiMap(MapUtil.splitByKeySet(this.tags.asMap(), secondHalf.keySet()))).toPayloads());
        }
        return payloads;
    }

    public CustomPacketPayload.Type<S2CStructuresAddedPacket> type() {
        return ID;
    }

    private static /* synthetic */ void lambda$toPayloads$0(Multimap firstHalf, Multimap keySet, Multimap secondHalf, ResourceKey key, ChunkPos pos) {
        if (firstHalf.size() < keySet.size() / 2) {
            firstHalf.put((Object)key, (Object)pos);
        } else {
            secondHalf.put((Object)key, (Object)pos);
        }
    }
}

