/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.packet;

import folk.sisby.surveyor.ServerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.packet.SurveyorPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public interface S2CPacket
extends SurveyorPacket {
    default public void send(Collection<ServerPlayer> players) {
        List<SurveyorPacket> split = this.toPayloads();
        if (split.isEmpty()) {
            return;
        }
        for (ServerPlayer player : players) {
            if (!ServerPlayNetworking.canSend((ServerPlayer)player, (CustomPacketPayload.Type)this.type()) || player.getServer().isSingleplayerOwner(player.getGameProfile())) continue;
            split.forEach(p -> ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)p));
        }
    }

    default public void send(ServerPlayer player) {
        this.send(List.of(player));
    }

    default public void send(ServerLevel world) {
        this.send(world.players());
    }

    default public void send(ServerPlayer sender, ServerLevel world) {
        ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>(world.players());
        players.remove(sender);
        this.send(players);
    }

    default public void send(ServerPlayer sender, ServerLevel world, NetworkMode mode) {
        if (mode.atMost(NetworkMode.SOLO)) {
            return;
        }
        ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>(world.players());
        players.remove(sender);
        if (sender != null && mode.atMost(NetworkMode.GROUP)) {
            ServerSummary.of(world.getServer()).groupOtherServerPlayers(Surveyor.getUuid(sender), world.getServer()).forEach(players::remove);
        }
        this.send(players);
    }

    default public void send(MinecraftServer server) {
        this.send(server.getPlayerList().getPlayers());
    }

    default public void send(ServerPlayer sender, MinecraftServer server) {
        ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>(server.getPlayerList().getPlayers());
        players.remove(sender);
        this.send(players);
    }
}

