/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.mixin.client;

import com.mojang.authlib.GameProfile;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.NetworkHandlerSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.client.SurveyorNetworkHandler;
import folk.sisby.surveyor.landmark.PlayerDeathLandmark;
import folk.sisby.surveyor.util.TextUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class MixinClientPlayNetworkHandler
implements SurveyorNetworkHandler {
    @Unique
    NetworkHandlerSummary surveyor$summary = null;

    @Override
    public NetworkHandlerSummary surveyor$getSummary() {
        return this.surveyor$summary;
    }

    @Override
    @Accessor
    public abstract GameProfile getProfile();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(Minecraft client, Connection clientConnection, CommonListenerCookie clientConnectionState, CallbackInfo ci) {
        ClientPacketListener self = (ClientPacketListener)this;
        this.surveyor$summary = new NetworkHandlerSummary(self);
    }

    @Inject(method={"onDeathMessage"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerEntity;showsDeathScreen()Z")})
    private void onDeathScreen(ClientboundPlayerCombatKillPacket packet, CallbackInfo ci) {
        if (!Surveyor.CONFIG.playerDeathLandmarks) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || player.level() == null) {
            return;
        }
        WorldSummary summary = WorldSummary.of(player.level());
        if (summary.isClient()) {
            if (summary.landmarks() == null) {
                return;
            }
            summary.landmarks().put(player.level(), new PlayerDeathLandmark(player.blockPosition(), SurveyorClient.getClientUuid(), TextUtil.stripInteraction(packet.message()), player.level().getDayTime(), player.getRandom().nextInt()));
        }
    }
}

