/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.mixin;

import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorWorld;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.landmark.HasPoiType;
import folk.sisby.surveyor.landmark.NetherPortalLandmark;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public class MixinServerWorld
implements SurveyorWorld {
    @Unique
    private WorldSummary surveyor$summary = null;

    @Override
    public WorldSummary surveyor$getSummary() {
        return this.surveyor$summary;
    }

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/dimension/DimensionOptions;chunkGenerator()Lnet/minecraft/world/gen/chunk/ChunkGenerator;")})
    public void loadSummary(CallbackInfo ci) {
        ServerLevel self = (ServerLevel)this;
        this.surveyor$summary = WorldSummary.load((Level)self, Surveyor.getSavePath((ResourceKey<Level>)self.dimension(), self.getServer()), false);
        SurveyorEvents.Invoke.worldLoad(self);
    }

    @Inject(method={"method_19499"}, at={@At(value="HEAD")})
    public void onPointOfInterestAdded(BlockPos blockPos, Holder<PoiType> poiType, CallbackInfo ci) {
        if (!Surveyor.CONFIG.netherPortalLandmarks) {
            return;
        }
        ServerLevel self = (ServerLevel)this;
        WorldSummary summary = WorldSummary.of((Level)self);
        if (summary.landmarks() != null && poiType.unwrapKey().orElse(null) == PoiTypes.NETHER_PORTAL && self.getBlockState(blockPos).hasProperty((Property)NetherPortalBlock.AXIS)) {
            summary.landmarks().put((Level)self, new NetherPortalLandmark(blockPos, (Direction.Axis)self.getBlockState(blockPos).getValue((Property)NetherPortalBlock.AXIS)));
        }
    }

    @Inject(method={"method_39222"}, at={@At(value="HEAD")})
    public void onPointOfInterestRemoved(BlockPos blockPos, CallbackInfo ci) {
        ServerLevel self = (ServerLevel)this;
        WorldSummary summary = WorldSummary.of((Level)self);
        if (summary.landmarks() == null) {
            return;
        }
        summary.landmarks().removeAll((Level)self, HasPoiType.class, blockPos);
    }
}

