/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.client;

import com.google.common.collect.Multimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.SurveyorNetworking;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.NetworkHandlerSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.packet.C2SKnownLandmarksPacket;
import folk.sisby.surveyor.packet.C2SKnownStructuresPacket;
import folk.sisby.surveyor.packet.C2SKnownTerrainPacket;
import folk.sisby.surveyor.packet.S2CGroupChangedPacket;
import folk.sisby.surveyor.packet.S2CGroupUpdatedPacket;
import folk.sisby.surveyor.packet.S2CPacket;
import folk.sisby.surveyor.packet.S2CStructuresAddedPacket;
import folk.sisby.surveyor.packet.S2CUpdateRegionPacket;
import folk.sisby.surveyor.packet.SyncLandmarksAddedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRemovedPacket;
import folk.sisby.surveyor.terrain.RegionSummary;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;

public class SurveyorClientNetworking {
    public static void init() {
        SurveyorNetworking.C2S_SENDER = p -> {
            if (!ClientPlayNetworking.canSend((CustomPacketPayload.Type)p.type())) {
                return;
            }
            p.toPayloads().forEach(ClientPlayNetworking::send);
        };
        ClientPlayNetworking.registerGlobalReceiver(S2CStructuresAddedPacket.ID, (packet, context) -> SurveyorClientNetworking.handleClient(packet, context, SurveyorClientNetworking::handleStructuresAdded));
        ClientPlayNetworking.registerGlobalReceiver(S2CUpdateRegionPacket.ID, (packet, context) -> SurveyorClientNetworking.handleClient(packet, context, SurveyorClientNetworking::handleTerrainAdded));
        ClientPlayNetworking.registerGlobalReceiver(S2CGroupChangedPacket.ID, (packet, context) -> SurveyorClientNetworking.handleClient(packet, context, SurveyorClientNetworking::handleGroupChanged));
        ClientPlayNetworking.registerGlobalReceiver(S2CGroupUpdatedPacket.ID, (packet, context) -> SurveyorClientNetworking.handleClient(packet, context, SurveyorClientNetworking::handleGroupUpdated));
        ClientPlayNetworking.registerGlobalReceiver(SyncLandmarksAddedPacket.ID, (packet, context) -> SurveyorClientNetworking.handleClient(packet, context, SurveyorClientNetworking::handleLandmarksAdded));
        ClientPlayNetworking.registerGlobalReceiver(SyncLandmarksRemovedPacket.ID, (packet, context) -> SurveyorClientNetworking.handleClient(packet, context, SurveyorClientNetworking::handleLandmarksRemoved));
    }

    private static void handleTerrainAdded(ClientLevel world, WorldSummary summary, S2CUpdateRegionPacket packet) {
        if (summary.terrain() == null) {
            return;
        }
        summary.terrain().getRegion(packet.regionPos()).readUpdatePacket(world.registryAccess(), packet);
        (packet.shared() ? SurveyorClient.getSharedExploration() : SurveyorClient.getPersonalExploration()).mergeRegion((ResourceKey<Level>)world.dimension(), packet.regionPos(), packet.set());
        SurveyorEvents.Invoke.terrainUpdated((Level)world, packet.set().stream().mapToObj(i -> RegionSummary.chunkForBit(packet.regionPos(), i)).toList());
    }

    private static void handleStructuresAdded(ClientLevel world, WorldSummary summary, S2CStructuresAddedPacket packet) {
        if (summary.structures() == null) {
            return;
        }
        Multimap<ResourceKey<Structure>, ChunkPos> keySet = summary.structures().readUpdatePacket((Level)world, packet);
        if (Minecraft.getInstance().player != null) {
            SurveyorExploration exploration = packet.shared() ? SurveyorClient.getSharedExploration() : SurveyorClient.getPersonalExploration();
            keySet.forEach((key, pos) -> exploration.addStructure((ResourceKey<Level>)world.dimension(), (ResourceKey<Structure>)key, (ChunkPos)pos));
        }
    }

    private static void handleGroupChanged(ClientLevel world, WorldSummary summary, S2CGroupChangedPacket packet) {
        if (!SurveyorClient.getSharedExploration().groupPlayers().equals(packet.players().keySet())) {
            SurveyorClient.getSharedExploration().groupPlayers().clear();
            SurveyorClient.getSharedExploration().groupPlayers().addAll(packet.players().keySet());
        }
        NetworkHandlerSummary.of(Minecraft.getInstance().getConnection()).mergeSummaries(packet.players());
        SurveyorClient.getSharedExploration().replaceTerrain((ResourceKey<Level>)world.dimension(), packet.regionBits());
        SurveyorClient.getSharedExploration().replaceStructures((ResourceKey<Level>)world.dimension(), packet.structureKeys());
        SurveyorClient.getExploration().updateClientForLandmarks((Level)world);
        if (summary != null) {
            if (summary.terrain() != null && Surveyor.CONFIG.networking.terrain.atLeast(NetworkMode.SOLO)) {
                new C2SKnownTerrainPacket(summary.terrain().bitSet(null)).send();
            }
            if (summary.structures() != null && Surveyor.CONFIG.networking.structures.atLeast(NetworkMode.SOLO)) {
                new C2SKnownStructuresPacket(summary.structures().keySet(null)).send();
            }
            if (summary.landmarks() != null && Surveyor.CONFIG.networking.landmarks.atLeast(NetworkMode.SOLO)) {
                new C2SKnownLandmarksPacket(summary.landmarks().keySet(null)).send();
            }
        }
    }

    private static void handleGroupUpdated(ClientLevel world, WorldSummary summary, S2CGroupUpdatedPacket packet) {
        NetworkHandlerSummary.of(Minecraft.getInstance().getConnection()).mergeSummaries(packet.players());
    }

    private static void handleLandmarksAdded(ClientLevel world, WorldSummary summary, SyncLandmarksAddedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        summary.landmarks().readUpdatePacket((Level)world, packet, null);
    }

    private static void handleLandmarksRemoved(ClientLevel world, WorldSummary summary, SyncLandmarksRemovedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        summary.landmarks().readUpdatePacket((Level)world, packet, null);
    }

    private static <T extends S2CPacket> void handleClient(T packet, ClientPlayNetworking.Context context, ClientPacketHandler<T> handler) {
        WorldSummary summary;
        ClientLevel world = context.client().level;
        WorldSummary worldSummary = summary = world == null ? null : WorldSummary.of((Level)world);
        if (summary != null && !summary.isClient()) {
            return;
        }
        Minecraft.getInstance().execute(() -> handler.handle(world, summary, packet));
    }

    public static interface ClientPacketHandler<T> {
        public void handle(ClientLevel var1, WorldSummary var2, T var3);
    }
}

