/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.landmark.Landmarks;
import folk.sisby.surveyor.landmark.SimplePointLandmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.util.TextUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;

public class SurveyorClientCommands {
    private static void informGroup(Map<UUID, PlayerSummary> group, Consumer<Component> feedback) {
        feedback.accept((Component)Component.literal((String)"You're sharing your map with ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"%d".formatted(group.size() - 1)).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)(" other" + (group.size() - 1 > 1 ? " players:" : " player:"))).withStyle(ChatFormatting.GOLD)));
        feedback.accept((Component)TextUtil.highlightStrings(group.entrySet().stream().filter(e -> !((UUID)e.getKey()).equals(SurveyorClient.getClientUuid())).map(e -> ((PlayerSummary)e.getValue()).username()).toList(), s -> ChatFormatting.WHITE).withStyle(ChatFormatting.GOLD));
    }

    private static int info(WorldSummary summary, SurveyorExploration exploration, SurveyorExploration groupExploration, Consumer<Component> feedback) {
        HashSet landmarks = new HashSet();
        HashSet waypoints = new HashSet();
        HashSet groupLandmarks = new HashSet();
        HashSet groupWaypoints = new HashSet();
        Map<UUID, PlayerSummary> group = SurveyorClient.getFriends();
        WorldLandmarks worldLandmarks = summary.landmarks();
        if (worldLandmarks != null) {
            worldLandmarks.asMap(exploration).forEach((type, inner) -> inner.forEach((pos, landmark) -> (landmark.owner() == null ? landmarks : waypoints).add(landmark)));
            worldLandmarks.asMap(groupExploration).forEach((type, inner) -> inner.forEach((pos, landmark) -> (landmark.owner() == null ? groupLandmarks : groupWaypoints).add(landmark)));
        }
        feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"---Map Exploration Summary---").withStyle(ChatFormatting.GRAY)));
        feedback.accept((Component)Component.literal((String)"You've explored ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)"%d".formatted(exploration.chunkCount())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" total chunks!").withStyle(ChatFormatting.AQUA)).append((Component)(group.size() <= 1 ? Component.empty() : Component.literal((String)" (").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)"%d".formatted(groupExploration.chunkCount())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" with friends)").withStyle(ChatFormatting.AQUA)))));
        feedback.accept((Component)Component.literal((String)"You've explored ").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)Component.literal((String)"%d".formatted(exploration.structureCount())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" structures!").withStyle(ChatFormatting.LIGHT_PURPLE)).append((Component)(group.size() <= 1 ? Component.empty() : Component.literal((String)" (").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)Component.literal((String)"%d".formatted(groupExploration.structureCount())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" with friends)").withStyle(ChatFormatting.LIGHT_PURPLE)))));
        feedback.accept((Component)Component.literal((String)"You've explored ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)"%d".formatted(landmarks.size())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" landmarks here!").withStyle(ChatFormatting.GREEN)).append((Component)(group.size() <= 1 ? Component.empty() : Component.literal((String)" (").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)"%d".formatted(groupLandmarks.size())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" with friends)").withStyle(ChatFormatting.GREEN)))));
        feedback.accept((Component)Component.literal((String)"...and created ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)"%d".formatted(waypoints.size())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" waypoints!").withStyle(ChatFormatting.GREEN)).append((Component)(group.size() <= 1 ? Component.empty() : Component.literal((String)" (").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)"%d".formatted(groupWaypoints.size())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" with friends)").withStyle(ChatFormatting.GREEN)))));
        if (group.size() > 1) {
            SurveyorClientCommands.informGroup(SurveyorClient.getFriends(), feedback);
        }
        feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"-------End Summary-------").withStyle(ChatFormatting.GRAY)));
        return 1;
    }

    private static int landmarkInfo(WorldSummary summary, SurveyorExploration exploration, SurveyorExploration groupExploration, Consumer<Component> feedback) {
        Collection<PlayerSummary> group = SurveyorClient.getFriends().values();
        feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"---World Landmark Types---").withStyle(ChatFormatting.GRAY)));
        HashSet<LandmarkType> waypoints = new HashSet<LandmarkType>();
        HashMultimap keys = HashMultimap.create();
        HashMultimap groupKeys = HashMultimap.create();
        HashMultimap personalKeys = HashMultimap.create();
        WorldLandmarks worldLandmarks = summary.landmarks();
        if (worldLandmarks != null) {
            waypoints.addAll(worldLandmarks.asMap(null).values().stream().flatMap(e -> e.values().stream().filter(l -> l.owner() != null)).map(Landmark::type).toList());
            keys.putAll(worldLandmarks.keySet(null));
            groupKeys.putAll(worldLandmarks.keySet(groupExploration));
            personalKeys.putAll(worldLandmarks.keySet(exploration));
        }
        keys.asMap().forEach((arg_0, arg_1) -> SurveyorClientCommands.lambda$landmarkInfo$9(feedback, waypoints, (Multimap)personalKeys, group, (Multimap)groupKeys, (Multimap)keys, arg_0, arg_1));
        feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"-------End Landmarks-------").withStyle(ChatFormatting.GRAY)));
        return 1;
    }

    private static int getLandmarks(WorldSummary summary, Consumer<Component> feedback, ResourceLocation type) {
        if (summary.landmarks() == null) {
            feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"The landmark system is dynamically disabled!").withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        Map<BlockPos, ?> landmarks = summary.landmarks().asMap(Landmarks.getType(type), null);
        if (landmarks.isEmpty()) {
            feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"There are no landmarks of that type in this world!").withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"---World %s Landmarks---".formatted(type)).withStyle(ChatFormatting.GRAY)));
        for (Landmark landmark : landmarks.values()) {
            feedback.accept((Component)Component.literal((String)"[").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)landmark.pos().toShortString()).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)"]").withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)" - ").withStyle(landmark.owner() != null ? ChatFormatting.GREEN : ChatFormatting.RED)).append((Component)Component.literal((String)"\"").withStyle(ChatFormatting.GOLD)).append((Component)(landmark.name() == null ? Component.nullToEmpty((String)"") : landmark.name().copy().withStyle(s -> s.withColor(landmark.color() != null ? landmark.color().getFireworkColor() : ChatFormatting.WHITE.getColor().intValue())))).append((Component)Component.literal((String)"\"").withStyle(ChatFormatting.GOLD)));
        }
        feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"---End %s Landmarks---".formatted(type)).withStyle(ChatFormatting.GRAY)));
        return landmarks.size();
    }

    private static int removeLandmark(WorldSummary summary, ClientLevel world, Consumer<Component> feedback, ResourceLocation type, BlockPos pos) {
        if (summary.landmarks() == null) {
            feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"The landmark system is dynamically disabled!").withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        if (!summary.landmarks().contains(Landmarks.getType(type), pos)) {
            feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"No landmark exists of that type and position!").withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        Landmark<?> landmark = summary.landmarks().get(Landmarks.getType(type), pos);
        summary.landmarks().remove((Level)world, Landmarks.getType(type), pos);
        feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"%s removed successfully!".formatted(landmark.owner() == null ? "Landmark" : "Waypoint")).withStyle(ChatFormatting.GREEN)));
        return 1;
    }

    private static int addLandmark(WorldSummary summary, ClientLevel world, Consumer<Component> feedback, ResourceLocation type, BlockPos pos, DyeColor color, String name, boolean global) {
        if (summary.landmarks() == null) {
            feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"The landmark system is dynamically disabled!").withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        if (!SimplePointLandmark.TYPE.id().equals((Object)type)) {
            feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"You can't create a landmark of that type!").withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        if (summary.landmarks().contains(Landmarks.getType(type), pos)) {
            feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"A landmark exists of that type and position!").withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        summary.landmarks().put((Level)world, new SimplePointLandmark(pos, global ? null : SurveyorClient.getClientUuid(), color, Component.nullToEmpty((String)(name.contains("\\n") ? name.substring(0, name.indexOf("\\n")) : name)), name.contains("\\n") ? Component.nullToEmpty((String)name.substring(name.indexOf("\\n") + 2)) : null, null));
        feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"%s added successfully!".formatted(global ? "Landmark" : "Waypoint")).withStyle(ChatFormatting.GREEN)));
        return 1;
    }

    public static int execute(CommandContext<FabricClientCommandSource> context, SurveyorCommandExecutor<Integer> executor) {
        LocalPlayer player = ((FabricClientCommandSource)context.getSource()).getPlayer();
        SurveyorExploration exploration = SurveyorClient.getPersonalExploration();
        SurveyorClient.ClientExploration groupExploration = SurveyorClient.getSharedExploration();
        try {
            return executor.execute(WorldSummary.of((Level)((FabricClientCommandSource)context.getSource()).getWorld()), player, ((FabricClientCommandSource)context.getSource()).getWorld(), exploration, groupExploration, t -> ((FabricClientCommandSource)context.getSource()).sendFeedback(t));
        }
        catch (Exception e) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((Component)Component.literal((String)"Command failed! Check log for details.").withStyle(ChatFormatting.RED));
            Surveyor.LOGGER.error("[Surveyor] Error while executing command: {}", (Object)context.getInput(), (Object)e);
            return 0;
        }
    }

    private static CommandSourceStack sourceForPos(FabricClientCommandSource source) {
        return new CommandSourceStack(null, source.getPosition(), source.getRotation(), null, 0, null, null, null, source.getEntity());
    }

    public static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, CommandBuildContext registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"surveyorc").executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (s, p, w, e, g, f) -> SurveyorClientCommands.info(s, e, g, f)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"landmarks").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.DISABLED)).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (s, p, w, e, g, f) -> SurveyorClientCommands.landmarkInfo(s, e, g, f)))).then(ClientCommandManager.literal((String)"get").then(ClientCommandManager.argument((String)"type", (ArgumentType)ResourceLocationArgument.id()).suggests((c, b) -> SharedSuggestionProvider.suggestResource(Landmarks.keySet(), (SuggestionsBuilder)b)).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (s, p, w, e, g, f) -> SurveyorClientCommands.getLandmarks(s, f, (ResourceLocation)c.getArgument("type", ResourceLocation.class))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"remove").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(ClientCommandManager.argument((String)"type", (ArgumentType)ResourceLocationArgument.id()).suggests((c, b) -> SharedSuggestionProvider.suggestResource(Landmarks.keySet(), (SuggestionsBuilder)b)).then(ClientCommandManager.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (s, p, w, e, g, f) -> SurveyorClientCommands.removeLandmark(s, w, f, (ResourceLocation)c.getArgument("type", ResourceLocation.class), ((WorldCoordinates)c.getArgument("pos", WorldCoordinates.class)).getBlockPos(SurveyorClientCommands.sourceForPos((FabricClientCommandSource)c.getSource()))))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"add").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(ClientCommandManager.argument((String)"type", (ArgumentType)ResourceLocationArgument.id()).suggests((c, b) -> SharedSuggestionProvider.suggestResource(List.of(SimplePointLandmark.TYPE.id()), (SuggestionsBuilder)b)).then(ClientCommandManager.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(ClientCommandManager.argument((String)"color", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.suggest(Arrays.stream(DyeColor.values()).map(DyeColor::getName), (SuggestionsBuilder)b)).then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (s, p, w, e, g, f) -> SurveyorClientCommands.addLandmark(s, w, f, (ResourceLocation)c.getArgument("type", ResourceLocation.class), ((WorldCoordinates)c.getArgument("pos", WorldCoordinates.class)).getBlockPos(SurveyorClientCommands.sourceForPos((FabricClientCommandSource)c.getSource())), DyeColor.byName((String)((String)c.getArgument("color", String.class)), (DyeColor)DyeColor.WHITE), (String)c.getArgument("name", String.class), false))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"global").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).requires(c -> c.getPlayer() == null || c.getPlayer().hasPermissions(2))).then(ClientCommandManager.argument((String)"type", (ArgumentType)ResourceLocationArgument.id()).suggests((c, b) -> SharedSuggestionProvider.suggestResource(List.of(SimplePointLandmark.TYPE.id()), (SuggestionsBuilder)b)).then(ClientCommandManager.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(ClientCommandManager.argument((String)"color", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.suggest(Arrays.stream(DyeColor.values()).map(DyeColor::getName), (SuggestionsBuilder)b)).then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (s, p, w, e, g, f) -> SurveyorClientCommands.addLandmark(s, w, f, (ResourceLocation)c.getArgument("type", ResourceLocation.class), ((WorldCoordinates)c.getArgument("pos", WorldCoordinates.class)).getBlockPos(SurveyorClientCommands.sourceForPos((FabricClientCommandSource)c.getSource())), DyeColor.byName((String)((String)c.getArgument("color", String.class)), (DyeColor)DyeColor.WHITE), (String)c.getArgument("name", String.class), true))))))))));
    }

    private static /* synthetic */ void lambda$landmarkInfo$9(Consumer feedback, Set waypoints, Multimap personalKeys, Collection group, Multimap groupKeys, Multimap keys, LandmarkType type, Collection list) {
        feedback.accept(Component.literal((String)"%s".formatted(type.id())).withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)(waypoints.contains(type) ? ": created " : ": explored ")).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)"%d".formatted(personalKeys.get((Object)type).size())).withStyle(ChatFormatting.WHITE)).append((Component)(group.size() <= 1 ? Component.empty() : Component.literal((String)" (").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)Component.literal((String)"%d".formatted(groupKeys.get((Object)type).size())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" shared)").withStyle(ChatFormatting.LIGHT_PURPLE)))).append((Component)Component.literal((String)" {of ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"%d".formatted(keys.get((Object)type).size())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)"}").withStyle(ChatFormatting.GOLD))));
    }

    public static interface SurveyorCommandExecutor<T> {
        public T execute(WorldSummary var1, LocalPlayer var2, ClientLevel var3, SurveyorExploration var4, SurveyorExploration var5, Consumer<Component> var6);
    }
}

