/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.ServerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.SurveyorClientEvents;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.terrain.RegionSummary;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;

public interface SurveyorExploration {
    public static final String KEY_EXPLORED_TERRAIN = "exploredTerrain";
    public static final String KEY_EXPLORED_STRUCTURES = "exploredStructures";

    public static SurveyorExploration of(ServerPlayer player) {
        return PlayerSummary.of(player).exploration();
    }

    public static SurveyorExploration of(UUID player, MinecraftServer server) {
        return ServerSummary.of(server).getExploration(player, server);
    }

    public static SurveyorExploration ofShared(ServerPlayer player) {
        return SurveyorExploration.ofShared(Surveyor.getUuid(player), player.getServer());
    }

    public static SurveyorExploration ofShared(UUID player, MinecraftServer server) {
        return ServerSummary.of(server).groupExploration(player, server);
    }

    public Map<ResourceKey<Level>, Map<ChunkPos, BitSet>> terrain();

    public Map<ResourceKey<Level>, Map<ResourceKey<Structure>, LongSet>> structures();

    public Set<UUID> sharedPlayers();

    default public void copyFrom(SurveyorExploration oldExploration) {
        this.terrain().putAll(oldExploration.terrain());
        this.structures().putAll(oldExploration.structures());
    }

    public boolean personal();

    default public boolean exploredChunk(ResourceKey<Level> worldKey, ChunkPos pos) {
        ChunkPos regionPos = new ChunkPos(pos.getRegionX(), pos.getRegionZ());
        Map<ChunkPos, BitSet> regions = this.terrain().get(worldKey);
        return !this.personal() && Surveyor.CONFIG.networking.terrain.atLeast(NetworkMode.SERVER) || regions != null && regions.containsKey(regionPos) && regions.get(regionPos).get(RegionSummary.bitForChunk(pos));
    }

    default public boolean exploredStructure(ResourceKey<Level> worldKey, ResourceKey<Structure> structure, ChunkPos pos) {
        Map<ResourceKey<Structure>, LongSet> structures = this.structures().get(worldKey);
        return !this.personal() && Surveyor.CONFIG.networking.structures.atLeast(NetworkMode.SERVER) || structures != null && structures.containsKey(structure) && structures.get(structure).contains(pos.toLong());
    }

    default public boolean exploredLandmark(ResourceKey<Level> worldKey, Landmark<?> landmark) {
        return landmark.owner() == null ? this.exploredChunk(worldKey, new ChunkPos(landmark.pos())) : this.sharedPlayers().contains(landmark.owner());
    }

    default public int chunkCount() {
        return this.terrain().values().stream().flatMap(m -> m.values().stream()).mapToInt(BitSet::cardinality).sum();
    }

    default public int structureCount() {
        return this.structures().values().stream().flatMap(m -> m.values().stream()).mapToInt(Set::size).sum();
    }

    default public BitSet limitTerrainBitset(ResourceKey<Level> worldKey, ChunkPos rPos, BitSet bitSet) {
        if (!this.personal() && Surveyor.CONFIG.networking.terrain.atLeast(NetworkMode.SERVER)) {
            return bitSet;
        }
        if (this.terrain().get(worldKey) == null || !this.terrain().get(worldKey).containsKey(rPos)) {
            bitSet.clear();
        } else {
            bitSet.and(this.terrain().get(worldKey).get(rPos));
        }
        return bitSet;
    }

    default public Map<ChunkPos, BitSet> limitTerrainBitset(ResourceKey<Level> worldKey, Map<ChunkPos, BitSet> bitSet) {
        if (!this.personal() && Surveyor.CONFIG.networking.terrain.atLeast(NetworkMode.SERVER)) {
            return bitSet;
        }
        Map<ChunkPos, BitSet> regions = this.terrain().get(worldKey);
        if (regions == null) {
            bitSet.clear();
        } else {
            bitSet.forEach((rPos, set) -> this.limitTerrainBitset(worldKey, (ChunkPos)rPos, (BitSet)set));
        }
        return bitSet;
    }

    default public Multimap<ResourceKey<Structure>, ChunkPos> limitStructureKeySet(ResourceKey<Level> worldKey, Multimap<ResourceKey<Structure>, ChunkPos> keySet) {
        if (!this.personal() && Surveyor.CONFIG.networking.structures.atLeast(NetworkMode.SERVER)) {
            return keySet;
        }
        Map<ResourceKey<Structure>, LongSet> structures = this.structures().get(worldKey);
        if (structures == null) {
            keySet.clear();
        } else {
            keySet.keySet().removeIf(key -> !structures.containsKey(key));
            keySet.entries().removeIf(e -> !((LongSet)structures.get(e.getKey())).contains(((ChunkPos)e.getValue()).toLong()));
        }
        return keySet;
    }

    default public Map<LandmarkType<?>, Map<BlockPos, Landmark<?>>> limitLandmarkMap(ResourceKey<Level> worldKey, Map<LandmarkType<?>, Map<BlockPos, Landmark<?>>> asMap) {
        HashMultimap toRemove = HashMultimap.create();
        asMap.forEach((arg_0, arg_1) -> this.lambda$limitLandmarkMap$6(worldKey, (Multimap)toRemove, arg_0, arg_1));
        toRemove.forEach((type, pos) -> {
            ((Map)asMap.get(type)).remove(pos);
            if (((Map)asMap.get(type)).isEmpty()) {
                asMap.remove(type);
            }
        });
        return asMap;
    }

    default public Multimap<LandmarkType<?>, BlockPos> limitLandmarkKeySet(ResourceKey<Level> worldKey, WorldLandmarks worldLandmarks, Multimap<LandmarkType<?>, BlockPos> keySet) {
        HashMultimap toRemove = HashMultimap.create();
        keySet.forEach((arg_0, arg_1) -> this.lambda$limitLandmarkKeySet$8(worldLandmarks, worldKey, (Multimap)toRemove, arg_0, arg_1));
        toRemove.forEach((arg_0, arg_1) -> keySet.remove(arg_0, arg_1));
        return keySet;
    }

    default public void updateClientForMergeRegion(Level world, ChunkPos regionPos, BitSet bitSet) {
        Set<ChunkPos> terrainKeys = bitSet.stream().mapToObj(i -> RegionSummary.chunkForBit(regionPos, i)).collect(Collectors.toSet());
        SurveyorClientEvents.Invoke.terrainUpdated(world, terrainKeys);
        HashMultimap landmarkKeys = HashMultimap.create();
        WorldLandmarks summary = WorldSummary.of(world).landmarks();
        if (summary == null) {
            return;
        }
        summary.asMap(this).forEach((arg_0, arg_1) -> SurveyorExploration.lambda$updateClientForMergeRegion$11(terrainKeys, (Multimap)landmarkKeys, arg_0, arg_1));
        SurveyorClientEvents.Invoke.landmarksAdded(world, landmarkKeys);
    }

    default public void updateClientForLandmarks(Level world) {
        WorldLandmarks summary = WorldSummary.of(world).landmarks();
        if (summary == null) {
            return;
        }
        Multimap<LandmarkType<?>, BlockPos> unexploredLandmarks = summary.keySet(null);
        Multimap<LandmarkType<?>, BlockPos> exploredLandmarks = summary.keySet(this);
        exploredLandmarks.forEach((arg_0, arg_1) -> unexploredLandmarks.remove(arg_0, arg_1));
        SurveyorClientEvents.Invoke.landmarksAdded(world, exploredLandmarks);
        SurveyorClientEvents.Invoke.landmarksRemoved(world, unexploredLandmarks);
    }

    default public void mergeRegion(ResourceKey<Level> worldKey, ChunkPos regionPos, BitSet bitSet) {
        this.terrain().computeIfAbsent(worldKey, k -> new HashMap()).computeIfAbsent(regionPos, p -> new BitSet(32)).or(bitSet);
    }

    default public void replaceTerrain(ResourceKey<Level> worldKey, Map<ChunkPos, BitSet> bitSet) {
        Map<ChunkPos, BitSet> oldSet = this.terrain().get(worldKey);
        if (oldSet != null) {
            oldSet.clear();
        }
        bitSet.forEach((pos, set) -> this.mergeRegion(worldKey, (ChunkPos)pos, (BitSet)set));
    }

    default public void updateClientForAddChunk(Level world, ChunkPos chunkPos) {
        SurveyorClientEvents.Invoke.terrainUpdated(world, chunkPos);
        HashMultimap landmarkKeys = HashMultimap.create();
        WorldLandmarks summary = WorldSummary.of(world).landmarks();
        if (summary == null) {
            return;
        }
        summary.asMap(this).forEach((arg_0, arg_1) -> SurveyorExploration.lambda$updateClientForAddChunk$16(chunkPos, (Multimap)landmarkKeys, arg_0, arg_1));
        SurveyorClientEvents.Invoke.landmarksAdded(world, landmarkKeys);
    }

    default public void addChunk(ResourceKey<Level> worldKey, ChunkPos pos) {
        this.terrain().computeIfAbsent(worldKey, k -> new HashMap()).computeIfAbsent(new ChunkPos(pos.getRegionX(), pos.getRegionZ()), k -> new BitSet(1024)).set(RegionSummary.bitForChunk(pos));
    }

    default public void updateClientForAddStructure(Level world, ResourceKey<Structure> structureKey, ChunkPos pos) {
        SurveyorClientEvents.Invoke.structuresAdded(world, structureKey, pos);
    }

    default public void addStructure(ResourceKey<Level> worldKey, ResourceKey<Structure> structureKey, ChunkPos pos) {
        this.structures().computeIfAbsent(worldKey, k -> new HashMap()).computeIfAbsent(structureKey, s -> new LongOpenHashSet()).add(pos.toLong());
    }

    default public void mergeStructures(ResourceKey<Level> worldKey, ResourceKey<Structure> structureKey, LongSet starts) {
        this.structures().computeIfAbsent(worldKey, k -> new HashMap()).computeIfAbsent(structureKey, s -> new LongOpenHashSet()).addAll((LongCollection)starts);
    }

    default public void replaceStructures(ResourceKey<Level> worldKey, Map<ResourceKey<Structure>, LongSet> structures) {
        LongSet oldSet = structures.get(worldKey);
        if (oldSet != null) {
            oldSet.clear();
        }
        structures.forEach((key, set) -> this.mergeStructures(worldKey, (ResourceKey<Structure>)key, (LongSet)set));
    }

    default public CompoundTag write(CompoundTag nbt) {
        CompoundTag terrainCompound = new CompoundTag();
        this.terrain().forEach((worldKey, map) -> {
            LongArrayList regionLongs = new LongArrayList();
            for (Map.Entry entry : map.entrySet()) {
                regionLongs.add(((ChunkPos)entry.getKey()).toLong());
                if (((BitSet)entry.getValue()).cardinality() == 1024) {
                    regionLongs.add(-1L);
                    continue;
                }
                long[] regionBits = ((BitSet)entry.getValue()).toLongArray();
                regionLongs.add((long)regionBits.length);
                regionLongs.addAll(LongList.of((long[])regionBits));
            }
            terrainCompound.putLongArray(worldKey.location().toString(), regionLongs.toLongArray());
        });
        nbt.put(KEY_EXPLORED_TERRAIN, (Tag)terrainCompound);
        CompoundTag structuresCompound = new CompoundTag();
        this.structures().forEach((worldKey, map) -> {
            CompoundTag worldStructuresCompound = new CompoundTag();
            for (ResourceKey structure : map.keySet()) {
                worldStructuresCompound.putLongArray(structure.location().toString(), ((LongSet)map.get(structure)).toLongArray());
            }
            structuresCompound.put(worldKey.location().toString(), (Tag)worldStructuresCompound);
        });
        nbt.put(KEY_EXPLORED_STRUCTURES, (Tag)structuresCompound);
        return nbt;
    }

    default public void read(CompoundTag nbt) {
        CompoundTag terrainCompound = nbt.getCompound(KEY_EXPLORED_TERRAIN);
        for (String worldKeyString : terrainCompound.getAllKeys()) {
            long[] regionArray = terrainCompound.getLongArray(worldKeyString);
            HashMap<ChunkPos, BitSet> regionMap = new HashMap<ChunkPos, BitSet>();
            int i = 0;
            while (i + 1 < regionArray.length) {
                ChunkPos rPos = new ChunkPos(regionArray[i]);
                int bitLength = (int)regionArray[i + 1];
                if (bitLength == -1) {
                    BitSet set = new BitSet(1024);
                    set.set(0, 1024);
                    regionMap.put(rPos, set);
                } else {
                    long[] bitArray = new long[bitLength];
                    System.arraycopy(regionArray, i + 2, bitArray, 0, bitLength);
                    regionMap.put(rPos, BitSet.valueOf(bitArray));
                    i += bitLength;
                }
                i += 2;
            }
            this.terrain().put((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)worldKeyString)), regionMap);
        }
        CompoundTag structuresCompound = nbt.getCompound(KEY_EXPLORED_STRUCTURES);
        for (String worldKeyString : structuresCompound.getAllKeys()) {
            HashMap<ResourceKey, LongOpenHashSet> structureMap = new HashMap<ResourceKey, LongOpenHashSet>();
            CompoundTag worldStructuresCompound = structuresCompound.getCompound(worldKeyString);
            for (String key : worldStructuresCompound.getAllKeys()) {
                structureMap.put(ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.parse((String)key)), new LongOpenHashSet(worldStructuresCompound.getLongArray(key)));
            }
            this.structures().put((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)worldKeyString)), structureMap);
        }
    }

    private static /* synthetic */ void lambda$updateClientForAddChunk$16(ChunkPos chunkPos, Multimap landmarkKeys, LandmarkType type, Map map) {
        map.forEach((pos, mark) -> {
            if (chunkPos.equals((Object)new ChunkPos(pos)) && mark.owner() == null) {
                landmarkKeys.put((Object)type, pos);
            }
        });
    }

    private static /* synthetic */ void lambda$updateClientForMergeRegion$11(Set terrainKeys, Multimap landmarkKeys, LandmarkType type, Map map) {
        map.forEach((pos, mark) -> {
            if (terrainKeys.contains(new ChunkPos(pos)) && mark.owner() == null) {
                landmarkKeys.put((Object)type, pos);
            }
        });
    }

    private /* synthetic */ void lambda$limitLandmarkKeySet$8(WorldLandmarks worldLandmarks, ResourceKey worldKey, Multimap toRemove, LandmarkType type, BlockPos pos) {
        if (!worldLandmarks.contains(type, pos) || !this.exploredLandmark((ResourceKey<Level>)worldKey, worldLandmarks.get(type, pos))) {
            toRemove.put((Object)type, (Object)pos);
        }
    }

    private /* synthetic */ void lambda$limitLandmarkMap$6(ResourceKey worldKey, Multimap toRemove, LandmarkType type, Map map) {
        map.forEach((pos, landmark) -> {
            if (!this.exploredLandmark((ResourceKey<Level>)worldKey, (Landmark<?>)landmark)) {
                toRemove.put((Object)type, pos);
            }
        });
    }
}

